/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import java.lang.reflect.Field;
import java.util.Deque;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.MDCAdapter;

final class DelegatingLogbackMDCAdapter
extends LogbackMDCAdapter {
    private final MDCAdapter delegate;

    static void maybeUpdateMdcAdapter(MDCAdapter adapter) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        try {
            Field mdcAdapter = LoggerContext.class.getDeclaredField("mdcAdapter");
            mdcAdapter.setAccessible(true);
            mdcAdapter.set(loggerContext, (Object)new DelegatingLogbackMDCAdapter(adapter));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    private DelegatingLogbackMDCAdapter(MDCAdapter delegate) {
        this.delegate = delegate;
    }

    public void put(String key, String val) {
        this.delegate.put(key, val);
    }

    public String get(String key) {
        return this.delegate.get(key);
    }

    public void remove(String key) {
        this.delegate.remove(key);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Map<String, String> getPropertyMap() {
        return this.delegate.getCopyOfContextMap();
    }

    public Map getCopyOfContextMap() {
        return this.delegate.getCopyOfContextMap();
    }

    public void setContextMap(Map contextMap) {
        this.delegate.setContextMap(contextMap);
    }

    public void pushByKey(String key, String value) {
        this.delegate.pushByKey(key, value);
    }

    public String popByKey(String key) {
        return this.delegate.popByKey(key);
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        return this.delegate.getCopyOfDequeByKey(key);
    }

    public void clearDequeByKey(String key) {
        this.delegate.clearDequeByKey(key);
    }
}

