/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.event;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.oap.server.analyzer.event.EventAnalyzer;
import org.apache.skywalking.oap.server.analyzer.event.EventAnalyzerService;
import org.apache.skywalking.oap.server.analyzer.event.listener.EventAnalyzerListener;
import org.apache.skywalking.oap.server.analyzer.event.listener.IEventAnalyzerListenerManager;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAnalyzerServiceImpl
implements EventAnalyzerService,
IEventAnalyzerListenerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventAnalyzerServiceImpl.class);
    private final ModuleManager moduleManager;
    private final List<EventAnalyzerListener.Factory> factories = new ArrayList<EventAnalyzerListener.Factory>();

    @Override
    public void analyze(Event event) {
        Event.Builder eb = event.toBuilder();
        if (event.getStartTime() <= 0L && event.getEndTime() <= 0L) {
            log.warn("Event start time {} and end time {} are both invalid, they will be set to current time, eventId: {}", new Object[]{event.getStartTime(), event.getEndTime(), event.getUuid()});
            eb.setStartTime(System.currentTimeMillis());
            eb.setEndTime(System.currentTimeMillis());
        }
        EventAnalyzer analyzer = new EventAnalyzer(this.moduleManager, this);
        analyzer.analyze(eb.build());
    }

    @Override
    public void add(EventAnalyzerListener.Factory factory) {
        this.factories.add(factory);
    }

    @Override
    public List<EventAnalyzerListener.Factory> getEventAnalyzerListenerFactories() {
        return this.factories;
    }

    @Generated
    public EventAnalyzerServiceImpl(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

