/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.AnalysisListenerFactory;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.EntryAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.ExitAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.LocalAnalysisListener;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualCacheProcessor;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualDatabaseProcessor;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualMQProcessor;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualServiceProcessor;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class VirtualServiceAnalysisListener
implements ExitAnalysisListener,
LocalAnalysisListener,
EntryAnalysisListener {
    private final SourceReceiver sourceReceiver;
    private final List<VirtualServiceProcessor> virtualServiceProcessors;

    @Override
    public void build() {
        this.virtualServiceProcessors.forEach(p -> p.emitTo(arg_0 -> ((SourceReceiver)this.sourceReceiver).receive(arg_0)));
    }

    @Override
    public boolean containsPoint(AnalysisListener.Point point) {
        return point == AnalysisListener.Point.Local || point == AnalysisListener.Point.Exit || point == AnalysisListener.Point.Entry;
    }

    @Override
    public void parseExit(SpanObject span, SegmentObject segmentObject) {
        this.virtualServiceProcessors.forEach(p -> p.prepareVSIfNecessary(span, segmentObject));
    }

    @Override
    public void parseLocal(SpanObject span, SegmentObject segmentObject) {
        this.virtualServiceProcessors.forEach(p -> p.prepareVSIfNecessary(span, segmentObject));
    }

    @Override
    public void parseEntry(SpanObject span, SegmentObject segmentObject) {
        this.virtualServiceProcessors.forEach(p -> p.prepareVSIfNecessary(span, segmentObject));
    }

    @Generated
    public VirtualServiceAnalysisListener(SourceReceiver sourceReceiver, List<VirtualServiceProcessor> virtualServiceProcessors) {
        this.sourceReceiver = sourceReceiver;
        this.virtualServiceProcessors = virtualServiceProcessors;
    }

    public static class Factory
    implements AnalysisListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public AnalysisListener create(ModuleManager moduleManager, AnalyzerModuleConfig config) {
            return new VirtualServiceAnalysisListener(this.sourceReceiver, Arrays.asList(new VirtualCacheProcessor(this.namingControl, config), new VirtualDatabaseProcessor(this.namingControl, config), new VirtualMQProcessor(this.namingControl)));
        }
    }
}

