/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.version;

import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;

public enum Version {
    CURRENT;

    private final String buildVersion;
    private final String commitId;
    private final Properties properties = new Properties();

    private Version() {
        try {
            this.properties.load(Version.class.getClassLoader().getResourceAsStream("version.properties"));
            this.buildVersion = this.properties.getProperty("git.build.version");
            this.commitId = this.properties.getProperty("git.commit.id");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public String toString() {
        return String.format("%s-%s", this.buildVersion, Strings.left((String)this.commitId, (int)7));
    }

    @Generated
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Generated
    public String getCommitId() {
        return this.commitId;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }
}

