/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.continuous;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingMonitorType;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicyConfiguration;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingMonitoringInstance;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingMonitoringProcess;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingPolicyItem;
import org.apache.skywalking.oap.server.core.query.type.ContinuousProfilingPolicyTarget;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskContinuousProfiling;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousProfilingQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContinuousProfilingQueryService.class);
    private static final Gson GSON = new Gson();
    private static final int RECENT_TRIGGERED_HOURS = 48;
    private final ModuleManager moduleManager;
    private IContinuousProfilingPolicyDAO policyDAO;
    private IMetadataQueryDAO metadataQueryDAO;
    private IEBPFProfilingTaskDAO ebpfProfilingTaskDAO;

    public IContinuousProfilingPolicyDAO getPolicyDAO() {
        if (this.policyDAO == null) {
            this.policyDAO = (IContinuousProfilingPolicyDAO)this.moduleManager.find("storage").provider().getService(IContinuousProfilingPolicyDAO.class);
        }
        return this.policyDAO;
    }

    public IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    public IEBPFProfilingTaskDAO getEbpfProfilingTaskDAO() {
        if (this.ebpfProfilingTaskDAO == null) {
            this.ebpfProfilingTaskDAO = (IEBPFProfilingTaskDAO)this.moduleManager.find("storage").provider().getService(IEBPFProfilingTaskDAO.class);
        }
        return this.ebpfProfilingTaskDAO;
    }

    public List<ContinuousProfilingPolicyTarget> queryContinuousProfilingServiceTargets(String serviceId) throws IOException {
        List<ContinuousProfilingPolicy> policies = this.getPolicyDAO().queryPolicies(Arrays.asList(serviceId));
        if (CollectionUtils.isEmpty(policies)) {
            return Collections.emptyList();
        }
        ContinuousProfilingPolicy policy = policies.get(0);
        ContinuousProfilingPolicyConfiguration configuration = ContinuousProfilingPolicyConfiguration.parseFromJSON(policy.getConfigurationJson());
        List<EBPFProfilingTaskRecord> records = this.queryRecentTriggeredTasks(serviceId, configuration.getTargetCheckers().keySet());
        Map<Integer, EBPFProfilingTaskSummary> summaryMap = this.buildSummaryByKey(records, EBPFProfilingTaskRecord::getTargetType);
        return configuration.getTargetCheckers().entrySet().stream().map(targetEntry -> {
            ContinuousProfilingTargetType type = (ContinuousProfilingTargetType)((Object)((Object)targetEntry.getKey()));
            List<ContinuousProfilingPolicyItem> items = ((Map)targetEntry.getValue()).entrySet().stream().map(checker -> {
                ContinuousProfilingPolicyItem result = new ContinuousProfilingPolicyItem();
                ContinuousProfilingPolicyConfiguration.CheckItem item = (ContinuousProfilingPolicyConfiguration.CheckItem)checker.getValue();
                result.setType((ContinuousProfilingMonitorType)((Object)((Object)((Object)checker.getKey()))));
                result.setThreshold(item.getThreshold());
                result.setPeriod(item.getPeriod());
                result.setCount(item.getCount());
                result.setUriList(item.getUriList());
                result.setUriRegex(item.getUriRegex());
                return result;
            }).collect(Collectors.toList());
            ContinuousProfilingPolicyTarget target = ContinuousProfilingPolicyTarget.builder().type(type).checkItems(items).build();
            Optional.ofNullable((EBPFProfilingTaskSummary)summaryMap.get(EBPFProfilingTargetType.valueOf(type).value())).ifPresent(summary -> {
                target.setTriggeredCount(summary.getCount());
                target.setLastTriggerTimestamp(summary.getLastTriggerTime());
            });
            return target;
        }).collect(Collectors.toList());
    }

    public List<ContinuousProfilingMonitoringInstance> queryContinuousProfilingMonitoringInstances(String serviceId, ContinuousProfilingTargetType target) throws IOException {
        List<Process> processes = this.getMetadataQueryDAO().listProcesses(serviceId, null, TimeBucket.getTimeBucket(this.calcLastTriggeredStartTime().getTimeInMillis(), DownSampling.Minute), 0L);
        if (CollectionUtils.isEmpty(processes)) {
            return Collections.emptyList();
        }
        List<EBPFProfilingTaskRecord> records = this.queryRecentTriggeredTasks(serviceId, List.of(target));
        Map<String, List<Process>> instancesProcesses = processes.stream().collect(Collectors.groupingBy(Process::getInstanceId));
        List<ServiceInstance> instanceIdWithMetadata = this.getMetadataQueryDAO().getInstances(Arrays.asList(instancesProcesses.keySet().toArray(new String[0])));
        Map<String, EBPFProfilingTaskSummary> instanceSummary = this.buildSummaryByKey(records, EBPFProfilingTaskRecord::getInstanceId);
        Map<String, EBPFProfilingTaskSummary> processSummary = this.buildSummaryByKey(records, r -> {
            EBPFProfilingTaskContinuousProfiling continuousProfiling = (EBPFProfilingTaskContinuousProfiling)GSON.fromJson(r.getContinuousProfilingJson(), EBPFProfilingTaskContinuousProfiling.class);
            return continuousProfiling.getProcessId();
        });
        return instanceIdWithMetadata.stream().map(instance -> {
            ContinuousProfilingMonitoringInstance result = new ContinuousProfilingMonitoringInstance();
            result.setId(instance.getId());
            result.setName(instance.getName());
            result.setAttributes(instance.getAttributes());
            EBPFProfilingTaskSummary summary = (EBPFProfilingTaskSummary)instanceSummary.get(instance.getId());
            if (summary != null) {
                result.setTriggeredCount(summary.getCount());
                result.setLastTriggerTimestamp(summary.getLastTriggerTime());
            }
            result.setProcesses(instancesProcesses.getOrDefault(instance.getId(), List.of()).stream().map(p -> {
                ContinuousProfilingMonitoringProcess process = new ContinuousProfilingMonitoringProcess();
                process.setId(p.getId());
                process.setName(p.getName());
                process.setDetectType(p.getDetectType());
                process.setLabels(p.getLabels());
                EBPFProfilingTaskSummary processSummaryItem = (EBPFProfilingTaskSummary)processSummary.get(p.getId());
                if (processSummaryItem != null) {
                    process.setTriggeredCount(processSummaryItem.getCount());
                    process.setLastTriggerTimestamp(processSummaryItem.getLastTriggerTime());
                }
                return process;
            }).collect(Collectors.toList()));
            return result;
        }).collect(Collectors.toList());
    }

    private <T> Map<T, EBPFProfilingTaskSummary> buildSummaryByKey(List<EBPFProfilingTaskRecord> records, Function<EBPFProfilingTaskRecord, T> groupBy) {
        return records.stream().collect(Collectors.groupingByConcurrent(groupBy, this.buildSummaryCollector()));
    }

    private List<EBPFProfilingTaskRecord> queryRecentTriggeredTasks(String serviceId, Collection<ContinuousProfilingTargetType> targets) throws IOException {
        return this.getEbpfProfilingTaskDAO().queryTasksByTargets(serviceId, null, targets.stream().map(EBPFProfilingTargetType::valueOf).collect(Collectors.toList()), EBPFProfilingTriggerType.CONTINUOUS_PROFILING, this.calcLastTriggeredStartTime().getTimeInMillis(), 0L);
    }

    private Calendar calcLastTriggeredStartTime() {
        Calendar timeInstance = Calendar.getInstance();
        timeInstance.add(10, -48);
        return timeInstance;
    }

    private Collector<EBPFProfilingTaskRecord, EBPFProfilingTaskSummary, EBPFProfilingTaskSummary> buildSummaryCollector() {
        return Collector.of(EBPFProfilingTaskSummary::new, (result, task) -> {
            result.setCount(result.getCount() + 1);
            if (task.getStartTime() > result.getLastTriggerTime()) {
                result.setLastTriggerTime(task.getStartTime());
            }
            result.getRecords().add((EBPFProfilingTaskRecord)task);
        }, (result1, result2) -> {
            result1.setCount(result1.getCount() + result2.getCount());
            if (result2.getLastTriggerTime() > result1.getLastTriggerTime()) {
                result1.setLastTriggerTime(result2.getLastTriggerTime());
            }
            result1.getRecords().addAll(result2.getRecords());
            return result1;
        }, new Collector.Characteristics[0]);
    }

    @Generated
    public ContinuousProfilingQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private static class EBPFProfilingTaskSummary {
        private int count;
        private long lastTriggerTime;
        private List<EBPFProfilingTaskRecord> records = new ArrayList<EBPFProfilingTaskRecord>();

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public long getLastTriggerTime() {
            return this.lastTriggerTime;
        }

        @Generated
        public List<EBPFProfilingTaskRecord> getRecords() {
            return this.records;
        }

        @Generated
        public void setCount(int count) {
            this.count = count;
        }

        @Generated
        public void setLastTriggerTime(long lastTriggerTime) {
            this.lastTriggerTime = lastTriggerTime;
        }

        @Generated
        public void setRecords(List<EBPFProfilingTaskRecord> records) {
            this.records = records;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EBPFProfilingTaskSummary)) {
                return false;
            }
            EBPFProfilingTaskSummary other = (EBPFProfilingTaskSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getLastTriggerTime() != other.getLastTriggerTime()) {
                return false;
            }
            List<EBPFProfilingTaskRecord> this$records = this.getRecords();
            List<EBPFProfilingTaskRecord> other$records = other.getRecords();
            return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EBPFProfilingTaskSummary;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            long $lastTriggerTime = this.getLastTriggerTime();
            result = result * 59 + (int)($lastTriggerTime >>> 32 ^ $lastTriggerTime);
            List<EBPFProfilingTaskRecord> $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContinuousProfilingQueryService.EBPFProfilingTaskSummary(count=" + this.getCount() + ", lastTriggerTime=" + this.getLastTriggerTime() + ", records=" + this.getRecords() + ")";
        }
    }
}

