/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.hierarchy.service;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="service_hierarchy_relation", scopeId=70, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
@BanyanDB.IndexMode
public class ServiceHierarchyRelationTraffic
extends Metrics {
    public static final String INDEX_NAME = "service_hierarchy_relation";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_LAYER = "service_layer";
    public static final String RELATED_SERVICE_ID = "related_service_id";
    public static final String RELATED_SERVICE_LAYER = "related_service_layer";
    @Column(name="service_id", length=250)
    @BanyanDB.SeriesID(index=0)
    private String serviceId;
    @Column(name="service_layer")
    @BanyanDB.SeriesID(index=1)
    private Layer serviceLayer = Layer.UNDEFINED;
    @Column(name="related_service_id", length=250)
    @BanyanDB.SeriesID(index=2)
    private String relatedServiceId;
    @Column(name="related_service_layer")
    @BanyanDB.SeriesID(index=3)
    private Layer relatedServiceLayer = Layer.UNDEFINED;

    @Override
    protected StorageID id0() {
        String id = IDManager.ServiceID.buildServiceHierarchyRelationId(new IDManager.ServiceID.ServiceHierarchyRelationDefine(this.serviceId, this.serviceLayer, this.relatedServiceId, this.relatedServiceLayer));
        return new StorageID().appendMutant(new String[]{SERVICE_ID, SERVICE_LAYER, RELATED_SERVICE_ID, RELATED_SERVICE_LAYER}, id);
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceId(remoteData.getDataStrings(0));
        this.setServiceLayer(Layer.valueOf(remoteData.getDataIntegers(0)));
        this.setRelatedServiceId(remoteData.getDataStrings(1));
        this.setRelatedServiceLayer(Layer.valueOf(remoteData.getDataIntegers(1)));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.serviceId);
        builder.addDataIntegers(this.serviceLayer.value());
        builder.addDataStrings(this.relatedServiceId);
        builder.addDataIntegers(this.relatedServiceLayer.value());
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceHierarchyRelationTraffic)) {
            return false;
        }
        ServiceHierarchyRelationTraffic other = (ServiceHierarchyRelationTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        Layer this$serviceLayer = this.getServiceLayer();
        Layer other$serviceLayer = other.getServiceLayer();
        if (this$serviceLayer == null ? other$serviceLayer != null : !((Object)((Object)this$serviceLayer)).equals((Object)other$serviceLayer)) {
            return false;
        }
        String this$relatedServiceId = this.getRelatedServiceId();
        String other$relatedServiceId = other.getRelatedServiceId();
        if (this$relatedServiceId == null ? other$relatedServiceId != null : !this$relatedServiceId.equals(other$relatedServiceId)) {
            return false;
        }
        Layer this$relatedServiceLayer = this.getRelatedServiceLayer();
        Layer other$relatedServiceLayer = other.getRelatedServiceLayer();
        return !(this$relatedServiceLayer == null ? other$relatedServiceLayer != null : !((Object)((Object)this$relatedServiceLayer)).equals((Object)other$relatedServiceLayer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceHierarchyRelationTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        Layer $serviceLayer = this.getServiceLayer();
        result = result * 59 + ($serviceLayer == null ? 43 : ((Object)((Object)$serviceLayer)).hashCode());
        String $relatedServiceId = this.getRelatedServiceId();
        result = result * 59 + ($relatedServiceId == null ? 43 : $relatedServiceId.hashCode());
        Layer $relatedServiceLayer = this.getRelatedServiceLayer();
        result = result * 59 + ($relatedServiceLayer == null ? 43 : ((Object)((Object)$relatedServiceLayer)).hashCode());
        return result;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceLayer(Layer serviceLayer) {
        this.serviceLayer = serviceLayer;
    }

    @Generated
    public Layer getServiceLayer() {
        return this.serviceLayer;
    }

    @Generated
    public void setRelatedServiceId(String relatedServiceId) {
        this.relatedServiceId = relatedServiceId;
    }

    @Generated
    public String getRelatedServiceId() {
        return this.relatedServiceId;
    }

    @Generated
    public void setRelatedServiceLayer(Layer relatedServiceLayer) {
        this.relatedServiceLayer = relatedServiceLayer;
    }

    @Generated
    public Layer getRelatedServiceLayer() {
        return this.relatedServiceLayer;
    }

    public static class Builder
    implements StorageBuilder<ServiceHierarchyRelationTraffic> {
        @Override
        public ServiceHierarchyRelationTraffic storage2Entity(Convert2Entity converter) {
            ServiceHierarchyRelationTraffic traffic = new ServiceHierarchyRelationTraffic();
            traffic.setServiceId((String)converter.get(ServiceHierarchyRelationTraffic.SERVICE_ID));
            traffic.setRelatedServiceId((String)converter.get(ServiceHierarchyRelationTraffic.RELATED_SERVICE_ID));
            if (converter.get(ServiceHierarchyRelationTraffic.SERVICE_LAYER) != null) {
                traffic.setServiceLayer(Layer.valueOf(((Number)converter.get(ServiceHierarchyRelationTraffic.SERVICE_LAYER)).intValue()));
            } else {
                traffic.setServiceLayer(Layer.UNDEFINED);
            }
            if (converter.get(ServiceHierarchyRelationTraffic.RELATED_SERVICE_LAYER) != null) {
                traffic.setRelatedServiceLayer(Layer.valueOf(((Number)converter.get(ServiceHierarchyRelationTraffic.RELATED_SERVICE_LAYER)).intValue()));
            } else {
                traffic.setRelatedServiceLayer(Layer.UNDEFINED);
            }
            if (converter.get("time_bucket") != null) {
                traffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            }
            return traffic;
        }

        @Override
        public void entity2Storage(ServiceHierarchyRelationTraffic storageData, Convert2Storage converter) {
            converter.accept(ServiceHierarchyRelationTraffic.SERVICE_ID, storageData.getServiceId());
            converter.accept(ServiceHierarchyRelationTraffic.RELATED_SERVICE_ID, storageData.getRelatedServiceId());
            converter.accept(ServiceHierarchyRelationTraffic.SERVICE_LAYER, storageData.getServiceLayer().value());
            converter.accept(ServiceHierarchyRelationTraffic.RELATED_SERVICE_LAYER, storageData.getRelatedServiceLayer().value());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

