/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum ProcessDetectType {
    UNDEFINED(0),
    VM(1),
    KUBERNETES(2),
    VIRTUAL(3);

    private final int value;
    private static final Map<Integer, ProcessDetectType> DICTIONARY;

    private ProcessDetectType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ProcessDetectType valueOf(int value) {
        ProcessDetectType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown ProcessDetectType value");
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, ProcessDetectType>();
        Arrays.stream(ProcessDetectType.values()).collect(Collectors.toMap(ProcessDetectType::value, type -> type)).forEach(DICTIONARY::put);
    }
}

