/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.cache;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="top_n_cache_write_command", scopeId=56, builder=Builder.class, processor=TopNStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
public class TopNCacheWriteCommand
extends TopN {
    public static final String INDEX_NAME = "top_n_cache_write_command";
    private String id;
    @Column(name="statement", length=2000, storageOnly=true)
    private String command;

    @Override
    public StorageID id() {
        return new StorageID().appendMutant(null, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNCacheWriteCommand statement = (TopNCacheWriteCommand)o;
        return Objects.equals(this.getEntityId(), statement.getEntityId());
    }

    public int hashCode() {
        return Objects.hash(this.getEntityId());
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    public static class Builder
    implements StorageBuilder<TopNCacheWriteCommand> {
        @Override
        public TopNCacheWriteCommand storage2Entity(Convert2Entity converter) {
            TopNCacheWriteCommand statement = new TopNCacheWriteCommand();
            statement.setCommand((String)converter.get("statement"));
            statement.setTraceId((String)converter.get("trace_id"));
            statement.setLatency(((Number)converter.get("latency")).longValue());
            statement.setEntityId((String)converter.get("entity_id"));
            statement.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            statement.setTimestamp(((Number)converter.get("timestamp")).longValue());
            return statement;
        }

        @Override
        public void entity2Storage(TopNCacheWriteCommand storageData, Convert2Storage converter) {
            converter.accept("statement", storageData.getCommand());
            converter.accept("trace_id", storageData.getTraceId());
            converter.accept("latency", storageData.getLatency());
            converter.accept("entity_id", storageData.getEntityId());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("timestamp", storageData.getTimestamp());
        }
    }
}

