/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import java.io.IOException;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStreamInsertRequest;

public class BanyanDBRecordDAO
extends AbstractBanyanDBDAO
implements IRecordDAO {
    private final StorageBuilder<Record> storageBuilder;

    public BanyanDBRecordDAO(BanyanDBStorageClient client, StorageBuilder<Record> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public InsertRequest prepareBatchInsert(Model model, Record record) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        StreamWrite streamWrite = ((BanyanDBStorageClient)this.getClient()).createStreamWrite(schema.getMetadata().getGroup(), model.getName(), record.id().build());
        BanyanDBConverter.StreamToStorage convert2Storage = new BanyanDBConverter.StreamToStorage(schema, streamWrite);
        this.storageBuilder.entity2Storage((StorageData)record, (Convert2Storage)convert2Storage);
        return new BanyanDBStreamInsertRequest((StreamWrite)convert2Storage.obtain());
    }
}

