/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.internal.config.QNameNormalization;
import org.apache.royale.compiler.problems.ComponentTagWithoutURIProblem;
import org.apache.royale.compiler.problems.FileInLibraryIOProblem;
import org.apache.royale.swc.ISWCVersion;
import org.apache.royale.swc.SWC;
import org.apache.royale.swc.SWCComponent;
import org.apache.royale.swc.SWCDigest;
import org.apache.royale.swc.SWCLibrary;
import org.apache.royale.swc.SWCScript;
import org.apache.royale.swc.catalog.ICatalogXMLConstants;
import org.apache.royale.swc.catalog.SWCFileEntry;
import org.apache.royale.utils.FilenameNormalization;

public class StAXCatalogReader
implements ICatalogXMLConstants {
    private final XMLStreamReader reader;
    private final SWC swc;
    private final Map<String, String> timeStamps;
    private final Map<String, SWCComponent> componentIndex;
    private SWCLibrary currentLibrary;
    private SWCScript currentScript;

    public StAXCatalogReader(InputStream in, SWC swc) throws XMLStreamException {
        if (swc == null) {
            throw new NullPointerException("SWC model can't be null");
        }
        if (in == null) {
            throw new NullPointerException("InputStream can't be null.");
        }
        this.swc = swc;
        this.timeStamps = new HashMap<String, String>();
        this.componentIndex = new HashMap<String, SWCComponent>();
        StreamFilter filter = new StreamFilter(){

            @Override
            public boolean accept(XMLStreamReader reader) {
                return reader.isStartElement();
            }
        };
        XMLInputFactory factory = XMLInputFactory.newInstance();
        assert (factory != null) : "Null XMLInputFactory";
        XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(in);
        this.reader = factory.createFilteredReader(xmlStreamReader, filter);
    }

    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void parse() {
        String containingSWCFile = FilenameNormalization.normalize(this.swc.getSWCFile().getAbsolutePath());
        try {
            while (this.reader.hasNext()) {
                String id;
                ISWCVersion swcVersion;
                String path;
                int next = this.reader.next();
                if (next != 1) continue;
                String tagName = this.reader.getName().getLocalPart();
                if (tagName.equals("library")) {
                    path = this.reader.getAttributeValue(null, "path");
                    this.currentLibrary = new SWCLibrary(path);
                    this.swc.addLibrary(this.currentLibrary);
                    continue;
                }
                if (tagName.equals("component")) {
                    String className = this.reader.getAttributeValue(null, "className");
                    className = QNameNormalization.normalize(className);
                    String componentName = this.reader.getAttributeValue(null, "name");
                    String uri = this.reader.getAttributeValue(null, "uri");
                    if (uri == null || uri.isEmpty()) {
                        this.swc.addProblem(new ComponentTagWithoutURIProblem(componentName, "catalog.xml", containingSWCFile));
                        continue;
                    }
                    String icon = this.reader.getAttributeValue(null, "icon");
                    String preview = this.reader.getAttributeValue(null, "preview");
                    SWCComponent component = new SWCComponent();
                    if (className != null) {
                        component.setQName(className.intern());
                    }
                    if (componentName != null) {
                        component.setName(componentName.intern());
                    }
                    component.setURI(uri.intern());
                    if (icon != null) {
                        component.setIcon(icon.intern());
                    }
                    if (preview != null) {
                        component.setPreview(preview.intern());
                    }
                    this.swc.addComponent(component);
                    this.componentIndex.put(className, component);
                    continue;
                }
                if (tagName.equals("script")) {
                    String name = this.reader.getAttributeValue(null, "name");
                    String mod = this.reader.getAttributeValue(null, "mod");
                    String signatureChecksum = this.reader.getAttributeValue(null, "signatureChecksum");
                    this.currentScript = new SWCScript();
                    if (name != null) {
                        this.currentScript.setName(name.intern());
                    }
                    if (mod != null) {
                        this.currentScript.setLastModified(Long.parseLong(mod));
                    }
                    if (signatureChecksum != null) {
                        this.currentScript.setSignatureChecksum(signatureChecksum);
                    }
                    this.currentLibrary.addScript(this.currentScript);
                    this.timeStamps.put(name, mod);
                    continue;
                }
                if (tagName.equals("royale")) {
                    String royaleVersion = this.reader.getAttributeValue(null, "version");
                    String minSupportedVersion = this.reader.getAttributeValue(null, "minimumSupportedVersion");
                    String royaleBuild = this.reader.getAttributeValue(null, "build");
                    swcVersion = this.swc.getVersion();
                    swcVersion.setRoyaleVersion(royaleVersion);
                    swcVersion.setRoyaleMinSupportedVersion(minSupportedVersion);
                    swcVersion.setRoyaleBuild(royaleBuild);
                    continue;
                }
                if (tagName.equals("swc")) {
                    String swcVersion2 = this.reader.getAttributeValue(null, "version");
                    this.swc.getVersion().setSWCVersion(swcVersion2);
                    continue;
                }
                if (tagName.equals("def")) {
                    id = this.reader.getAttributeValue(null, "id");
                    id = QNameNormalization.normalize(id);
                    this.currentScript.addDefinition(id);
                    SWCComponent component = this.componentIndex.get(id);
                    if (component == null) continue;
                    component.setScript(this.currentScript);
                    continue;
                }
                if (tagName.equals("dep")) {
                    id = this.reader.getAttributeValue(null, "id");
                    id = QNameNormalization.normalize(id);
                    String type = this.reader.getAttributeValue(null, "type");
                    assert (type.length() == 1);
                    this.currentScript.addDependency(id, DependencyType.get(type.charAt(0)));
                    continue;
                }
                if (tagName.equals("file")) {
                    path = this.reader.getAttributeValue(null, "path");
                    String modString = this.reader.getAttributeValue(null, "mod");
                    long mod = 0L;
                    if (modString != null) {
                        mod = Long.parseLong(modString);
                    }
                    SWCFileEntry fileEntry = new SWCFileEntry(containingSWCFile, path, mod);
                    this.swc.addFile(fileEntry);
                    continue;
                }
                if (tagName.equals("digest")) {
                    String type = this.reader.getAttributeValue(null, "type");
                    String value = this.reader.getAttributeValue(null, "value");
                    boolean isSigned = Boolean.parseBoolean(this.reader.getAttributeValue(null, "signed"));
                    SWCDigest swcDigest = new SWCDigest();
                    swcDigest.setType(type);
                    swcDigest.setValue(value);
                    swcDigest.setSigned(isSigned);
                    this.currentLibrary.addDigest(swcDigest);
                    continue;
                }
                if (tagName.equals("metadata")) {
                    String metadataName = this.reader.getAttributeValue(null, "name");
                    this.currentLibrary.addNameToKeepAS3MetadataSet(metadataName);
                    continue;
                }
                if (!tagName.equals("compiler")) continue;
                String compilerName = this.reader.getAttributeValue(null, "name");
                String compilerVersion = this.reader.getAttributeValue(null, "version");
                String compilerBuild = this.reader.getAttributeValue(null, "build");
                swcVersion = this.swc.getVersion();
                swcVersion.setCompilerName(compilerName);
                swcVersion.setCompilerVersion(compilerVersion);
                swcVersion.setCompilerBuild(compilerBuild);
            }
        }
        catch (XMLStreamException e) {
            this.swc.addProblem(new FileInLibraryIOProblem("catalog.xml", containingSWCFile, e.getLocalizedMessage()));
        }
    }
}

