/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import java.util.EnumSet;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.NilNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.units.ASCompilationUnit;
import org.apache.royale.compiler.internal.units.requests.ASFileScopeRequestResult;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

class ConfigCompilationUnit
extends ASCompilationUnit {
    ConfigCompilationUnit(CompilerProject project, String path) {
        super(project, path, DefinitionPriority.BasePriority.SOURCE_LIST);
    }

    @Override
    protected FileNode createFileNode(IFileSpecification specification) {
        return new ConfigFileNode(this.getProject().getWorkspace(), this.getAbsoluteFilename());
    }

    @Override
    protected void verifyAST(IASNode ast) {
    }

    @Override
    protected void addProblemsToProject(ASFileScopeRequestResult result) {
    }

    public static final class ConfigFileNode
    extends FileNode {
        private static final long serialVersionUID = -2201798599052884838L;

        public ConfigFileNode(IWorkspace workspace, String pathName) {
            super((IFileSpecificationGetter)workspace, pathName);
            this.setSourcePath(pathName);
            PackageNode n = new PackageNode(new NilNode(), null);
            this.addItem(n);
            this.initializeScope(null);
            this.processAST(EnumSet.of(PostProcessStep.CALCULATE_OFFSETS));
        }

        public ScopedBlockNode getTargetConfigScope() {
            return ((PackageNode)this.getChild(0)).getScopedNode();
        }

        @Override
        public void processAST(EnumSet<PostProcessStep> features) {
            super.processAST(EnumSet.of(PostProcessStep.CALCULATE_OFFSETS));
        }
    }
}

