/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions.metadata;

import java.util.Arrays;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.NodeReference;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTagAttribute;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class MetaTag
implements IMetaTag {
    private IDefinition decoratedDefinition;
    private String tagName;
    private IMetaTagAttribute[] attributes;
    private static final IMetaTagAttribute[] emptyAttributes = new IMetaTagAttribute[0];
    private String sourcePath;
    private int absoluteStart = -1;
    private int absoluteEnd = -1;
    private int line = -1;
    private int column = -1;
    private NodeReference nodeRef = NodeReference.noReference;

    public static IMetaInfo[] addMetaTag(IMetaInfo[] metaTags, IMetaInfo metaTag) {
        assert (metaTags != null);
        if (metaTag != null) {
            IMetaInfo[] newMetaTags = (IMetaInfo[])Arrays.copyOf(metaTags, metaTags.length + 1, IMetaInfo[].class);
            newMetaTags[metaTags.length] = metaTag;
            metaTags = newMetaTags;
        }
        return metaTags;
    }

    public static MetaTag createGotoDefinitionHelp(IDefinition definition, String file, String pos, boolean ctor) {
        assert (pos != null);
        if (pos.equals("-1")) {
            return null;
        }
        IMetaTagAttribute[] attributes = new MetaTagAttribute[file != null ? 2 : 1];
        if (file != null) {
            attributes[0] = new MetaTagAttribute("file", file);
        }
        attributes[file != null ? 1 : 0] = new MetaTagAttribute("pos", pos);
        return new MetaTag(definition, ctor ? "__go_to_ctor_definition_help" : "__go_to_definition_help", attributes);
    }

    public MetaTag(IDefinition decoratedDefinition, String tagName, IMetaTagAttribute[] attributes) {
        this.decoratedDefinition = decoratedDefinition;
        this.tagName = tagName;
        if (attributes == null) {
            attributes = emptyAttributes;
        }
        this.attributes = attributes;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public IMetaTagAttribute[] getAllAttributes() {
        return this.attributes;
    }

    @Override
    public IMetaTagAttribute getAttribute(String key) {
        for (IMetaTagAttribute attribute : this.attributes) {
            String attrKey = attribute.getKey();
            if (attrKey == null || !attrKey.equals(key)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String key) {
        for (IMetaTagAttribute attribute : this.attributes) {
            String attrKey = attribute.getKey();
            if (attrKey == null || !attrKey.equals(key)) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    private OffsetLookup getOffsetLookup() {
        DefinitionBase definition = (DefinitionBase)this.getDecoratedDefinition();
        if (definition == null) {
            return null;
        }
        ASFileScope fileScope = definition.getFileScope();
        if (fileScope == null) {
            return null;
        }
        return fileScope.getOffsetLookup();
    }

    @Override
    public int getStart() {
        OffsetLookup offsetLookup = this.getOffsetLookup();
        if (offsetLookup == null) {
            return this.absoluteStart;
        }
        return offsetLookup.getLocalOffset(this.absoluteStart);
    }

    @Override
    public int getEnd() {
        OffsetLookup offsetLookup = this.getOffsetLookup();
        if (offsetLookup == null) {
            return this.absoluteEnd;
        }
        return offsetLookup.getLocalOffset(this.absoluteEnd);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.line;
    }

    @Override
    public int getEndColumn() {
        return this.column;
    }

    @Override
    public int getAbsoluteStart() {
        return this.absoluteStart;
    }

    @Override
    public int getAbsoluteEnd() {
        return this.absoluteEnd;
    }

    @Override
    public IDefinition getDecoratedDefinition() {
        return this.decoratedDefinition;
    }

    @Override
    public String getValue() {
        return this.attributes.length == 1 && !this.attributes[0].hasKey() ? this.attributes[0].getValue() : null;
    }

    @Override
    public IMetaTagNode getTagNode() {
        if (this.nodeRef == NodeReference.noReference) {
            return null;
        }
        ASScope containingScope = (ASScope)this.getDecoratedDefinition().getContainingScope();
        if (containingScope == null) {
            return null;
        }
        ASFileScope fileScope = containingScope.getFileScope();
        if (fileScope == null) {
            return null;
        }
        IWorkspace workspace = fileScope.getWorkspace();
        assert (workspace != null);
        IASNode node = this.nodeRef.getNode(workspace, containingScope);
        if (!(node instanceof IMetaTagNode)) {
            IMetaTagsNode metaTags;
            if (node instanceof ClassNode && (metaTags = ((ClassNode)node).getMetaTags()) != null) {
                for (IMetaTagNode metaTagNode : metaTags.getAllTags()) {
                    if (metaTagNode.getAbsoluteStart() != this.getAbsoluteStart()) continue;
                    return metaTagNode;
                }
            }
            return null;
        }
        return (IMetaTagNode)node;
    }

    public void setLocation(IFileSpecification containingFileSpec, int absoluteStart, int absoluteEnd, int line, int column) {
        this.nodeRef = new NodeReference(containingFileSpec, absoluteStart);
        this.sourcePath = containingFileSpec.getPath();
        this.absoluteStart = absoluteStart;
        this.absoluteEnd = absoluteEnd;
        this.line = line;
        this.column = column;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.tagName);
        IMetaTagAttribute[] attrs = this.getAllAttributes();
        if (attrs != null && attrs.length > 0) {
            sb.append('(');
            int i = 0;
            for (IMetaTagAttribute attr : this.getAllAttributes()) {
                if (i != 0) {
                    sb.append(',');
                    sb.append(' ');
                }
                String key = attr.getKey();
                String value = attr.getValue();
                sb.append(key);
                sb.append('=');
                sb.append('\"');
                sb.append(value);
                sb.append('\"');
                ++i;
            }
            sb.append(')');
        }
        sb.append(']');
        return sb.toString();
    }
}

