/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCliRequestProcessor<T extends Message>
extends RpcRequestProcessor<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseCliRequestProcessor.class);

    public BaseCliRequestProcessor(Executor executor, Message defaultResp) {
        super(executor, defaultResp);
    }

    protected abstract String getPeerId(T var1);

    protected abstract String getGroupId(T var1);

    protected abstract Message processRequest0(CliRequestContext var1, T var2, RpcRequestClosure var3);

    @Override
    public Message processRequest(T request, RpcRequestClosure done) {
        String groupId = this.getGroupId(request);
        String peerIdStr = this.getPeerId(request);
        PeerId peerId = null;
        if (!StringUtils.isBlank((String)peerIdStr) && !(peerId = new PeerId()).parse(peerIdStr)) {
            return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), RaftError.EINVAL, "Fail to parse peer: %s", peerIdStr);
        }
        Status st = new Status();
        Node node = this.getNode(groupId, peerId, st);
        if (!st.isOk()) {
            return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), st.getCode(), st.getErrorMsg(), new Object[0]);
        }
        return this.processRequest0(new CliRequestContext(node, groupId, peerId), request, done);
    }

    protected Node getNode(String groupId, PeerId peerId, Status st) {
        Node node = null;
        if (peerId != null) {
            node = NodeManager.getInstance().get(groupId, peerId);
            if (node == null) {
                st.setError(RaftError.ENOENT, "Fail to find node %s in group %s", peerId, groupId);
            }
        } else {
            List<Node> nodes = NodeManager.getInstance().getNodesByGroupId(groupId);
            if (nodes == null || nodes.isEmpty()) {
                st.setError(RaftError.ENOENT, "Empty nodes in group %s", groupId);
            } else if (nodes.size() > 1) {
                st.setError(RaftError.EINVAL, "Peer must be specified since there're %d nodes in group %s", nodes.size(), groupId);
            } else {
                node = nodes.get(0);
            }
        }
        if (node != null && node.getOptions().isDisableCli()) {
            st.setError(RaftError.EACCES, "Cli service is not allowed to access node %s", node.getNodeId());
        }
        return node;
    }

    public static class CliRequestContext {
        public final Node node;
        public final PeerId peerId;
        public final String groupId;

        public CliRequestContext(Node ndoe, String groupId, PeerId peerId) {
            this.node = ndoe;
            this.peerId = peerId;
            this.groupId = groupId;
        }
    }
}

