/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.concurrent.atomic.AtomicLong;

public abstract class ReferenceResource {
    protected final AtomicLong refCount = new AtomicLong(1L);
    protected volatile boolean available = true;
    protected volatile boolean cleanupOver = false;
    private volatile long firstShutdownTimestamp = 0L;

    public synchronized boolean hold() {
        if (this.isAvailable()) {
            if (this.refCount.getAndIncrement() > 0L) {
                return true;
            }
            this.refCount.getAndDecrement();
        }
        return false;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void shutdown(long intervalForcibly) {
        if (this.available) {
            this.available = false;
            this.firstShutdownTimestamp = System.currentTimeMillis();
            this.release();
        } else if (this.getRefCount() > 0L && System.currentTimeMillis() - this.firstShutdownTimestamp >= intervalForcibly) {
            this.refCount.set(-1000L - this.getRefCount());
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        long value = this.refCount.decrementAndGet();
        if (value > 0L) {
            return;
        }
        ReferenceResource referenceResource = this;
        synchronized (referenceResource) {
            this.cleanupOver = this.cleanup(value);
        }
    }

    public long getRefCount() {
        return this.refCount.get();
    }

    public abstract boolean cleanup(long var1);

    public boolean isCleanupOver() {
        return this.refCount.get() <= 0L && this.cleanupOver;
    }
}

