/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark.timer;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.srvutil.ServerUtil;

public class TimerProducer {
    private static final Logger log = LoggerFactory.getLogger(TimerProducer.class);
    private final String topic;
    private final int threadCount;
    private final int messageSize;
    private final int precisionMs;
    private final int slotsTotal;
    private final int msgsTotalPerSlotThread;
    private final int slotDis;
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("ProducerScheduleThread_"));
    private final ExecutorService sendThreadPool;
    private final StatsBenchmarkProducer statsBenchmark = new StatsBenchmarkProducer();
    private final LinkedList<Long[]> snapshotList = new LinkedList();
    private final DefaultMQProducer producer;

    public TimerProducer(String[] args) {
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"benchmarkTimerProducer", (String[])args, (Options)this.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
        }
        String namesrvAddr = commandLine.hasOption('n') ? commandLine.getOptionValue('t').trim() : "localhost:9876";
        this.topic = commandLine.hasOption('t') ? commandLine.getOptionValue('t').trim() : "BenchmarkTest";
        this.threadCount = commandLine.hasOption("tc") ? Integer.parseInt(commandLine.getOptionValue("tc")) : 16;
        this.messageSize = commandLine.hasOption("ms") ? Integer.parseInt(commandLine.getOptionValue("ms")) : 1024;
        this.precisionMs = commandLine.hasOption('p') ? Integer.parseInt(commandLine.getOptionValue("p")) : 1000;
        this.slotsTotal = commandLine.hasOption("st") ? Integer.parseInt(commandLine.getOptionValue("st")) : 100;
        this.msgsTotalPerSlotThread = commandLine.hasOption("mt") ? Integer.parseInt(commandLine.getOptionValue("mt")) : 5000;
        this.slotDis = commandLine.hasOption("sd") ? Integer.parseInt(commandLine.getOptionValue("sd")) : 1000;
        System.out.printf("namesrvAddr: %s, topic: %s, threadCount: %d, messageSize: %d, precisionMs: %d, slotsTotal: %d, msgsTotalPerSlotThread: %d, slotDis: %d%n", namesrvAddr, this.topic, this.threadCount, this.messageSize, this.precisionMs, this.slotsTotal, this.msgsTotalPerSlotThread, this.slotDis);
        this.sendThreadPool = new ThreadPoolExecutor(this.threadCount, this.threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new ThreadFactoryImpl("ProducerSendMessageThread_"));
        this.producer = new DefaultMQProducer("benchmark_producer");
        this.producer.setInstanceName(Long.toString(System.currentTimeMillis()));
        this.producer.setNamesrvAddr(namesrvAddr);
        this.producer.setCompressMsgBodyOverHowmuch(Integer.MAX_VALUE);
    }

    public void startScheduleTask() {
        this.scheduledExecutor.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TimerProducer.this.snapshotList.addLast(TimerProducer.this.statsBenchmark.createSnapshot());
                if (TimerProducer.this.snapshotList.size() > 10) {
                    TimerProducer.this.snapshotList.removeFirst();
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutor.scheduleAtFixedRate(new TimerTask(){

            private void printStats() {
                if (TimerProducer.this.snapshotList.size() >= 10) {
                    Long[] begin = (Long[])TimerProducer.this.snapshotList.getFirst();
                    Long[] end = (Long[])TimerProducer.this.snapshotList.getLast();
                    long sendTps = (long)((double)(end[3] - begin[3]) / (double)(end[0] - begin[0]) * 1000.0);
                    double averageRT = (double)(end[5] - begin[5]) / (double)(end[3] - begin[3]);
                    System.out.printf("Send TPS: %d, Max RT: %d, Average RT: %7.3f, Send Failed: %d, Response Failed: %d%n", sendTps, TimerProducer.this.statsBenchmark.getSendMessageMaxRT().get(), averageRT, end[2], end[4]);
                }
            }

            @Override
            public void run() {
                try {
                    this.printStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void start() throws MQClientException {
        this.producer.start();
        System.out.printf("Start sending messages%n", new Object[0]);
        final ArrayList<Long> delayList = new ArrayList<Long>();
        long startDelayTime = System.currentTimeMillis() / (long)this.precisionMs * (long)this.precisionMs + 120000L + 10L;
        for (int slotCnt = 0; slotCnt < this.slotsTotal; ++slotCnt) {
            for (int msgCnt = 0; msgCnt < this.msgsTotalPerSlotThread; ++msgCnt) {
                long delayTime = startDelayTime + (long)(slotCnt * this.slotDis);
                delayList.add(delayTime);
            }
        }
        Collections.shuffle(delayList);
        for (int i = 0; i < this.threadCount; ++i) {
            this.sendThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    for (int slotCnt = 0; slotCnt < TimerProducer.this.slotsTotal; ++slotCnt) {
                        for (int msgCnt = 0; msgCnt < TimerProducer.this.msgsTotalPerSlotThread; ++msgCnt) {
                            Message msg;
                            long beginTimestamp = System.currentTimeMillis();
                            long delayTime = (Long)delayList.get(slotCnt * TimerProducer.this.msgsTotalPerSlotThread + msgCnt);
                            try {
                                msg = TimerProducer.this.buildMessage(TimerProducer.this.messageSize, TimerProducer.this.topic);
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                return;
                            }
                            msg.putUserProperty("MY_RECORD_TIMER_DELIVER_MS", String.valueOf(delayTime));
                            msg.getProperties().put("TIMER_DELIVER_MS", String.valueOf(delayTime));
                            try {
                                TimerProducer.this.producer.send(msg);
                                TimerProducer.this.statsBenchmark.getSendRequestSuccessCount().incrementAndGet();
                                TimerProducer.this.statsBenchmark.getReceiveResponseSuccessCount().incrementAndGet();
                                long currentRT = System.currentTimeMillis() - beginTimestamp;
                                TimerProducer.this.statsBenchmark.getSendMessageSuccessTimeTotal().addAndGet(currentRT);
                                long prevMaxRT = TimerProducer.this.statsBenchmark.getSendMessageMaxRT().get();
                                while (currentRT > prevMaxRT && !TimerProducer.this.statsBenchmark.getSendMessageMaxRT().compareAndSet(prevMaxRT, currentRT)) {
                                    prevMaxRT = TimerProducer.this.statsBenchmark.getSendMessageMaxRT().get();
                                }
                                continue;
                            }
                            catch (RemotingException e) {
                                TimerProducer.this.statsBenchmark.getSendRequestFailedCount().incrementAndGet();
                                log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                                TimerProducer.this.sleep(3000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                TimerProducer.this.statsBenchmark.getSendRequestFailedCount().incrementAndGet();
                                TimerProducer.this.sleep(3000L);
                                continue;
                            }
                            catch (MQClientException e) {
                                TimerProducer.this.statsBenchmark.getSendRequestFailedCount().incrementAndGet();
                                log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                                continue;
                            }
                            catch (MQBrokerException e) {
                                TimerProducer.this.statsBenchmark.getReceiveResponseFailedCount().incrementAndGet();
                                log.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                                TimerProducer.this.sleep(3000L);
                            }
                        }
                    }
                }
            });
        }
    }

    private Options buildCommandlineOptions(Options options) {
        Option opt = new Option("n", "namesrvAddr", true, "Nameserver address, default: localhost:9876");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Send messages to which topic, default: BenchmarkTest");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("tc", "threadCount", true, "Thread count, default: 64");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ms", "messageSize", true, "Message Size, default: 128");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "precisionMs", true, "Precision (ms) for TimerMessage, default: 1000");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("st", "slotsTotal", true, "Send messages to how many slots, default: 100");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("mt", "msgsTotalPerSlotThread", true, "Messages total for each slot and each thread, default: 100");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("sd", "slotDis", true, "Time distance between two slots, default: 1000");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    private Message buildMessage(int messageSize, String topic) throws UnsupportedEncodingException {
        Message msg = new Message();
        msg.setTopic(topic);
        String body = StringUtils.repeat((char)'a', (int)messageSize);
        msg.setBody(body.getBytes("UTF-8"));
        return msg;
    }

    private void sleep(long timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws MQClientException {
        TimerProducer timerProducer = new TimerProducer(args);
        timerProducer.startScheduleTask();
        timerProducer.start();
    }

    public static class StatsBenchmarkProducer {
        private final AtomicLong sendRequestSuccessCount = new AtomicLong(0L);
        private final AtomicLong sendRequestFailedCount = new AtomicLong(0L);
        private final AtomicLong receiveResponseSuccessCount = new AtomicLong(0L);
        private final AtomicLong receiveResponseFailedCount = new AtomicLong(0L);
        private final AtomicLong sendMessageSuccessTimeTotal = new AtomicLong(0L);
        private final AtomicLong sendMessageMaxRT = new AtomicLong(0L);

        public Long[] createSnapshot() {
            return new Long[]{System.currentTimeMillis(), this.sendRequestSuccessCount.get(), this.sendRequestFailedCount.get(), this.receiveResponseSuccessCount.get(), this.receiveResponseFailedCount.get(), this.sendMessageSuccessTimeTotal.get()};
        }

        public AtomicLong getSendRequestSuccessCount() {
            return this.sendRequestSuccessCount;
        }

        public AtomicLong getSendRequestFailedCount() {
            return this.sendRequestFailedCount;
        }

        public AtomicLong getReceiveResponseSuccessCount() {
            return this.receiveResponseSuccessCount;
        }

        public AtomicLong getReceiveResponseFailedCount() {
            return this.receiveResponseFailedCount;
        }

        public AtomicLong getSendMessageSuccessTimeTotal() {
            return this.sendMessageSuccessTimeTotal;
        }

        public AtomicLong getSendMessageMaxRT() {
            return this.sendMessageMaxRT;
        }
    }
}

