/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Set;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ProducerChangeListener;
import org.apache.rocketmq.broker.client.ProducerGroupEvent;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.channel.RemotingChannel;
import org.apache.rocketmq.proxy.remoting.channel.RemotingChannelManager;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.AttributeKeys;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UnregisterClientResponseHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.ProducerData;

public class ClientManagerActivity
extends AbstractRemotingActivity {
    private final RemotingChannelManager remotingChannelManager;

    public ClientManagerActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor, RemotingChannelManager manager) {
        super(requestPipeline, messagingProcessor);
        this.remotingChannelManager = manager;
        this.init();
    }

    protected void init() {
        this.messagingProcessor.registerConsumerListener(new ConsumerIdsChangeListenerImpl());
        this.messagingProcessor.registerProducerListener(new ProducerChangeListenerImpl());
    }

    @Override
    protected RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        switch (request.getCode()) {
            case 34: {
                return this.heartBeat(ctx, request, context);
            }
            case 35: {
                return this.unregisterClient(ctx, request, context);
            }
            case 46: {
                return this.checkClientConfig(ctx, request, context);
            }
        }
        return null;
    }

    protected RemotingCommand heartBeat(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) {
        ClientChannelInfo clientChannelInfo;
        HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])request.getBody(), HeartbeatData.class);
        String clientId = heartbeatData.getClientID();
        for (ProducerData data : heartbeatData.getProducerDataSet()) {
            clientChannelInfo = new ClientChannelInfo((Channel)this.remotingChannelManager.createProducerChannel(context, ctx.channel(), data.getGroupName(), clientId), clientId, request.getLanguage(), request.getVersion());
            this.setClientPropertiesToChannelAttr(clientChannelInfo);
            this.messagingProcessor.registerProducer(context, data.getGroupName(), clientChannelInfo);
        }
        for (ProducerData data : heartbeatData.getConsumerDataSet()) {
            clientChannelInfo = new ClientChannelInfo((Channel)this.remotingChannelManager.createConsumerChannel(context, ctx.channel(), data.getGroupName(), clientId, data.getSubscriptionDataSet()), clientId, request.getLanguage(), request.getVersion());
            this.setClientPropertiesToChannelAttr(clientChannelInfo);
            this.messagingProcessor.registerConsumer(context, data.getGroupName(), clientChannelInfo, data.getConsumeType(), data.getMessageModel(), data.getConsumeFromWhere(), data.getSubscriptionDataSet(), true);
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setRemark("");
        return response;
    }

    private void setClientPropertiesToChannelAttr(ClientChannelInfo clientChannelInfo) {
        Channel channel = clientChannelInfo.getChannel();
        if (channel instanceof RemotingChannel) {
            RemotingChannel remotingChannel = (RemotingChannel)channel;
            Channel parent = remotingChannel.parent();
            RemotingHelper.setPropertyToAttr((Channel)parent, (AttributeKey)AttributeKeys.CLIENT_ID_KEY, (Object)clientChannelInfo.getClientId());
            RemotingHelper.setPropertyToAttr((Channel)parent, (AttributeKey)AttributeKeys.LANGUAGE_CODE_KEY, (Object)clientChannelInfo.getLanguage());
            RemotingHelper.setPropertyToAttr((Channel)parent, (AttributeKey)AttributeKeys.VERSION_KEY, (Object)clientChannelInfo.getVersion());
        }
    }

    protected RemotingCommand unregisterClient(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws RemotingCommandException {
        String consumerGroup;
        RemotingCommand response = RemotingCommand.createResponseCommand(UnregisterClientResponseHeader.class);
        UnregisterClientRequestHeader requestHeader = (UnregisterClientRequestHeader)request.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
        String producerGroup = requestHeader.getProducerGroup();
        if (producerGroup != null) {
            RemotingChannel channel = this.remotingChannelManager.removeProducerChannel(context, producerGroup, ctx.channel());
            if (channel != null) {
                ClientChannelInfo clientChannelInfo = new ClientChannelInfo((Channel)channel, requestHeader.getClientID(), request.getLanguage(), request.getVersion());
                this.messagingProcessor.unRegisterProducer(context, producerGroup, clientChannelInfo);
            } else {
                log.warn("unregister producer failed, channel not exist, may has been removed, producerGroup={}, channel={}", (Object)producerGroup, (Object)ctx.channel());
            }
        }
        if ((consumerGroup = requestHeader.getConsumerGroup()) != null) {
            RemotingChannel channel = this.remotingChannelManager.removeConsumerChannel(context, consumerGroup, ctx.channel());
            if (channel != null) {
                ClientChannelInfo clientChannelInfo = new ClientChannelInfo((Channel)channel, requestHeader.getClientID(), request.getLanguage(), request.getVersion());
                this.messagingProcessor.unRegisterConsumer(context, consumerGroup, clientChannelInfo);
            } else {
                log.warn("unregister consumer failed, channel not exist, may has been removed, consumerGroup={}, channel={}", (Object)consumerGroup, (Object)ctx.channel());
            }
        }
        response.setCode(0);
        response.setRemark("");
        return response;
    }

    protected RemotingCommand checkClientConfig(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setRemark("");
        return response;
    }

    public void doChannelCloseEvent(String remoteAddr, Channel channel) {
        Set<RemotingChannel> remotingChannelSet = this.remotingChannelManager.removeChannel(channel);
        for (RemotingChannel remotingChannel : remotingChannelSet) {
            this.messagingProcessor.doChannelCloseEvent(remoteAddr, (Channel)remotingChannel);
        }
    }

    protected class ProducerChangeListenerImpl
    implements ProducerChangeListener {
        protected ProducerChangeListenerImpl() {
        }

        public void handle(ProducerGroupEvent event, String group, ClientChannelInfo clientChannelInfo) {
            if (event == ProducerGroupEvent.CLIENT_UNREGISTER) {
                ClientManagerActivity.this.remotingChannelManager.removeProducerChannel(ProxyContext.createForInner(this.getClass()), group, clientChannelInfo.getChannel());
            }
        }
    }

    protected class ConsumerIdsChangeListenerImpl
    implements ConsumerIdsChangeListener {
        protected ConsumerIdsChangeListenerImpl() {
        }

        public void handle(ConsumerGroupEvent event, String group, Object ... args) {
            if (event == ConsumerGroupEvent.CLIENT_UNREGISTER) {
                if (args == null || args.length < 1) {
                    return;
                }
                if (args[0] instanceof ClientChannelInfo) {
                    ClientChannelInfo clientChannelInfo = (ClientChannelInfo)args[0];
                    ClientManagerActivity.this.remotingChannelManager.removeConsumerChannel(ProxyContext.createForInner(this.getClass()), group, clientChannelInfo.getChannel());
                    AbstractRemotingActivity.log.info("remove remoting channel when client unregister. clientChannelInfo:{}", (Object)clientChannelInfo);
                }
            }
        }

        public void shutdown() {
        }
    }
}

