/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.file.TieredFlatFile;
import org.apache.rocketmq.tieredstore.provider.FileSegmentAllocator;

public class TieredFileAllocator {
    private final FileSegmentAllocator fileSegmentAllocator;
    private final TieredMessageStoreConfig storeConfig;

    public TieredFileAllocator(TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.storeConfig = storeConfig;
        this.fileSegmentAllocator = new FileSegmentAllocator(storeConfig);
    }

    public TieredMessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public TieredFlatFile createFlatFileForCommitLog(String filePath) {
        TieredFlatFile tieredFlatFile = new TieredFlatFile(this.fileSegmentAllocator, FileSegmentType.COMMIT_LOG, filePath);
        if (tieredFlatFile.getBaseOffset() == -1L) {
            tieredFlatFile.setBaseOffset(0L);
        }
        return tieredFlatFile;
    }

    public TieredFlatFile createFlatFileForConsumeQueue(String filePath) {
        return new TieredFlatFile(this.fileSegmentAllocator, FileSegmentType.CONSUME_QUEUE, filePath);
    }

    public TieredFlatFile createFlatFileForIndexFile(String filePath) {
        return new TieredFlatFile(this.fileSegmentAllocator, FileSegmentType.INDEX, filePath);
    }
}

