/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.file.CompositeQueueFlatFile;
import org.apache.rocketmq.tieredstore.file.TieredFlatFileManager;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredDispatcher
extends ServiceThread
implements CommitLogDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private final String brokerName;
    private final MessageStore defaultStore;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFlatFileManager tieredFlatFileManager;
    private final ReentrantLock dispatchLock;
    private final ReentrantLock dispatchRequestListLock;
    private ConcurrentMap<CompositeQueueFlatFile, List<DispatchRequest>> dispatchRequestReadMap;
    private ConcurrentMap<CompositeQueueFlatFile, List<DispatchRequest>> dispatchRequestWriteMap;

    public TieredDispatcher(MessageStore defaultStore, TieredMessageStoreConfig storeConfig) {
        this.defaultStore = defaultStore;
        this.storeConfig = storeConfig;
        this.brokerName = storeConfig.getBrokerName();
        this.tieredFlatFileManager = TieredFlatFileManager.getInstance(storeConfig);
        this.dispatchRequestReadMap = new ConcurrentHashMap<CompositeQueueFlatFile, List<DispatchRequest>>();
        this.dispatchRequestWriteMap = new ConcurrentHashMap<CompositeQueueFlatFile, List<DispatchRequest>>();
        this.dispatchLock = new ReentrantLock();
        this.dispatchRequestListLock = new ReentrantLock();
        this.initScheduleTask();
    }

    private void initScheduleTask() {
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> this.tieredFlatFileManager.deepCopyFlatFileToList().forEach(flatFile -> {
            if (!flatFile.getCompositeFlatFileLock().isLocked()) {
                this.dispatchFlatFile((CompositeQueueFlatFile)flatFile);
            }
        }), 30L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(DispatchRequest request) {
        if (this.stopped) {
            return;
        }
        String topic = request.getTopic();
        if (TieredStoreUtil.isSystemTopic(topic)) {
            return;
        }
        CompositeQueueFlatFile flatFile = this.tieredFlatFileManager.getOrCreateFlatFileIfAbsent(new MessageQueue(topic, this.brokerName, request.getQueueId()));
        if (flatFile == null) {
            logger.error("[Bug]TieredDispatcher#dispatch: dispatch failed, can not create flatFile: topic: {}, queueId: {}", (Object)request.getTopic(), (Object)request.getQueueId());
            return;
        }
        int groupCommitCount = this.storeConfig.getTieredStoreMaxGroupCommitCount();
        if (this.dispatchRequestWriteMap.getOrDefault(flatFile, Collections.emptyList()).size() > groupCommitCount || this.dispatchRequestReadMap.getOrDefault(flatFile, Collections.emptyList()).size() > groupCommitCount) {
            return;
        }
        if (flatFile.getDispatchOffset() == -1L) {
            flatFile.initOffset(request.getConsumeQueueOffset());
        }
        if (request.getConsumeQueueOffset() == flatFile.getDispatchOffset()) {
            try {
                if (flatFile.getCompositeFlatFileLock().isLocked() || !flatFile.getCompositeFlatFileLock().tryLock(3L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("TieredDispatcher#dispatch: dispatch failed, can not get flatFile lock: topic: {}, queueId: {}", new Object[]{request.getTopic(), request.getQueueId(), e});
                if (!flatFile.getCompositeFlatFileLock().isLocked()) return;
                flatFile.getCompositeFlatFileLock().unlock();
                return;
            }
            if (request.getConsumeQueueOffset() != flatFile.getDispatchOffset()) {
                flatFile.getCompositeFlatFileLock().unlock();
                return;
            }
            SelectMappedBufferResult message = this.defaultStore.selectOneMessageByOffset(request.getCommitLogOffset(), request.getMsgSize());
            if (message == null) {
                logger.error("TieredDispatcher#dispatch: dispatch failed, can not get message from next store: topic: {}, queueId: {}, commitLog offset: {}, size: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getCommitLogOffset(), request.getMsgSize()});
                flatFile.getCompositeFlatFileLock().unlock();
                return;
            }
            try {
                if (request.getConsumeQueueOffset() < flatFile.getDispatchOffset()) {
                    return;
                }
                AppendResult result = flatFile.appendCommitLog(message.getByteBuffer());
                long newCommitLogOffset = flatFile.getCommitLogMaxOffset() - (long)message.getByteBuffer().remaining();
                this.handleAppendCommitLogResult(result, flatFile, request.getConsumeQueueOffset(), flatFile.getDispatchOffset(), newCommitLogOffset, request.getMsgSize(), request.getTagsCode(), message.getByteBuffer());
                if (result != AppendResult.SUCCESS) return;
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", request.getTopic()).put("queue_id", (long)request.getQueueId()).put("file_type", FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                TieredStoreMetricsManager.messagesDispatchTotal.add(1L, attributes);
                return;
            }
            catch (Exception throwable) {
                logger.error("TieredDispatcher#dispatch: dispatch failed: topic: {}, queueId: {}, queue offset: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset(), throwable});
                return;
            }
            finally {
                message.release();
                flatFile.getCompositeFlatFileLock().unlock();
            }
        }
        if (flatFile.getCompositeFlatFileLock().isLocked()) return;
        this.dispatchFlatFileAsync(flatFile);
    }

    private boolean detectFallBehind(CompositeQueueFlatFile flatFile) {
        int groupCommitCount = this.storeConfig.getTieredStoreMaxGroupCommitCount();
        return this.dispatchRequestWriteMap.getOrDefault(flatFile, Collections.emptyList()).size() > groupCommitCount || this.dispatchRequestReadMap.getOrDefault(flatFile, Collections.emptyList()).size() > groupCommitCount;
    }

    public void dispatchFlatFileAsync(CompositeQueueFlatFile flatFile) {
        this.dispatchFlatFileAsync(flatFile, null);
    }

    public void dispatchFlatFileAsync(CompositeQueueFlatFile flatFile, Consumer<Long> consumer) {
        TieredStoreExecutor.dispatchExecutor.execute(() -> {
            try {
                this.dispatchFlatFile(flatFile);
            }
            catch (Throwable throwable) {
                logger.error("[Bug]TieredDispatcher#dispatchFlatFileAsync dispatch failed, can not dispatch, topic: {}, queueId: {}", new Object[]{flatFile.getMessageQueue().getTopic(), flatFile.getMessageQueue().getQueueId(), throwable});
            }
            if (consumer != null) {
                consumer.accept(flatFile.getDispatchOffset());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchFlatFile(CompositeQueueFlatFile flatFile) {
        if (this.stopped) {
            return;
        }
        if (flatFile.getDispatchOffset() == -1L) {
            return;
        }
        if (this.detectFallBehind(flatFile)) {
            return;
        }
        MessageQueue mq = flatFile.getMessageQueue();
        String topic = mq.getTopic();
        int queueId = mq.getQueueId();
        long beforeOffset = flatFile.getDispatchOffset();
        long minOffsetInQueue = this.defaultStore.getMinOffsetInQueue(topic, queueId);
        long maxOffsetInQueue = this.defaultStore.getMaxOffsetInQueue(topic, queueId);
        if (beforeOffset >= maxOffsetInQueue) {
            return;
        }
        try {
            if (!flatFile.getCompositeFlatFileLock().tryLock(200L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn("TieredDispatcher#dispatchFlatFile: dispatch failed, can not get flatFile lock: topic: {}, queueId: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
            if (flatFile.getCompositeFlatFileLock().isLocked()) {
                flatFile.getCompositeFlatFileLock().unlock();
            }
            return;
        }
        try {
            long queueOffset = flatFile.getDispatchOffset();
            if (minOffsetInQueue > queueOffset) {
                logger.warn("BlobDispatcher#dispatchFlatFile: message that needs to be dispatched does not exist: topic: {}, queueId: {}, message queue offset: {}, min queue offset: {}", new Object[]{topic, queueId, queueOffset, minOffsetInQueue});
                flatFile.initOffset(minOffsetInQueue);
                queueOffset = minOffsetInQueue;
            }
            beforeOffset = queueOffset;
            long limit = Math.min(queueOffset + 100000L, maxOffsetInQueue);
            ConsumeQueue consumeQueue = (ConsumeQueue)this.defaultStore.getConsumeQueue(topic, queueId);
            while (queueOffset < limit) {
                SelectMappedBufferResult cqItem = consumeQueue.getIndexBuffer(queueOffset);
                if (cqItem == null) {
                    logger.error("[Bug]TieredDispatcher#dispatchFlatFile: dispatch failed, can not get cq item: topic: {}, queueId: {}, offset: {}", new Object[]{topic, queueId, queueOffset});
                    return;
                }
                long commitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqItem.getByteBuffer());
                int size = CQItemBufferUtil.getSize(cqItem.getByteBuffer());
                long tagCode = CQItemBufferUtil.getTagCode(cqItem.getByteBuffer());
                cqItem.release();
                SelectMappedBufferResult message = this.defaultStore.selectOneMessageByOffset(commitLogOffset, size);
                if (message == null) {
                    logger.error("TieredDispatcher#dispatchFlatFile: dispatch failed, can not get message from next store: topic: {}, queueId: {}, commitLog offset: {}, size: {}", new Object[]{topic, queueId, commitLogOffset, size});
                    break;
                }
                AppendResult result = flatFile.appendCommitLog(message.getByteBuffer(), true);
                long newCommitLogOffset = flatFile.getCommitLogMaxOffset() - (long)message.getByteBuffer().remaining();
                this.handleAppendCommitLogResult(result, flatFile, queueOffset, flatFile.getDispatchOffset(), newCommitLogOffset, size, tagCode, message.getByteBuffer());
                message.release();
                if (result != AppendResult.SUCCESS) {
                    --queueOffset;
                    break;
                }
                ++queueOffset;
            }
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("queue_id", (long)mq.getQueueId()).put("file_type", FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(queueOffset - beforeOffset, attributes);
        }
        finally {
            flatFile.getCompositeFlatFileLock().unlock();
        }
        if (flatFile.getDispatchOffset() < maxOffsetInQueue && !flatFile.getCompositeFlatFileLock().isLocked()) {
            this.dispatchFlatFileAsync(flatFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAppendCommitLogResult(AppendResult result, CompositeQueueFlatFile flatFile, long queueOffset, long dispatchOffset, long newCommitLogOffset, int size, long tagCode, ByteBuffer message) {
        MessageQueue mq = flatFile.getMessageQueue();
        String topic = mq.getTopic();
        int queueId = mq.getQueueId();
        switch (result) {
            case SUCCESS: {
                break;
            }
            case OFFSET_INCORRECT: {
                long offset = MessageBufferUtil.getQueueOffset(message);
                if (queueOffset != offset) {
                    logger.error("[Bug]Dispatch append commit log, result={}, offset={}, msg offset={}", (Object)queueOffset, (Object)offset);
                }
                return;
            }
            case BUFFER_FULL: {
                logger.debug("Commitlog buffer full, result={}, topic={}, queueId={}, offset={}", new Object[]{result, topic, queueId, queueOffset});
                return;
            }
            default: {
                logger.info("Commitlog append failed, result={}, topic={}, queueId={}, offset={}", new Object[]{result, topic, queueId, queueOffset});
                return;
            }
        }
        this.dispatchRequestListLock.lock();
        try {
            Map<String, String> properties = MessageBufferUtil.getProperties(message);
            DispatchRequest dispatchRequest = new DispatchRequest(topic, queueId, newCommitLogOffset, size, tagCode, MessageBufferUtil.getStoreTimeStamp(message), queueOffset, properties.getOrDefault("KEYS", ""), properties.getOrDefault("UNIQ_KEY", ""), 0, 0L, new HashMap());
            dispatchRequest.setOffsetId(MessageBufferUtil.getOffsetId(message));
            List requestList = this.dispatchRequestWriteMap.computeIfAbsent(flatFile, k -> new ArrayList());
            requestList.add(dispatchRequest);
            if (((DispatchRequest)requestList.get(0)).getConsumeQueueOffset() >= flatFile.getConsumeQueueMaxOffset()) {
                this.wakeup();
            }
        }
        finally {
            this.dispatchRequestListLock.unlock();
        }
    }

    public void swapDispatchRequestList() {
        this.dispatchRequestListLock.lock();
        try {
            this.dispatchRequestReadMap = this.dispatchRequestWriteMap;
            this.dispatchRequestWriteMap = new ConcurrentHashMap<CompositeQueueFlatFile, List<DispatchRequest>>();
        }
        finally {
            this.dispatchRequestListLock.unlock();
        }
    }

    public void sendBackDispatchRequestList() {
        if (!this.dispatchRequestReadMap.isEmpty()) {
            this.dispatchRequestListLock.lock();
            try {
                this.dispatchRequestReadMap.forEach((flatFile, requestList) -> {
                    if (requestList.isEmpty()) {
                        logger.warn("[Bug]TieredDispatcher#sendBackDispatchRequestList: requestList is empty, no need to send back: topic: {}, queueId: {}", (Object)flatFile.getMessageQueue().getTopic(), (Object)flatFile.getMessageQueue().getQueueId());
                        return;
                    }
                    List requestListToWrite = this.dispatchRequestWriteMap.computeIfAbsent((CompositeQueueFlatFile)flatFile, k -> new ArrayList());
                    if (!requestListToWrite.isEmpty() && ((DispatchRequest)requestList.get(requestList.size() - 1)).getConsumeQueueOffset() > ((DispatchRequest)requestListToWrite.get(0)).getConsumeQueueOffset()) {
                        logger.warn("[Bug]TieredDispatcher#sendBackDispatchRequestList: dispatch request list is not continuous: topic: {}, queueId: {}, last list max offset: {}, new list min offset: {}", new Object[]{flatFile.getMessageQueue().getTopic(), flatFile.getMessageQueue().getQueueId(), ((DispatchRequest)requestList.get(requestList.size() - 1)).getConsumeQueueOffset(), ((DispatchRequest)requestListToWrite.get(0)).getConsumeQueueOffset()});
                        requestList.sort(Comparator.comparingLong(DispatchRequest::getConsumeQueueOffset));
                    }
                    requestList.addAll(requestListToWrite);
                    this.dispatchRequestWriteMap.put((CompositeQueueFlatFile)flatFile, (List<DispatchRequest>)requestList);
                });
                this.dispatchRequestReadMap = new ConcurrentHashMap<CompositeQueueFlatFile, List<DispatchRequest>>();
            }
            finally {
                this.dispatchRequestListLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildConsumeQueueAndIndexFile() {
        this.swapDispatchRequestList();
        HashMap<MessageQueue, Long> cqMetricsMap = new HashMap<MessageQueue, Long>();
        HashMap<MessageQueue, Long> ifMetricsMap = new HashMap<MessageQueue, Long>();
        for (Map.Entry entry : this.dispatchRequestReadMap.entrySet()) {
            CompositeQueueFlatFile flatFile = (CompositeQueueFlatFile)entry.getKey();
            List requestList = (List)entry.getValue();
            if (flatFile.isClosed()) {
                requestList.clear();
            }
            MessageQueue messageQueue2 = flatFile.getMessageQueue();
            Iterator iterator = requestList.iterator();
            while (iterator.hasNext()) {
                DispatchRequest request = (DispatchRequest)iterator.next();
                if (request.getConsumeQueueOffset() < flatFile.getConsumeQueueMaxOffset()) {
                    iterator.remove();
                    continue;
                }
                if (flatFile.getCommitLogDispatchCommitOffset() < request.getConsumeQueueOffset()) break;
                AppendResult result = flatFile.appendConsumeQueue(request, true);
                if (AppendResult.SUCCESS.equals((Object)result)) {
                    long cqCount = cqMetricsMap.computeIfAbsent(messageQueue2, key -> 0L);
                    cqMetricsMap.put(messageQueue2, cqCount + 1L);
                    if (!this.storeConfig.isMessageIndexEnable()) continue;
                    result = flatFile.appendIndexFile(request);
                    if (AppendResult.SUCCESS.equals((Object)result)) {
                        long ifCount = ifMetricsMap.computeIfAbsent(messageQueue2, key -> 0L);
                        ifMetricsMap.put(messageQueue2, ifCount + 1L);
                        iterator.remove();
                        continue;
                    }
                    logger.warn("Build indexFile failed, result: {}, topic: {}, queue: {}, queue offset: {}", new Object[]{result, request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset()});
                    continue;
                }
                if (AppendResult.OFFSET_INCORRECT.equals((Object)result)) {
                    logger.error("Build consumeQueue and indexFile failed, offset is messed up, try to rebuild cq: topic: {}, queue: {}, queue offset: {}, max queue offset: {}", new Object[]{request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset(), flatFile.getConsumeQueueMaxOffset()});
                    try {
                        flatFile.getCompositeFlatFileLock().lock();
                        flatFile.initOffset(flatFile.getConsumeQueueMaxOffset());
                        this.dispatchRequestWriteMap.remove(flatFile);
                        requestList.clear();
                        break;
                    }
                    finally {
                        flatFile.getCompositeFlatFileLock().unlock();
                    }
                }
                logger.warn("Build consumeQueue failed, result: {}, topic: {}, queue: {}, queue offset: {}", new Object[]{result, request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset()});
            }
            if (!requestList.isEmpty()) continue;
            this.dispatchRequestReadMap.remove(flatFile);
        }
        cqMetricsMap.forEach((messageQueue, count) -> {
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", messageQueue.getTopic()).put("queue_id", (long)messageQueue.getQueueId()).put("file_type", FileSegmentType.CONSUME_QUEUE.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(count.longValue(), attributes);
        });
        ifMetricsMap.forEach((messageQueue, count) -> {
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", messageQueue.getTopic()).put("queue_id", (long)messageQueue.getQueueId()).put("file_type", FileSegmentType.INDEX.name().toLowerCase()).build();
            TieredStoreMetricsManager.messagesDispatchTotal.add(count.longValue(), attributes);
        });
        this.sendBackDispatchRequestList();
    }

    public void doDispatchTask() {
        try {
            this.dispatchLock.lock();
            this.buildConsumeQueueAndIndexFile();
        }
        catch (Exception e) {
            logger.error("Build consumeQueue and indexFile failed", (Throwable)e);
        }
        finally {
            this.dispatchLock.unlock();
        }
    }

    public String getServiceName() {
        return "TieredStoreDispatcherService";
    }

    public void run() {
        while (!this.stopped) {
            this.waitForRunning(1000L);
            this.doDispatchTask();
        }
    }
}

