/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.transaction;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;

public class TransactionDataManager
implements StartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final AtomicLong maxTransactionDataExpireTime = new AtomicLong(System.currentTimeMillis());
    protected final Map<String, NavigableSet<TransactionData>> transactionIdDataMap = new ConcurrentHashMap<String, NavigableSet<TransactionData>>();
    protected final TransactionDataCleaner transactionDataCleaner = new TransactionDataCleaner();

    protected String buildKey(String producerGroup, String transactionId) {
        return producerGroup + "@" + transactionId;
    }

    public void addTransactionData(String producerGroup, String transactionId, TransactionData transactionData) {
        this.transactionIdDataMap.compute(this.buildKey(producerGroup, transactionId), (key, dataSet) -> {
            if (dataSet == null) {
                dataSet = new ConcurrentSkipListSet<TransactionData>();
            }
            dataSet.add(transactionData);
            if (dataSet.size() > ConfigurationManager.getProxyConfig().getTransactionDataMaxNum()) {
                dataSet.pollFirst();
            }
            return dataSet;
        });
    }

    public TransactionData pollNoExpireTransactionData(String producerGroup, String transactionId) {
        AtomicReference res = new AtomicReference();
        long currTimestamp = System.currentTimeMillis();
        this.transactionIdDataMap.computeIfPresent(this.buildKey(producerGroup, transactionId), (key, dataSet) -> {
            TransactionData data = (TransactionData)dataSet.pollLast();
            while (data != null && data.getExpireTime() < currTimestamp) {
                data = (TransactionData)dataSet.pollLast();
            }
            if (data != null) {
                res.set(data);
            }
            if (dataSet.isEmpty()) {
                return null;
            }
            return dataSet;
        });
        return (TransactionData)res.get();
    }

    public void removeTransactionData(String producerGroup, String transactionId, TransactionData transactionData) {
        this.transactionIdDataMap.computeIfPresent(this.buildKey(producerGroup, transactionId), (key, dataSet) -> {
            dataSet.remove(transactionData);
            if (dataSet.isEmpty()) {
                return null;
            }
            return dataSet;
        });
    }

    protected void cleanExpireTransactionData() {
        long currTimestamp = System.currentTimeMillis();
        Set<String> transactionIdSet = this.transactionIdDataMap.keySet();
        for (String transactionId : transactionIdSet) {
            this.transactionIdDataMap.computeIfPresent(transactionId, (transactionIdKey, dataSet) -> {
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    try {
                        TransactionData data = (TransactionData)iterator.next();
                        if (data.getExpireTime() >= currTimestamp) break;
                        iterator.remove();
                    }
                    catch (NoSuchElementException ignore) {
                        // empty catch block
                        break;
                    }
                }
                if (dataSet.isEmpty()) {
                    return null;
                }
                try {
                    TransactionData maxData = (TransactionData)dataSet.last();
                    this.maxTransactionDataExpireTime.set(Math.max(this.maxTransactionDataExpireTime.get(), maxData.getExpireTime()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return dataSet;
            });
        }
    }

    protected void waitTransactionDataClear() throws InterruptedException {
        this.cleanExpireTransactionData();
        long waitMs = Math.max(this.maxTransactionDataExpireTime.get() - System.currentTimeMillis(), 0L);
        waitMs = Math.min(waitMs, ConfigurationManager.getProxyConfig().getTransactionDataMaxWaitClearMillis());
        if (waitMs > 0L) {
            TimeUnit.MILLISECONDS.sleep(waitMs);
        }
    }

    public void shutdown() throws Exception {
        this.transactionDataCleaner.shutdown();
        this.waitTransactionDataClear();
    }

    public void start() throws Exception {
        this.transactionDataCleaner.start();
    }

    protected class TransactionDataCleaner
    extends ServiceThread {
        protected TransactionDataCleaner() {
        }

        public String getServiceName() {
            return "TransactionDataCleaner";
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                this.waitForRunning(ConfigurationManager.getProxyConfig().getTransactionDataExpireScanPeriodMillis());
            }
            log.info(this.getServiceName() + " service stopped");
        }

        protected void onWaitEnd() {
            TransactionDataManager.this.cleanExpireTransactionData();
        }
    }
}

