/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.pipeline;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.rocketmq.acl.AccessResource;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AuthenticationPipeline
implements RequestPipeline {
    private final List<AccessValidator> accessValidatorList;

    public AuthenticationPipeline(List<AccessValidator> accessValidatorList) {
        this.accessValidatorList = accessValidatorList;
    }

    @Override
    public void execute(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        if (config.isEnableACL()) {
            for (AccessValidator accessValidator : this.accessValidatorList) {
                AccessResource accessResource = accessValidator.parse(request, context.getRemoteAddress());
                accessValidator.validate(accessResource);
            }
        }
    }
}

