/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.utils.AbstractStartAndShutdown;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.common.ReceiptHandleGroup;
import org.apache.rocketmq.proxy.common.RenewStrategyPolicy;
import org.apache.rocketmq.proxy.common.channel.ChannelHelper;
import org.apache.rocketmq.proxy.common.utils.ExceptionUtils;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.remoting.protocol.subscription.RetryPolicy;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class ReceiptHandleProcessor
extends AbstractStartAndShutdown {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final ConcurrentMap<ReceiptHandleGroupKey, ReceiptHandleGroup> receiptHandleGroupMap;
    protected final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("RenewalScheduledThread_"));
    protected ThreadPoolExecutor renewalWorkerService;
    protected final MessagingProcessor messagingProcessor;
    protected static final RetryPolicy RENEW_POLICY = new RenewStrategyPolicy();

    public ReceiptHandleProcessor(MessagingProcessor messagingProcessor) {
        this.messagingProcessor = messagingProcessor;
        this.receiptHandleGroupMap = new ConcurrentHashMap<ReceiptHandleGroupKey, ReceiptHandleGroup>();
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        this.renewalWorkerService = ThreadPoolMonitor.createAndMonitor((int)proxyConfig.getRenewThreadPoolNums(), (int)proxyConfig.getRenewMaxThreadPoolNums(), (long)1L, (TimeUnit)TimeUnit.MINUTES, (String)"RenewalWorkerThread", (int)proxyConfig.getRenewThreadPoolQueueCapacity());
        this.init();
    }

    protected void init() {
        this.registerConsumerListener();
        this.renewalWorkerService.setRejectedExecutionHandler((r, executor) -> log.warn("add renew task failed. queueSize:{}", (Object)executor.getQueue().size()));
        this.appendStartAndShutdown(new StartAndShutdown(){

            public void start() throws Exception {
                ReceiptHandleProcessor.this.scheduledExecutorService.scheduleWithFixedDelay(() -> ReceiptHandleProcessor.this.scheduleRenewTask(), 0L, ConfigurationManager.getProxyConfig().getRenewSchedulePeriodMillis(), TimeUnit.MILLISECONDS);
            }

            public void shutdown() throws Exception {
                ReceiptHandleProcessor.this.scheduledExecutorService.shutdown();
                ReceiptHandleProcessor.this.clearAllHandle();
            }
        });
    }

    protected void registerConsumerListener() {
        this.messagingProcessor.registerConsumerListener(new ConsumerIdsChangeListener(){

            public void handle(ConsumerGroupEvent event, String group, Object ... args) {
                if (ConsumerGroupEvent.CLIENT_UNREGISTER.equals((Object)event)) {
                    if (args == null || args.length < 1) {
                        return;
                    }
                    if (args[0] instanceof ClientChannelInfo) {
                        ClientChannelInfo clientChannelInfo = (ClientChannelInfo)args[0];
                        if (ChannelHelper.isRemote(clientChannelInfo.getChannel())) {
                            return;
                        }
                        ReceiptHandleProcessor.this.clearGroup(new ReceiptHandleGroupKey(clientChannelInfo.getChannel(), group));
                        log.info("clear handle of this client when client unregister. group:{}, clientChannelInfo:{}", (Object)group, (Object)clientChannelInfo);
                    }
                }
            }

            public void shutdown() {
            }
        });
    }

    protected ProxyContext createContext(String actionName) {
        return ProxyContext.createForInner(((Object)((Object)this)).getClass().getSimpleName() + actionName);
    }

    protected void scheduleRenewTask() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
            for (Map.Entry entry : this.receiptHandleGroupMap.entrySet()) {
                ReceiptHandleGroupKey key = (ReceiptHandleGroupKey)entry.getKey();
                if (this.clientIsOffline(key)) {
                    this.clearGroup(key);
                    continue;
                }
                ReceiptHandleGroup group = (ReceiptHandleGroup)entry.getValue();
                group.scan((msgID, handleStr, v) -> {
                    long current = System.currentTimeMillis();
                    ReceiptHandle handle = ReceiptHandle.decode((String)v.getReceiptHandleStr());
                    if (handle.getNextVisibleTime() - current > proxyConfig.getRenewAheadTimeMillis()) {
                        return;
                    }
                    this.renewalWorkerService.submit(() -> this.renewMessage(group, msgID, handleStr));
                });
            }
        }
        catch (Exception e) {
            log.error("unexpect error when schedule renew task", (Throwable)e);
        }
        log.debug("scan for renewal done. cost:{}ms", (Object)stopwatch.elapsed().toMillis());
    }

    protected void renewMessage(ReceiptHandleGroup group, String msgID, String handleStr) {
        try {
            group.computeIfPresent(msgID, handleStr, this::startRenewMessage);
        }
        catch (Exception e) {
            log.error("error when renew message. msgID:{}, handleStr:{}", new Object[]{msgID, handleStr, e});
        }
    }

    protected CompletableFuture<MessageReceiptHandle> startRenewMessage(MessageReceiptHandle messageReceiptHandle) {
        CompletableFuture<MessageReceiptHandle> resFuture = new CompletableFuture<MessageReceiptHandle>();
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        ProxyContext context = this.createContext("RenewMessage");
        ReceiptHandle handle = ReceiptHandle.decode((String)messageReceiptHandle.getReceiptHandleStr());
        long current = System.currentTimeMillis();
        try {
            if (messageReceiptHandle.getRenewRetryTimes() >= proxyConfig.getMaxRenewRetryTimes()) {
                log.warn("handle has exceed max renewRetryTimes. handle:{}", (Object)messageReceiptHandle);
                return CompletableFuture.completedFuture(null);
            }
            if (current - messageReceiptHandle.getConsumeTimestamp() < proxyConfig.getRenewMaxTimeMillis()) {
                CompletableFuture<AckResult> future = this.messagingProcessor.changeInvisibleTime(context, handle, messageReceiptHandle.getMessageId(), messageReceiptHandle.getGroup(), messageReceiptHandle.getTopic(), RENEW_POLICY.nextDelayDuration(messageReceiptHandle.getRenewTimes()));
                future.whenComplete((ackResult, throwable) -> {
                    if (throwable != null) {
                        log.error("error when renew. handle:{}", (Object)messageReceiptHandle, throwable);
                        if (this.renewExceptionNeedRetry((Throwable)throwable)) {
                            messageReceiptHandle.incrementAndGetRenewRetryTimes();
                            resFuture.complete(messageReceiptHandle);
                        } else {
                            resFuture.complete(null);
                        }
                    } else if (AckStatus.OK.equals((Object)ackResult.getStatus())) {
                        messageReceiptHandle.updateReceiptHandle(ackResult.getExtraInfo());
                        messageReceiptHandle.resetRenewRetryTimes();
                        messageReceiptHandle.incrementRenewTimes();
                        resFuture.complete(messageReceiptHandle);
                    } else {
                        log.error("renew response is not ok. result:{}, handle:{}", ackResult, (Object)messageReceiptHandle);
                        resFuture.complete(null);
                    }
                });
            } else {
                SubscriptionGroupConfig subscriptionGroupConfig = this.messagingProcessor.getMetadataService().getSubscriptionGroupConfig(context, messageReceiptHandle.getGroup());
                if (subscriptionGroupConfig == null) {
                    log.error("group's subscriptionGroupConfig is null when renew. handle: {}", (Object)messageReceiptHandle);
                    return CompletableFuture.completedFuture(null);
                }
                RetryPolicy retryPolicy = subscriptionGroupConfig.getGroupRetryPolicy().getRetryPolicy();
                CompletableFuture<AckResult> future = this.messagingProcessor.changeInvisibleTime(context, handle, messageReceiptHandle.getMessageId(), messageReceiptHandle.getGroup(), messageReceiptHandle.getTopic(), retryPolicy.nextDelayDuration(messageReceiptHandle.getReconsumeTimes()));
                future.whenComplete((ackResult, throwable) -> {
                    if (throwable != null) {
                        log.error("error when nack in renew. handle:{}", (Object)messageReceiptHandle, throwable);
                    }
                    resFuture.complete(null);
                });
            }
        }
        catch (Throwable t) {
            log.error("unexpect error when renew message, stop to renew it. handle:{}", (Object)messageReceiptHandle, (Object)t);
            resFuture.complete(null);
        }
        return resFuture;
    }

    protected boolean renewExceptionNeedRetry(Throwable t) {
        ProxyException proxyException;
        return !((t = ExceptionUtils.getRealException(t)) instanceof ProxyException) || !ProxyExceptionCode.INVALID_BROKER_NAME.equals((Object)(proxyException = (ProxyException)t).getCode()) && !ProxyExceptionCode.INVALID_RECEIPT_HANDLE.equals((Object)proxyException.getCode());
    }

    protected boolean clientIsOffline(ReceiptHandleGroupKey groupKey) {
        return this.messagingProcessor.findConsumerChannel(this.createContext("JudgeClientOnline"), groupKey.group, groupKey.channel) == null;
    }

    public void addReceiptHandle(ProxyContext ctx, Channel channel, String group, String msgID, String receiptHandle, MessageReceiptHandle messageReceiptHandle) {
        this.addReceiptHandle(ctx, new ReceiptHandleGroupKey(channel, group), msgID, receiptHandle, messageReceiptHandle);
    }

    protected void addReceiptHandle(ProxyContext ctx, ReceiptHandleGroupKey key, String msgID, String receiptHandle, MessageReceiptHandle messageReceiptHandle) {
        if (key == null) {
            return;
        }
        ((ReceiptHandleGroup)ConcurrentHashMapUtils.computeIfAbsent(this.receiptHandleGroupMap, (Object)key, k -> new ReceiptHandleGroup())).put(msgID, receiptHandle, messageReceiptHandle);
    }

    public MessageReceiptHandle removeReceiptHandle(ProxyContext ctx, Channel channel, String group, String msgID, String receiptHandle) {
        return this.removeReceiptHandle(ctx, new ReceiptHandleGroupKey(channel, group), msgID, receiptHandle);
    }

    protected MessageReceiptHandle removeReceiptHandle(ProxyContext ctx, ReceiptHandleGroupKey key, String msgID, String receiptHandle) {
        if (key == null) {
            return null;
        }
        ReceiptHandleGroup handleGroup = (ReceiptHandleGroup)this.receiptHandleGroupMap.get(key);
        if (handleGroup == null) {
            return null;
        }
        return handleGroup.remove(msgID, receiptHandle);
    }

    protected void clearGroup(ReceiptHandleGroupKey key) {
        if (key == null) {
            return;
        }
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        ProxyContext context = this.createContext("ClearGroup");
        ReceiptHandleGroup handleGroup = (ReceiptHandleGroup)this.receiptHandleGroupMap.remove(key);
        if (handleGroup == null) {
            return;
        }
        handleGroup.scan((msgID, handle, v) -> {
            try {
                handleGroup.computeIfPresent(msgID, handle, messageReceiptHandle -> {
                    ReceiptHandle receiptHandle = ReceiptHandle.decode((String)messageReceiptHandle.getReceiptHandleStr());
                    this.messagingProcessor.changeInvisibleTime(context, receiptHandle, messageReceiptHandle.getMessageId(), messageReceiptHandle.getGroup(), messageReceiptHandle.getTopic(), proxyConfig.getInvisibleTimeMillisWhenClear());
                    return CompletableFuture.completedFuture(null);
                });
            }
            catch (Exception e) {
                log.error("error when clear handle for group. key:{}", (Object)key, (Object)e);
            }
        });
    }

    protected void clearAllHandle() {
        log.info("start clear all handle in receiptHandleProcessor");
        Set keySet = this.receiptHandleGroupMap.keySet();
        for (ReceiptHandleGroupKey key : keySet) {
            this.clearGroup(key);
        }
        log.info("clear all handle in receiptHandleProcessor done");
    }

    public static class ReceiptHandleGroupKey {
        protected final Channel channel;
        protected final String group;

        public ReceiptHandleGroupKey(Channel channel, String group) {
            this.channel = channel;
            this.group = group;
        }

        protected String getChannelId() {
            return this.channel.id().asLongText();
        }

        public String getGroup() {
            return this.group;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReceiptHandleGroupKey key = (ReceiptHandleGroupKey)o;
            return Objects.equal((Object)this.getChannelId(), (Object)key.getChannelId()) && Objects.equal((Object)this.group, (Object)key.group);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getChannelId(), this.group});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("channelId", (Object)this.getChannelId()).add("group", (Object)this.group).toString();
        }
    }
}

