/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.namesrv;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.namesrv.NameServerUpdateCallback;
import org.apache.rocketmq.common.namesrv.TopAddressing;
import org.apache.rocketmq.common.utils.HttpTinyClient;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class DefaultTopAddressing
implements TopAddressing {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String nsAddr;
    private String wsAddr;
    private String unitName;
    private Map<String, String> para;
    private List<TopAddressing> topAddressingList;

    public DefaultTopAddressing(String wsAddr) {
        this(wsAddr, null);
    }

    public DefaultTopAddressing(String wsAddr, String unitName) {
        this.wsAddr = wsAddr;
        this.unitName = unitName;
        this.topAddressingList = this.loadCustomTopAddressing();
    }

    public DefaultTopAddressing(String unitName, Map<String, String> para, String wsAddr) {
        this.wsAddr = wsAddr;
        this.unitName = unitName;
        this.para = para;
        this.topAddressingList = this.loadCustomTopAddressing();
    }

    private static String clearNewLine(String str) {
        String newString = str.trim();
        int index = newString.indexOf("\r");
        if (index != -1) {
            return newString.substring(0, index);
        }
        index = newString.indexOf("\n");
        if (index != -1) {
            return newString.substring(0, index);
        }
        return newString;
    }

    private List<TopAddressing> loadCustomTopAddressing() {
        ServiceLoader<TopAddressing> serviceLoader = ServiceLoader.load(TopAddressing.class);
        Iterator<TopAddressing> iterator = serviceLoader.iterator();
        ArrayList<TopAddressing> topAddressingList = new ArrayList<TopAddressing>();
        if (iterator.hasNext()) {
            topAddressingList.add(iterator.next());
        }
        return topAddressingList;
    }

    @Override
    public final String fetchNSAddr() {
        if (!this.topAddressingList.isEmpty()) {
            for (TopAddressing topAddressing : this.topAddressingList) {
                String nsAddress = topAddressing.fetchNSAddr();
                if (Strings.isNullOrEmpty((String)nsAddress)) continue;
                return nsAddress;
            }
        }
        return this.fetchNSAddr(true, 3000L);
    }

    @Override
    public void registerChangeCallBack(NameServerUpdateCallback changeCallBack) {
        if (!this.topAddressingList.isEmpty()) {
            for (TopAddressing topAddressing : this.topAddressingList) {
                topAddressing.registerChangeCallBack(changeCallBack);
            }
        }
    }

    public final String fetchNSAddr(boolean verbose, long timeoutMills) {
        String url;
        block10: {
            url = this.wsAddr;
            try {
                if (null != this.para && this.para.size() > 0) {
                    url = !UtilAll.isBlank(this.unitName) ? url + "-" + this.unitName + "?nofix=1&" : url + "?";
                    for (Map.Entry<String, String> entry : this.para.entrySet()) {
                        url = url + entry.getKey() + "=" + entry.getValue() + "&";
                    }
                    url = url.substring(0, url.length() - 1);
                } else if (!UtilAll.isBlank(this.unitName)) {
                    url = url + "-" + this.unitName + "?nofix=1";
                }
                HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(url, null, null, "UTF-8", timeoutMills);
                if (200 == result.code) {
                    String responseStr = result.content;
                    if (responseStr != null) {
                        return DefaultTopAddressing.clearNewLine(responseStr);
                    }
                    LOGGER.error("fetch nameserver address is null");
                } else {
                    LOGGER.error("fetch nameserver address failed. statusCode=" + result.code);
                }
            }
            catch (IOException e) {
                if (!verbose) break block10;
                LOGGER.error("fetch name server address exception", (Throwable)e);
            }
        }
        if (verbose) {
            String errorMsg = "connect to " + url + " failed, maybe the domain name " + MixAll.getWSAddr() + " not bind in /etc/hosts";
            errorMsg = errorMsg + FAQUrl.suggestTodo("https://rocketmq.apache.org/docs/bestPractice/06FAQ");
            LOGGER.warn(errorMsg);
        }
        return null;
    }

    public String getNsAddr() {
        return this.nsAddr;
    }

    public void setNsAddr(String nsAddr) {
        this.nsAddr = nsAddr;
    }
}

