/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.ServiceThread;

public abstract class LifecycleAwareServiceThread
extends ServiceThread {
    private final AtomicBoolean started = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.started.set(true);
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.started.notifyAll();
        }
        this.run0();
    }

    public abstract void run0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStarted(long timeout) throws InterruptedException {
        long expire = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            long duration;
            while (!this.started.get() && (duration = expire - System.nanoTime()) >= TimeUnit.MILLISECONDS.toNanos(1L)) {
                this.started.wait(TimeUnit.NANOSECONDS.toMillis(duration));
            }
        }
    }
}

