/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.common.Attributes;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.mqtrace.SendMessageContext;
import org.apache.rocketmq.broker.mqtrace.SendMessageHook;
import org.apache.rocketmq.common.AbortProcessException;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageType;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public abstract class AbstractSendMessageProcessor
implements NettyRequestProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected static final Logger DLQ_LOG = LoggerFactory.getLogger((String)"RocketmqDLQ");
    protected List<ConsumeMessageHook> consumeMessageHookList;
    protected static final int DLQ_NUMS_PER_GROUP = 1;
    protected final BrokerController brokerController;
    protected final Random random = new Random(System.currentTimeMillis());
    private List<SendMessageHook> sendMessageHookList;

    public AbstractSendMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }

    protected RemotingCommand consumerSendMsgBack(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        Integer times;
        TopicConfig topicConfig;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ConsumerSendMsgBackRequestHeader requestHeader = (ConsumerSendMsgBackRequestHeader)request.decodeCommandCustomHeader(ConsumerSendMsgBackRequestHeader.class);
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (null == masterBroker) {
            response.setCode(1);
            response.setRemark("no master available along with " + this.brokerController.getBrokerConfig().getBrokerIP1());
            return response;
        }
        BrokerController currentBroker = this.brokerController;
        SubscriptionGroupConfig subscriptionGroupConfig = masterBroker.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getGroup());
        if (null == subscriptionGroupConfig) {
            response.setCode(26);
            response.setRemark("subscription group not exist, " + requestHeader.getGroup() + " " + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
            return response;
        }
        BrokerConfig masterBrokerConfig = masterBroker.getBrokerConfig();
        if (!PermName.isWriteable((int)masterBrokerConfig.getBrokerPermission())) {
            response.setCode(16);
            response.setRemark("the broker[" + masterBrokerConfig.getBrokerIP1() + "] sending message is forbidden");
            return response;
        }
        if (subscriptionGroupConfig.getRetryQueueNums() <= 0) {
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        String newTopic = MixAll.getRetryTopic((String)requestHeader.getGroup());
        int queueIdInt = this.random.nextInt(subscriptionGroupConfig.getRetryQueueNums());
        int topicSysFlag = 0;
        if (requestHeader.isUnitMode()) {
            topicSysFlag = TopicSysFlag.buildSysFlag((boolean)false, (boolean)true);
        }
        if (null == (topicConfig = masterBroker.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, subscriptionGroupConfig.getRetryQueueNums(), 6, topicSysFlag))) {
            response.setCode(1);
            response.setRemark("topic[" + newTopic + "] not exist");
            return response;
        }
        if (!PermName.isWriteable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark(String.format("the topic[%s] sending message is forbidden", newTopic));
            return response;
        }
        MessageExt msgExt = currentBroker.getMessageStore().lookMessageByOffset(requestHeader.getOffset().longValue());
        if (null == msgExt) {
            response.setCode(1);
            response.setRemark("look message by offset failed, " + requestHeader.getOffset());
            return response;
        }
        String retryTopic = msgExt.getProperty("RETRY_TOPIC");
        if (null == retryTopic) {
            MessageAccessor.putProperty((Message)msgExt, (String)"RETRY_TOPIC", (String)msgExt.getTopic());
        }
        msgExt.setWaitStoreMsgOK(false);
        int delayLevel = requestHeader.getDelayLevel();
        int maxReconsumeTimes = subscriptionGroupConfig.getRetryMaxTimes();
        if (request.getVersion() >= MQVersion.Version.V3_4_9.ordinal() && (times = requestHeader.getMaxReconsumeTimes()) != null) {
            maxReconsumeTimes = times;
        }
        boolean isDLQ = false;
        if (msgExt.getReconsumeTimes() >= maxReconsumeTimes || delayLevel < 0) {
            Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("consumer_group", requestHeader.getGroup()).put("topic", requestHeader.getOriginTopic()).put("is_system", BrokerMetricsManager.isSystem(requestHeader.getOriginTopic(), requestHeader.getGroup())).build();
            BrokerMetricsManager.sendToDlqMessages.add(1L, attributes);
            isDLQ = true;
            newTopic = MixAll.getDLQTopic((String)requestHeader.getGroup());
            queueIdInt = this.randomQueueId(1);
            topicConfig = masterBroker.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, 1, 6, 0);
            if (null == topicConfig) {
                response.setCode(1);
                response.setRemark("topic[" + newTopic + "] not exist");
                return response;
            }
            msgExt.setDelayTimeLevel(0);
        } else {
            if (0 == delayLevel) {
                delayLevel = 3 + msgExt.getReconsumeTimes();
            }
            msgExt.setDelayTimeLevel(delayLevel);
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(newTopic);
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode(null, (String)msgExt.getTags()));
        msgInner.setQueueId(queueIdInt);
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes() + 1);
        String originMsgId = MessageAccessor.getOriginMessageId((Message)msgExt);
        MessageAccessor.setOriginMessageId((Message)msgInner, (String)(UtilAll.isBlank((String)originMsgId) ? msgExt.getMsgId() : originMsgId));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        boolean succeeded = false;
        PutMessageResult putMessageResult = masterBroker.getMessageStore().putMessage(msgInner);
        if (putMessageResult != null) {
            String commercialOwner = (String)request.getExtFields().get("Owner");
            switch (putMessageResult.getPutMessageStatus()) {
                case PUT_OK: {
                    String backTopic = msgExt.getTopic();
                    String correctTopic = msgExt.getProperty("RETRY_TOPIC");
                    if (correctTopic != null) {
                        backTopic = correctTopic;
                    }
                    if ("SCHEDULE_TOPIC_XXXX".equals(msgInner.getTopic())) {
                        masterBroker.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic());
                        masterBroker.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
                        masterBroker.getBrokerStatsManager().incQueuePutNums(msgInner.getTopic(), Integer.valueOf(msgInner.getQueueId()));
                        masterBroker.getBrokerStatsManager().incQueuePutSize(msgInner.getTopic(), Integer.valueOf(msgInner.getQueueId()), putMessageResult.getAppendMessageResult().getWroteBytes());
                    }
                    masterBroker.getBrokerStatsManager().incSendBackNums(requestHeader.getGroup(), backTopic);
                    if (isDLQ) {
                        masterBroker.getBrokerStatsManager().incDLQStatValue("SNDBCK2DLQ_TIMES", commercialOwner, requestHeader.getGroup(), requestHeader.getOriginTopic(), BrokerStatsManager.StatsType.SEND_BACK_TO_DLQ.name(), 1);
                        String uniqKey = (String)msgInner.getProperties().get("UNIQ_KEY");
                        DLQ_LOG.info("send msg to DLQ {}, owner={}, originalTopic={}, consumerId={}, msgUniqKey={}, storeTimestamp={}", new Object[]{newTopic, commercialOwner, requestHeader.getOriginTopic(), requestHeader.getGroup(), uniqKey, putMessageResult.getAppendMessageResult().getStoreTimestamp()});
                    }
                    response.setCode(0);
                    response.setRemark(null);
                    succeeded = true;
                    break;
                }
            }
            if (!succeeded) {
                response.setCode(1);
                response.setRemark(putMessageResult.getPutMessageStatus().name());
            }
        } else {
            if (isDLQ) {
                String owner = (String)request.getExtFields().get("Owner");
                String uniqKey = (String)msgInner.getProperties().get("UNIQ_KEY");
                DLQ_LOG.info("failed to send msg to DLQ {}, owner={}, originalTopic={}, consumerId={}, msgUniqKey={}, result={}", new Object[]{newTopic, owner, requestHeader.getOriginTopic(), requestHeader.getGroup(), uniqKey, "null"});
            }
            response.setCode(1);
            response.setRemark("putMessageResult is null");
        }
        if (this.hasConsumeMessageHook() && !UtilAll.isBlank((String)requestHeader.getOriginMsgId())) {
            String namespace = NamespaceUtil.getNamespaceFromResource((String)requestHeader.getGroup());
            ConsumeMessageContext context = new ConsumeMessageContext();
            context.setNamespace(namespace);
            context.setTopic(requestHeader.getOriginTopic());
            context.setConsumerGroup(requestHeader.getGroup());
            context.setCommercialRcvStats(BrokerStatsManager.StatsType.SEND_BACK);
            context.setCommercialRcvTimes(1);
            context.setCommercialOwner((String)request.getExtFields().get("Owner"));
            context.setAccountAuthType((String)request.getExtFields().get("AUTH_TYPE"));
            context.setAccountOwnerParent((String)request.getExtFields().get("OWNER_PARENT"));
            context.setAccountOwnerSelf((String)request.getExtFields().get("OWNER_SELF"));
            context.setRcvStat(isDLQ ? BrokerStatsManager.StatsType.SEND_BACK_TO_DLQ : BrokerStatsManager.StatsType.SEND_BACK);
            context.setSuccess(succeeded);
            context.setRcvMsgNum(1);
            context.setRcvMsgSize(0);
            context.setCommercialRcvMsgNum(succeeded ? 1 : 0);
            try {
                this.executeConsumeMessageHookAfter(context);
            }
            catch (AbortProcessException e) {
                response.setCode(e.getResponseCode());
                response.setRemark(e.getErrorMessage());
            }
        }
        return response;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void executeConsumeMessageHookAfter(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageAfter(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected SendMessageContext buildMsgContext(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, RemotingCommand request) {
        String namespace = NamespaceUtil.getNamespaceFromResource((String)requestHeader.getTopic());
        SendMessageContext sendMessageContext = new SendMessageContext();
        sendMessageContext.setNamespace(namespace);
        sendMessageContext.setProducerGroup(requestHeader.getProducerGroup());
        sendMessageContext.setTopic(requestHeader.getTopic());
        sendMessageContext.setBodyLength(request.getBody().length);
        sendMessageContext.setMsgProps(requestHeader.getProperties());
        sendMessageContext.setBornHost(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        sendMessageContext.setBrokerAddr(this.brokerController.getBrokerAddr());
        sendMessageContext.setQueueId(requestHeader.getQueueId());
        sendMessageContext.setBrokerRegionId(this.brokerController.getBrokerConfig().getRegionId());
        sendMessageContext.setBornTimeStamp(requestHeader.getBornTimestamp());
        sendMessageContext.setRequestTimeStamp(System.currentTimeMillis());
        String owner = (String)request.getExtFields().get("Owner");
        sendMessageContext.setCommercialOwner(owner);
        Map properties = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        String uniqueKey = (String)properties.get("UNIQ_KEY");
        properties.put("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        properties.put("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)properties));
        if (uniqueKey == null) {
            uniqueKey = "";
        }
        sendMessageContext.setMsgUniqueKey(uniqueKey);
        if (properties.containsKey("__SHARDINGKEY")) {
            sendMessageContext.setMsgType(MessageType.Order_Msg);
        } else {
            sendMessageContext.setMsgType(MessageType.Normal_Msg);
        }
        return sendMessageContext;
    }

    public boolean hasSendMessageHook() {
        return this.sendMessageHookList != null && !this.sendMessageHookList.isEmpty();
    }

    protected MessageExtBrokerInner buildInnerMsg(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, byte[] body, TopicConfig topicConfig) {
        int queueIdInt = requestHeader.getQueueId();
        if (queueIdInt < 0) {
            queueIdInt = this.randomQueueId(topicConfig.getWriteQueueNums());
        }
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)msgInner, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        msgInner.setPropertiesString(requestHeader.getProperties());
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicConfig.getTopicFilterType(), (String)msgInner.getTags()));
        msgInner.setQueueId(queueIdInt);
        msgInner.setSysFlag(sysFlag);
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        return msgInner;
    }

    public SocketAddress getStoreHost() {
        return this.brokerController.getStoreHost();
    }

    protected RemotingCommand msgContentCheck(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, RemotingCommand request, RemotingCommand response) {
        String topic = requestHeader.getTopic();
        if (topic.length() > 127) {
            LOGGER.warn("msgContentCheck: message topic length is too long, topic={}, topic length={}, threshold={}", new Object[]{topic, topic.length(), (byte)127});
            response.setCode(13);
            return response;
        }
        if (requestHeader.getProperties() != null && requestHeader.getProperties().length() > Short.MAX_VALUE) {
            LOGGER.warn("msgContentCheck: message properties length is too long, topic={}, properties length={}, threshold={}", new Object[]{topic, requestHeader.getProperties().length(), (short)Short.MAX_VALUE});
            response.setCode(13);
            return response;
        }
        if (request.getBody().length > 0x4000000) {
            LOGGER.warn("msgContentCheck: message body size exceeds the threshold, topic={}, body size={}, threshold={}bytes", new Object[]{topic, request.getBody().length, 0x4000000});
            response.setRemark("msg body must be less 64KB");
            response.setCode(13);
            return response;
        }
        return response;
    }

    protected RemotingCommand msgCheck(ChannelHandlerContext ctx, SendMessageRequestHeader requestHeader, RemotingCommand request, RemotingCommand response) {
        int idValid;
        int queueIdInt;
        if (!PermName.isWriteable((int)this.brokerController.getBrokerConfig().getBrokerPermission()) && this.brokerController.getTopicConfigManager().isOrderTopic(requestHeader.getTopic())) {
            response.setCode(16);
            response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending message is forbidden");
            return response;
        }
        TopicValidator.ValidateTopicResult result = TopicValidator.validateTopic((String)requestHeader.getTopic());
        if (!result.isValid()) {
            response.setCode(1);
            response.setRemark(result.getRemark());
            return response;
        }
        if (TopicValidator.isNotAllowedSendTopic((String)requestHeader.getTopic())) {
            response.setCode(16);
            response.setRemark("Sending message to topic[" + requestHeader.getTopic() + "] is forbidden.");
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            int topicSysFlag = 0;
            if (requestHeader.isUnitMode()) {
                topicSysFlag = requestHeader.getTopic().startsWith("%RETRY%") ? TopicSysFlag.buildSysFlag((boolean)false, (boolean)true) : TopicSysFlag.buildSysFlag((boolean)true, (boolean)false);
            }
            LOGGER.warn("the topic {} not exist, producer: {}", (Object)requestHeader.getTopic(), (Object)ctx.channel().remoteAddress());
            topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageMethod(requestHeader.getTopic(), requestHeader.getDefaultTopic(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getDefaultTopicQueueNums(), topicSysFlag);
            if (null == topicConfig && requestHeader.getTopic().startsWith("%RETRY%")) {
                topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(requestHeader.getTopic(), 1, 6, topicSysFlag);
            }
            if (null == topicConfig) {
                response.setCode(17);
                response.setRemark("topic[" + requestHeader.getTopic() + "] not exist, apply first please!" + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
                return response;
            }
        }
        if ((queueIdInt = requestHeader.getQueueId().intValue()) >= (idValid = Math.max(topicConfig.getWriteQueueNums(), topicConfig.getReadQueueNums()))) {
            String errorInfo = String.format("request queueId[%d] is illegal, %s Producer: %s", queueIdInt, topicConfig, RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
            LOGGER.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        return response;
    }

    public void registerSendMessageHook(List<SendMessageHook> sendMessageHookList) {
        this.sendMessageHookList = sendMessageHookList;
    }

    protected void doResponse(ChannelHandlerContext ctx, RemotingCommand request, RemotingCommand response) {
        NettyRemotingAbstract.writeResponse((Channel)ctx.channel(), (RemotingCommand)request, (RemotingCommand)response);
    }

    public void executeSendMessageHookBefore(SendMessageContext context) {
        if (this.hasSendMessageHook()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageBefore(context);
                }
                catch (AbortProcessException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    protected SendMessageRequestHeader parseRequestHeader(RemotingCommand request) throws RemotingCommandException {
        return SendMessageRequestHeader.parseRequestHeader((RemotingCommand)request);
    }

    protected int randomQueueId(int writeQueueNums) {
        return ThreadLocalRandom.current().nextInt(99999999) % writeQueueNums;
    }

    public void executeSendMessageHookAfter(RemotingCommand response, SendMessageContext context) {
        if (this.hasSendMessageHook()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    if (response != null) {
                        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
                        context.setMsgId(responseHeader.getMsgId());
                        context.setQueueId(responseHeader.getQueueId());
                        context.setQueueOffset(responseHeader.getQueueOffset());
                        context.setCode(response.getCode());
                        context.setErrorMsg(response.getRemark());
                    }
                    hook.sendMessageAfter(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean rejectRequest() {
        return false;
    }
}

