/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class ConsumerOffsetManager
extends ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    public static final String TOPIC_GROUP_SEPARATOR = "@";
    private DataVersion dataVersion = new DataVersion();
    private ConcurrentMap<String, ConcurrentMap<Integer, Long>> offsetTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, Long>>(512);
    private final ConcurrentMap<String, ConcurrentMap<Integer, Long>> resetOffsetTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, Long>>(512);
    private final ConcurrentMap<String, ConcurrentMap<Integer, Long>> pullOffsetTable = new ConcurrentHashMap<String, ConcurrentMap<Integer, Long>>(512);
    protected transient BrokerController brokerController;
    private final transient AtomicLong versionChangeCounter = new AtomicLong(0L);

    public ConsumerOffsetManager() {
    }

    public ConsumerOffsetManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void cleanOffset(String group) {
        Iterator it = this.offsetTable.entrySet().iterator();
        while (it.hasNext()) {
            String[] arrays;
            Map.Entry next = it.next();
            String topicAtGroup = (String)next.getKey();
            if (!topicAtGroup.contains(group) || (arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR)).length != 2 || !group.equals(arrays[1])) continue;
            it.remove();
            LOG.warn("Clean group's offset, {}, {}", (Object)topicAtGroup, next.getValue());
        }
    }

    public void cleanOffsetByTopic(String topic) {
        Iterator it = this.offsetTable.entrySet().iterator();
        while (it.hasNext()) {
            String[] arrays;
            Map.Entry next = it.next();
            String topicAtGroup = (String)next.getKey();
            if (!topicAtGroup.contains(topic) || (arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR)).length != 2 || !topic.equals(arrays[0])) continue;
            it.remove();
            LOG.warn("Clean topic's offset, {}, {}", (Object)topicAtGroup, next.getValue());
        }
    }

    public void scanUnsubscribedTopic() {
        Iterator it = this.offsetTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String topicAtGroup = (String)next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2) continue;
            String topic = arrays[0];
            String group = arrays[1];
            if (null != this.brokerController.getConsumerManager().findSubscriptionData(group, topic) || !this.offsetBehindMuchThanData(topic, (ConcurrentMap)next.getValue())) continue;
            it.remove();
            LOG.warn("remove topic offset, {}", (Object)topicAtGroup);
        }
    }

    private boolean offsetBehindMuchThanData(String topic, ConcurrentMap<Integer, Long> table) {
        boolean result;
        Iterator it = table.entrySet().iterator();
        boolean bl = result = !table.isEmpty();
        while (it.hasNext() && result) {
            Map.Entry next = it.next();
            long minOffsetInStore = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, ((Integer)next.getKey()).intValue());
            long offsetInPersist = (Long)next.getValue();
            result = offsetInPersist <= minOffsetInStore;
        }
        return result;
    }

    public Set<String> whichTopicByConsumer(String group) {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry next : this.offsetTable.entrySet()) {
            String topicAtGroup = (String)next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2 || !group.equals(arrays[1])) continue;
            topics.add(arrays[0]);
        }
        return topics;
    }

    public Set<String> whichGroupByTopic(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry next : this.offsetTable.entrySet()) {
            String topicAtGroup = (String)next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2 || !topic.equals(arrays[0])) continue;
            groups.add(arrays[1]);
        }
        return groups;
    }

    public Map<String, Set<String>> getGroupTopicMap() {
        HashMap<String, Set<String>> retMap = new HashMap<String, Set<String>>(128);
        for (String key : this.offsetTable.keySet()) {
            String[] arr = key.split(TOPIC_GROUP_SEPARATOR);
            if (arr.length != 2) continue;
            String topic = arr[0];
            String group = arr[1];
            HashSet<String> topics = (HashSet<String>)retMap.get(group);
            if (topics == null) {
                topics = new HashSet<String>(8);
                retMap.put(group, topics);
            }
            topics.add(topic);
        }
        return retMap;
    }

    public void commitOffset(String clientHost, String group, String topic, int queueId, long offset) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        this.commitOffset(clientHost, key, queueId, offset);
    }

    private void commitOffset(String clientHost, String key, int queueId, long offset) {
        ConcurrentHashMap<Integer, Long> map = (ConcurrentHashMap<Integer, Long>)this.offsetTable.get(key);
        if (null == map) {
            map = new ConcurrentHashMap<Integer, Long>(32);
            map.put(queueId, offset);
            this.offsetTable.put(key, map);
        } else {
            Long storeOffset = map.put(queueId, offset);
            if (storeOffset != null && offset < storeOffset) {
                LOG.warn("[NOTIFYME]update consumer offset less than store. clientHost={}, key={}, queueId={}, requestOffset={}, storeOffset={}", new Object[]{clientHost, key, queueId, offset, storeOffset});
            }
        }
        if (this.versionChangeCounter.incrementAndGet() % this.brokerController.getBrokerConfig().getConsumerOffsetUpdateVersionStep() == 0L) {
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            this.dataVersion.nextVersion(stateMachineVersion);
        }
    }

    public void commitPullOffset(String clientHost, String group, String topic, int queueId, long offset) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentMap map = this.pullOffsetTable.computeIfAbsent(key, k -> new ConcurrentHashMap(32));
        map.put(queueId, offset);
    }

    public long queryOffset(String group, String topic, int queueId) {
        Long offset;
        Map reset;
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        if (this.brokerController.getBrokerConfig().isUseServerSideResetOffset() && null != (reset = (Map)this.resetOffsetTable.get(key)) && reset.containsKey(queueId)) {
            return (Long)reset.get(queueId);
        }
        ConcurrentMap map = (ConcurrentMap)this.offsetTable.get(key);
        if (null != map && (offset = (Long)map.get(queueId)) != null) {
            return offset;
        }
        return -1L;
    }

    public long queryPullOffset(String group, String topic, int queueId) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        Long offset = null;
        ConcurrentMap map = (ConcurrentMap)this.pullOffsetTable.get(key);
        if (null != map) {
            offset = (Long)map.get(queueId);
        }
        if (offset == null) {
            offset = this.queryOffset(group, topic, queueId);
        }
        return offset;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getConsumerOffsetPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        ConsumerOffsetManager obj;
        if (jsonString != null && (obj = (ConsumerOffsetManager)((Object)RemotingSerializable.fromJson((String)jsonString, ConsumerOffsetManager.class))) != null) {
            this.setOffsetTable(obj.getOffsetTable());
            this.dataVersion = obj.dataVersion;
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public ConcurrentMap<String, ConcurrentMap<Integer, Long>> getOffsetTable() {
        return this.offsetTable;
    }

    public void setOffsetTable(ConcurrentMap<String, ConcurrentMap<Integer, Long>> offsetTable) {
        this.offsetTable = offsetTable;
    }

    public Map<Integer, Long> queryMinOffsetInAllGroup(String topic, String filterGroups) {
        HashMap<Integer, Long> queueMinOffset = new HashMap<Integer, Long>();
        Set topicGroups = this.offsetTable.keySet();
        if (!UtilAll.isBlank((String)filterGroups)) {
            for (String group : filterGroups.split(",")) {
                Iterator it = topicGroups.iterator();
                while (it.hasNext()) {
                    if (!group.equals(((String)it.next()).split(TOPIC_GROUP_SEPARATOR)[1])) continue;
                    it.remove();
                }
            }
        }
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            String topicGroup = (String)entry.getKey();
            String[] topicGroupArr = topicGroup.split(TOPIC_GROUP_SEPARATOR);
            if (!topic.equals(topicGroupArr[0])) continue;
            for (Map.Entry entry2 : ((ConcurrentMap)entry.getValue()).entrySet()) {
                long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, ((Integer)entry2.getKey()).intValue());
                if ((Long)entry2.getValue() < minOffset) continue;
                Long offset = (Long)queueMinOffset.get(entry2.getKey());
                if (offset == null) {
                    queueMinOffset.put((Integer)entry2.getKey(), Math.min(Long.MAX_VALUE, (Long)entry2.getValue()));
                    continue;
                }
                queueMinOffset.put((Integer)entry2.getKey(), Math.min((Long)entry2.getValue(), offset));
            }
        }
        return queueMinOffset;
    }

    public Map<Integer, Long> queryOffset(String group, String topic) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        return (Map)this.offsetTable.get(key);
    }

    public void cloneOffset(String srcGroup, String destGroup, String topic) {
        ConcurrentMap offsets = (ConcurrentMap)this.offsetTable.get(topic + TOPIC_GROUP_SEPARATOR + srcGroup);
        if (offsets != null) {
            this.offsetTable.put(topic + TOPIC_GROUP_SEPARATOR + destGroup, new ConcurrentHashMap(offsets));
        }
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void removeOffset(String group) {
        Iterator it = this.offsetTable.entrySet().iterator();
        while (it.hasNext()) {
            String[] arrays;
            Map.Entry next = it.next();
            String topicAtGroup = (String)next.getKey();
            if (!topicAtGroup.contains(group) || (arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR)).length != 2 || !group.equals(arrays[1])) continue;
            it.remove();
            LOG.warn("clean group offset {}", (Object)topicAtGroup);
        }
    }

    public void assignResetOffset(String topic, String group, int queueId, long offset) {
        ConcurrentMap previous;
        if (Strings.isNullOrEmpty((String)topic) || Strings.isNullOrEmpty((String)group) || queueId < 0 || offset < 0L) {
            LOG.warn("Illegal arguments when assigning reset offset. Topic={}, group={}, queueId={}, offset={}", new Object[]{topic, group, queueId, offset});
            return;
        }
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentMap<Integer, Long> map = (ConcurrentHashMap<Integer, Long>)this.resetOffsetTable.get(key);
        if (null == map && null != (previous = (ConcurrentMap)this.resetOffsetTable.putIfAbsent(key, map = new ConcurrentHashMap<Integer, Long>()))) {
            map = previous;
        }
        map.put(queueId, offset);
        LOG.debug("Reset offset OK. Topic={}, group={}, queueId={}, resetOffset={}", new Object[]{topic, group, queueId, offset});
        ConcurrentMap currentOffsetMap = (ConcurrentMap)this.offsetTable.get(key);
        if (null != currentOffsetMap) {
            currentOffsetMap.put(queueId, offset);
        }
    }

    public boolean hasOffsetReset(String topic, String group, int queueId) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentMap map = (ConcurrentMap)this.resetOffsetTable.get(key);
        if (null == map) {
            return false;
        }
        return map.containsKey(queueId);
    }

    public Long queryThenEraseResetOffset(String topic, String group, Integer queueId) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentMap map = (ConcurrentMap)this.resetOffsetTable.get(key);
        if (null == map) {
            return null;
        }
        return (Long)map.remove(queueId);
    }
}

