/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.statemachine;

import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class CommittedEntryIterator
implements Iterator<DLedgerEntry> {
    private final Function<Long, Boolean> completeEntryCallback;
    private final DLedgerStore dLedgerStore;
    private final long committedIndex;
    private final long firstApplyingIndex;
    private final AtomicLong applyingIndex;
    private long currentIndex;
    private int completeAckNums = 0;

    public CommittedEntryIterator(DLedgerStore dLedgerStore, long committedIndex, AtomicLong applyingIndex, long lastAppliedIndex, Function<Long, Boolean> completeEntryCallback) {
        this.dLedgerStore = dLedgerStore;
        this.committedIndex = committedIndex;
        this.applyingIndex = applyingIndex;
        this.firstApplyingIndex = lastAppliedIndex + 1L;
        this.currentIndex = lastAppliedIndex;
        this.completeEntryCallback = completeEntryCallback;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex >= this.firstApplyingIndex && this.currentIndex <= this.committedIndex) {
            this.completeApplyingEntry();
        }
        return this.currentIndex < this.committedIndex;
    }

    @Override
    public DLedgerEntry next() {
        ++this.currentIndex;
        if (this.currentIndex <= this.committedIndex) {
            DLedgerEntry dLedgerEntry = this.dLedgerStore.get(this.currentIndex);
            this.applyingIndex.set(this.currentIndex);
            return dLedgerEntry;
        }
        return null;
    }

    private void completeApplyingEntry() {
        if (this.completeEntryCallback.apply(this.currentIndex).booleanValue()) {
            ++this.completeAckNums;
        }
    }

    public long getIndex() {
        return this.currentIndex;
    }

    public int getCompleteAckNums() {
        return this.completeAckNums;
    }
}

