/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.util.LibC;
import sun.nio.ch.DirectBuffer;

public class TransientStorePool {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final int poolSize;
    private final int fileSize;
    private final Deque<ByteBuffer> availableBuffers;
    private final DefaultMessageStore messageStore;
    private volatile boolean isRealCommit = true;

    public TransientStorePool(DefaultMessageStore messageStore) {
        this.messageStore = messageStore;
        this.poolSize = messageStore.getMessageStoreConfig().getTransientStorePoolSize();
        this.fileSize = messageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        this.availableBuffers = new ConcurrentLinkedDeque<ByteBuffer>();
    }

    public void init() {
        for (int i = 0; i < this.poolSize; ++i) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.fileSize);
            long address = ((DirectBuffer)((Object)byteBuffer)).address();
            Pointer pointer = new Pointer(address);
            LibC.INSTANCE.mlock(pointer, new NativeLong((long)this.fileSize));
            this.availableBuffers.offer(byteBuffer);
        }
    }

    public void destroy() {
        for (ByteBuffer byteBuffer : this.availableBuffers) {
            long address = ((DirectBuffer)((Object)byteBuffer)).address();
            Pointer pointer = new Pointer(address);
            LibC.INSTANCE.munlock(pointer, new NativeLong((long)this.fileSize));
        }
    }

    public void returnBuffer(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        byteBuffer.limit(this.fileSize);
        this.availableBuffers.offerFirst(byteBuffer);
    }

    public ByteBuffer borrowBuffer() {
        ByteBuffer buffer = this.availableBuffers.pollFirst();
        if ((double)this.availableBuffers.size() < (double)this.poolSize * 0.4) {
            log.warn("TransientStorePool only remain {} sheets.", (Object)this.availableBuffers.size());
        }
        return buffer;
    }

    public int availableBufferNums() {
        if (this.messageStore.isTransientStorePoolEnable()) {
            return this.availableBuffers.size();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isRealCommit() {
        return this.isRealCommit;
    }

    public void setRealCommit(boolean realCommit) {
        this.isRealCommit = realCommit;
    }
}

