/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.VersionedProtocol;

public class ProtocolProxy<T> {
    private Class<T> protocol;
    private T proxy;
    private HashSet<Integer> serverMethods = null;
    private final boolean supportServerMethodCheck;
    private boolean serverMethodsFetched = false;

    public ProtocolProxy(Class<T> protocol, T proxy, boolean supportServerMethodCheck) {
        this.protocol = protocol;
        this.proxy = proxy;
        this.supportServerMethodCheck = supportServerMethodCheck;
    }

    private void fetchServerMethods(Method method) throws IOException {
        long clientVersion = RPC.getProtocolVersion(method.getDeclaringClass());
        int clientMethodsHash = ProtocolSignature.getFingerprint(method.getDeclaringClass().getMethods());
        ProtocolSignature serverInfo = ((VersionedProtocol)this.proxy).getProtocolSignature(RPC.getProtocolName(this.protocol), clientVersion, clientMethodsHash);
        long serverVersion = serverInfo.getVersion();
        if (serverVersion != clientVersion) {
            throw new RPC.VersionMismatch(this.protocol.getName(), clientVersion, serverVersion);
        }
        int[] serverMethodsCodes = serverInfo.getMethods();
        if (serverMethodsCodes != null) {
            this.serverMethods = new HashSet(serverMethodsCodes.length);
            for (int m : serverMethodsCodes) {
                this.serverMethods.add(m);
            }
        }
        this.serverMethodsFetched = true;
    }

    public T getProxy() {
        return this.proxy;
    }

    public synchronized boolean isMethodSupported(String methodName, Class<?> ... parameterTypes) throws IOException {
        Method method;
        if (!this.supportServerMethodCheck) {
            return true;
        }
        try {
            method = this.protocol.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        if (!this.serverMethodsFetched) {
            this.fetchServerMethods(method);
        }
        if (this.serverMethods == null) {
            return true;
        }
        return this.serverMethods.contains(ProtocolSignature.getFingerprint(method));
    }
}

