/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.ModifiableSolrParams;

public class FetchStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    private TupleStream stream;
    private StreamContext streamContext;
    private Iterator<Tuple> tuples;
    private String leftKey;
    private String rightKey;
    private String fieldList;
    private String[] fields;
    private String collection;
    private int batchSize;
    private boolean appendVersion = true;
    private boolean appendKey = true;

    public FetchStream(String zkHost, String collection, TupleStream tupleStream, String on, String fieldList, int batchSize) throws IOException {
        this.init(zkHost, collection, tupleStream, on, fieldList, batchSize);
    }

    public FetchStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter onParam = factory.getNamedOperand(expression, "on");
        StreamExpressionNamedParameter flParam = factory.getNamedOperand(expression, "fl");
        StreamExpressionNamedParameter batchSizeParam = factory.getNamedOperand(expression, "batchSize");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        String on = null;
        String fl = null;
        int batchSize = 50;
        if (onParam == null) {
            throw new IOException("on parameter cannot be null for the fetch expression");
        }
        on = ((StreamExpressionValue)onParam.getParameter()).getValue();
        if (flParam == null) {
            throw new IOException("fl parameter cannot be null for the fetch expression");
        }
        fl = ((StreamExpressionValue)flParam.getParameter()).getValue();
        if (batchSizeParam != null) {
            batchSize = Integer.parseInt(((StreamExpressionValue)batchSizeParam.getParameter()).getValue());
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, stream, on, fl, batchSize);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, String on, String fieldList, int batchSize) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.stream = tupleStream;
        this.batchSize = batchSize;
        this.fields = fieldList.split(",");
        this.fieldList = fieldList;
        if (on.indexOf("=") > -1) {
            String[] leftright = on.split("=");
            this.leftKey = leftright[0].trim();
            this.rightKey = leftright[1].trim();
        } else {
            this.leftKey = this.rightKey = on;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = this.fields[i].trim();
            if (this.fields[i].equals("_version_")) {
                this.appendVersion = false;
            }
            if (!this.fields[i].equals(this.rightKey)) continue;
            this.appendKey = false;
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("on", this.leftKey + "=" + this.rightKey));
        expression.addParameter(new StreamExpressionNamedParameter("fl", this.fieldList));
        expression.addParameter(new StreamExpressionNamedParameter("batchSize", Integer.toString(this.batchSize)));
        if (includeStreams) {
            if (this.stream instanceof Expressible) {
                expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
            } else {
                throw new IOException("The FetchStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        this.stream.setStreamContext(streamContext);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new ArrayList().iterator();
        this.stream.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBatch() throws IOException {
        Tuple EOFTuple = null;
        ArrayList<Tuple> batch = new ArrayList<Tuple>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            Tuple tuple = this.stream.read();
            if (tuple.EOF) {
                EOFTuple = tuple;
                break;
            }
            batch.add(tuple);
        }
        if (batch.size() > 0) {
            StringBuilder buf = new StringBuilder(batch.size() * 10 + 20);
            buf.append("{! df=").append(this.rightKey).append(" q.op=OR cache=false }");
            for (Tuple tuple : batch) {
                String key = tuple.getString(this.leftKey);
                buf.append(' ').append(ClientUtils.escapeQueryChars(key));
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", buf.toString());
            params.add("fl", this.fieldList + this.appendFields());
            params.add("rows", Integer.toString(this.batchSize));
            params.add("sort", "_version_ desc");
            CloudSolrStream cloudSolrStream = new CloudSolrStream(this.zkHost, this.collection, params);
            StreamContext newContext = new StreamContext();
            newContext.setSolrClientCache(this.streamContext.getSolrClientCache());
            newContext.setObjectCache(this.streamContext.getObjectCache());
            cloudSolrStream.setStreamContext(newContext);
            HashMap<String, Tuple> fetched = new HashMap<String, Tuple>();
            try {
                cloudSolrStream.open();
                while (true) {
                    Tuple t = cloudSolrStream.read();
                    if (t.EOF) {
                        break;
                    }
                    String rightValue = t.getString(this.rightKey);
                    fetched.put(rightValue, t);
                }
            }
            finally {
                cloudSolrStream.close();
            }
            for (Tuple batchTuple : batch) {
                Tuple fetchedTuple = (Tuple)fetched.get(batchTuple.getString(this.leftKey));
                if (fetchedTuple == null) continue;
                for (String field : this.fields) {
                    Object value = fetchedTuple.get(field);
                    if (value == null) continue;
                    batchTuple.put(field, value);
                }
            }
        }
        if (EOFTuple != null) {
            batch.add(EOFTuple);
        }
        this.tuples = batch.iterator();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        if (!this.tuples.hasNext()) {
            this.fetchBatch();
        }
        return this.tuples.next();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }

    private String appendFields() {
        StringBuffer buf = new StringBuffer();
        if (this.appendKey) {
            buf.append(",");
            buf.append(this.rightKey);
        }
        if (this.appendVersion) {
            buf.append(",_version_");
        }
        return buf.toString();
    }
}

