/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ListCacheEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ListCacheEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() > 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at most 1 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        ConcurrentMap objectCache = this.streamContext.getObjectCache();
        ArrayList list = new ArrayList();
        if (values.length == 0) {
            ConcurrentHashMap m = (ConcurrentHashMap)objectCache;
            Enumeration en = m.keys();
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            return list;
        }
        if (values.length == 1) {
            String space = (String)values[0];
            ConcurrentMap spaceCache = (ConcurrentMap)objectCache.get(space = space.replace("\"", ""));
            if (spaceCache != null) {
                ConcurrentHashMap spaceMap = (ConcurrentHashMap)objectCache.get(space);
                Enumeration en = spaceMap.keys();
                while (en.hasMoreElements()) {
                    list.add(en.nextElement());
                }
                return list;
            }
            return list;
        }
        throw new IOException("The listCache function requires two parameters: workspace and key");
    }
}

