/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import java.net.URL;
import org.apache.ranger.policyengine.PerfTestConfiguration;

public class PerfTestOptions {
    private final URL servicePoliciesFileURL;
    private final URL[] requestFileURLs;
    private final URL statCollectionFileURL;
    private final boolean isTrieLookupPrefixDisabled;
    private final boolean isOnDemandTriePostSetupDisabled;
    private final int concurrentClientCount;
    private final int iterationsCount;
    private final URL perfConfigurationFileURL;
    private final boolean isPolicyTrieOptimizedForSpace;
    private final boolean isTagTrieOptimizedForSpace;

    PerfTestOptions(URL servicePoliciesFileURL, URL[] requestFileURLs, URL statCollectionFileURL, int concurrentClientCount, int iterationsCount, boolean isTrieLookupPrefixDisabled, boolean isOnDemandTriePostSetupDisabled, URL perfConfigurationFileURL) {
        this.servicePoliciesFileURL = servicePoliciesFileURL;
        this.requestFileURLs = requestFileURLs;
        this.statCollectionFileURL = statCollectionFileURL;
        this.iterationsCount = iterationsCount;
        this.concurrentClientCount = concurrentClientCount;
        this.isTrieLookupPrefixDisabled = isTrieLookupPrefixDisabled;
        this.isOnDemandTriePostSetupDisabled = isOnDemandTriePostSetupDisabled;
        this.perfConfigurationFileURL = perfConfigurationFileURL;
        PerfTestConfiguration configuration = new PerfTestConfiguration(perfConfigurationFileURL);
        this.isPolicyTrieOptimizedForSpace = configuration.getBoolean("ranger.policyengine.option.optimize.policy.trie.for.space", false);
        this.isTagTrieOptimizedForSpace = configuration.getBoolean("ranger.policyengine.option.optimize.tag.trie.for.space", false);
    }

    public URL getServicePoliciesFileURL() {
        return this.servicePoliciesFileURL;
    }

    public URL[] getRequestFileURLs() {
        return this.requestFileURLs;
    }

    public URL getStatCollectionFileURL() {
        return this.statCollectionFileURL;
    }

    public int getConcurrentClientCount() {
        return this.concurrentClientCount;
    }

    public int getIterationsCount() {
        return this.iterationsCount;
    }

    public boolean getIsTrieLookupPrefixDisabled() {
        return this.isTrieLookupPrefixDisabled;
    }

    public boolean getIsOnDemandTriePostSetupDisabled() {
        return this.isOnDemandTriePostSetupDisabled;
    }

    public URL getPerfConfigurationFileURL() {
        return this.perfConfigurationFileURL;
    }

    public boolean getIsPolicyTrieOptimizedForSpace() {
        return this.isPolicyTrieOptimizedForSpace;
    }

    public boolean getIsTagTrieOptimizedForSpace() {
        return this.isTagTrieOptimizedForSpace;
    }
}

