/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.DatabaseEditions;
import com.microsoft.azure.management.sql.DatabaseMetric;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.RestorePoint;
import com.microsoft.azure.management.sql.SampleName;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import com.microsoft.azure.management.sql.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.SqlDatabaseAutomaticTuning;
import com.microsoft.azure.management.sql.SqlDatabaseBasicStorage;
import com.microsoft.azure.management.sql.SqlDatabaseExportRequest;
import com.microsoft.azure.management.sql.SqlDatabaseImportRequest;
import com.microsoft.azure.management.sql.SqlDatabaseMetric;
import com.microsoft.azure.management.sql.SqlDatabaseMetricDefinition;
import com.microsoft.azure.management.sql.SqlDatabasePremiumServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabasePremiumStorage;
import com.microsoft.azure.management.sql.SqlDatabaseStandardServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabaseStandardStorage;
import com.microsoft.azure.management.sql.SqlDatabaseThreatDetectionPolicy;
import com.microsoft.azure.management.sql.SqlDatabaseUsageMetric;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlRestorableDroppedDatabase;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlSyncGroupOperations;
import com.microsoft.azure.management.sql.SqlWarehouse;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.UpgradeHintInterface;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_7_0)
public interface SqlDatabase
extends ExternalChildResource<SqlDatabase, SqlServer>,
HasInner<DatabaseInner>,
HasResourceGroup,
Refreshable<SqlDatabase>,
Updatable<Update> {
    public String sqlServerName();

    public String collation();

    public DateTime creationDate();

    public UUID currentServiceObjectiveId();

    public String databaseId();

    public DateTime earliestRestoreDate();

    public DatabaseEditions edition();

    public UUID requestedServiceObjectiveId();

    public long maxSizeBytes();

    public ServiceObjectiveName requestedServiceObjectiveName();

    public ServiceObjectiveName serviceLevelObjective();

    public String status();

    public String elasticPoolName();

    public String defaultSecondaryLocation();

    public String parentId();

    public String regionName();

    public Region region();

    @Deprecated
    public UpgradeHintInterface getUpgradeHint();

    public boolean isDataWarehouse();

    @Method
    public SqlWarehouse asWarehouse();

    @Method
    public List<RestorePoint> listRestorePoints();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<RestorePoint> listRestorePointsAsync();

    @Deprecated
    @Method
    public List<DatabaseMetric> listUsages();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public List<SqlDatabaseMetric> listMetrics(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<SqlDatabaseMetric> listMetricsAsync(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public List<SqlDatabaseMetricDefinition> listMetricDefinitions();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<SqlDatabaseMetricDefinition> listMetricDefinitionsAsync();

    @Method
    public TransparentDataEncryption getTransparentDataEncryption();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<TransparentDataEncryption> getTransparentDataEncryptionAsync();

    @Method
    public Map<String, ServiceTierAdvisor> listServiceTierAdvisors();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<ServiceTierAdvisor> listServiceTierAdvisorsAsync();

    @Method
    public Map<String, ReplicationLink> listReplicationLinks();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Observable<ReplicationLink> listReplicationLinksAsync();

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseExportRequest.DefinitionStages.WithStorageTypeAndKey exportTo(String var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseExportRequest.DefinitionStages.WithAuthenticationTypeAndLoginPassword exportTo(StorageAccount var1, String var2, String var3);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseExportRequest.DefinitionStages.WithAuthenticationTypeAndLoginPassword exportTo(Creatable<StorageAccount> var1, String var2, String var3);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseImportRequest.DefinitionStages.WithStorageTypeAndKey importBacpac(String var1);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseImportRequest.DefinitionStages.WithAuthenticationTypeAndLoginPassword importBacpac(StorageAccount var1, String var2, String var3);

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseThreatDetectionPolicy.DefinitionStages.Blank defineThreatDetectionPolicy(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public SqlDatabaseThreatDetectionPolicy getThreatDetectionPolicy();

    @Method
    @Beta(value=Beta.SinceVersion.V1_8_0)
    public SqlDatabaseAutomaticTuning getDatabaseAutomaticTuning();

    @Method
    @Beta(value=Beta.SinceVersion.V1_8_0)
    public List<SqlDatabaseUsageMetric> listUsageMetrics();

    @Method
    @Beta(value=Beta.SinceVersion.V1_8_0)
    public Observable<SqlDatabaseUsageMetric> listUsageMetricsAsync();

    @Method
    @Beta(value=Beta.SinceVersion.V1_8_0)
    public SqlDatabase rename(String var1);

    @Method
    @Beta(value=Beta.SinceVersion.V1_8_0)
    public Observable<SqlDatabase> renameAsync(String var1);

    @Method
    public void delete();

    @Method
    @Beta(value=Beta.SinceVersion.V1_7_0)
    public Completable deleteAsync();

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public SqlSyncGroupOperations.SqlSyncGroupActionsDefinition syncGroups();

    public static interface UpdateStages {

        public static interface WithElasticPoolName {
            public WithEdition withoutElasticPool();

            public Update withExistingElasticPool(String var1);

            public Update withExistingElasticPool(SqlElasticPool var1);

            public Update withNewElasticPool(Creatable<SqlElasticPool> var1);
        }

        public static interface WithServiceObjective {
            @Deprecated
            public Update withServiceObjective(ServiceObjectiveName var1);
        }

        public static interface WithMaxSizeBytes {
            @Deprecated
            public Update withMaxSizeBytes(long var1);
        }

        public static interface WithEdition {
            @Deprecated
            public Update withEdition(DatabaseEditions var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withBasicEdition();

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withBasicEdition(SqlDatabaseBasicStorage var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withStandardEdition(SqlDatabaseStandardServiceObjective var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withStandardEdition(SqlDatabaseStandardServiceObjective var1, SqlDatabaseStandardStorage var2);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withPremiumEdition(SqlDatabasePremiumServiceObjective var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public Update withPremiumEdition(SqlDatabasePremiumServiceObjective var1, SqlDatabasePremiumStorage var2);
        }
    }

    public static interface Update
    extends UpdateStages.WithEdition,
    UpdateStages.WithElasticPoolName,
    UpdateStages.WithMaxSizeBytes,
    UpdateStages.WithServiceObjective,
    Resource.UpdateWithTags<Update>,
    Appliable<SqlDatabase> {
    }

    public static interface DefinitionStages {

        public static interface WithAttachFinal<ParentT>
        extends Attachable.InDefinition<ParentT> {
        }

        public static interface WithAttachAllOptions<ParentT>
        extends WithServiceObjective<ParentT>,
        WithEdition<ParentT>,
        WithEditionDefaults<ParentT>,
        WithCollation<ParentT>,
        WithMaxSizeBytes<ParentT>,
        WithAttachFinal<ParentT> {
        }

        public static interface WithServiceObjective<ParentT> {
            @Deprecated
            public WithAttachAllOptions<ParentT> withServiceObjective(ServiceObjectiveName var1);
        }

        public static interface WithMaxSizeBytes<ParentT> {
            @Deprecated
            public WithAttachAllOptions<ParentT> withMaxSizeBytes(long var1);
        }

        public static interface WithCollation<ParentT> {
            public WithAttachAllOptions<ParentT> withCollation(String var1);
        }

        public static interface WithEditionDefaults<ParentT>
        extends WithAttachFinal<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withBasicEdition();

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withBasicEdition(SqlDatabaseBasicStorage var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withStandardEdition(SqlDatabaseStandardServiceObjective var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withStandardEdition(SqlDatabaseStandardServiceObjective var1, SqlDatabaseStandardStorage var2);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withPremiumEdition(SqlDatabasePremiumServiceObjective var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithEditionDefaults<ParentT> withPremiumEdition(SqlDatabasePremiumServiceObjective var1, SqlDatabasePremiumStorage var2);

            public static interface WithCollation<ParentT> {
                public WithEditionDefaults<ParentT> withCollation(String var1);
            }
        }

        public static interface WithEdition<ParentT> {
            @Deprecated
            public WithAttachAllOptions<ParentT> withEdition(DatabaseEditions var1);
        }

        public static interface WithMaxSizeBytesAfterElasticPoolOptions<ParentT> {
            public WithAttachAfterElasticPoolOptions<ParentT> withMaxSizeBytes(long var1);
        }

        public static interface WithCollationAfterElasticPoolOptions<ParentT> {
            public WithAttachAfterElasticPoolOptions<ParentT> withCollation(String var1);
        }

        public static interface WithAttachAfterElasticPoolOptions<ParentT>
        extends WithCollationAfterElasticPoolOptions<ParentT>,
        WithMaxSizeBytesAfterElasticPoolOptions<ParentT>,
        WithAttachFinal<ParentT> {
        }

        public static interface WithCreateMode<ParentT> {
            public WithAttachFinal<ParentT> withMode(CreateMode var1);
        }

        public static interface WithSourceDatabaseId<ParentT> {
            public WithCreateMode<ParentT> withSourceDatabase(String var1);

            public WithCreateMode<ParentT> withSourceDatabase(SqlDatabase var1);
        }

        public static interface WithSampleDatabase<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAllOptions<ParentT> fromSample(SampleName var1);
        }

        public static interface WithSampleDatabaseAfterElasticPool<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAfterElasticPoolOptions<ParentT> fromSample(SampleName var1);
        }

        public static interface WithRestorePointDatabase<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAllOptions<ParentT> fromRestorePoint(RestorePoint var1);

            @Beta(value=Beta.SinceVersion.V1_8_0)
            public WithAttachAllOptions<ParentT> fromRestorePoint(RestorePoint var1, DateTime var2);
        }

        public static interface WithRestorePointDatabaseAfterElasticPool<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAfterElasticPoolOptions<ParentT> fromRestorePoint(RestorePoint var1);

            @Beta(value=Beta.SinceVersion.V1_8_0)
            public WithAttachAfterElasticPoolOptions<ParentT> fromRestorePoint(RestorePoint var1, DateTime var2);
        }

        public static interface WithRestorableDroppedDatabase<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachFinal<ParentT> fromRestorableDroppedDatabase(SqlRestorableDroppedDatabase var1);
        }

        public static interface WithAuthenticationAfterElasticPool<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachFinal<ParentT> withSqlAdministratorLoginAndPassword(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachFinal<ParentT> withActiveDirectoryLoginAndPassword(String var1, String var2);
        }

        public static interface WithStorageKeyAfterElasticPool<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthenticationAfterElasticPool<ParentT> withStorageAccessKey(String var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthenticationAfterElasticPool<ParentT> withSharedAccessKey(String var1);
        }

        public static interface WithImportFromAfterElasticPool<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStorageKeyAfterElasticPool<ParentT> importFrom(String var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthenticationAfterElasticPool<ParentT> importFrom(StorageAccount var1, String var2, String var3);
        }

        public static interface WithAuthentication<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAllOptions<ParentT> withSqlAdministratorLoginAndPassword(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAttachAllOptions<ParentT> withActiveDirectoryLoginAndPassword(String var1, String var2);
        }

        public static interface WithStorageKey<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthentication<ParentT> withStorageAccessKey(String var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthentication<ParentT> withSharedAccessKey(String var1);
        }

        public static interface WithImportFrom<ParentT> {
            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithStorageKey<ParentT> importFrom(String var1);

            @Beta(value=Beta.SinceVersion.V1_7_0)
            public WithAuthentication<ParentT> importFrom(StorageAccount var1, String var2, String var3);
        }

        public static interface WithExistingDatabaseAfterElasticPool<ParentT>
        extends WithImportFromAfterElasticPool<ParentT>,
        WithRestorePointDatabaseAfterElasticPool<ParentT>,
        WithSampleDatabaseAfterElasticPool<ParentT>,
        WithSourceDatabaseId<ParentT>,
        WithAttachAfterElasticPoolOptions<ParentT> {
        }

        public static interface WithElasticPoolName<ParentT> {
            public WithExistingDatabaseAfterElasticPool<ParentT> withExistingElasticPool(String var1);

            public WithExistingDatabaseAfterElasticPool<ParentT> withExistingElasticPool(SqlElasticPool var1);

            public WithExistingDatabaseAfterElasticPool<ParentT> withNewElasticPool(Creatable<SqlElasticPool> var1);
        }

        @Beta(value=Beta.SinceVersion.V1_7_0)
        public static interface WithAllDifferentOptions<ParentT>
        extends WithElasticPoolName<ParentT>,
        WithRestorableDroppedDatabase<ParentT>,
        WithImportFrom<ParentT>,
        WithRestorePointDatabase<ParentT>,
        WithSampleDatabase<ParentT>,
        WithSourceDatabaseId<ParentT>,
        WithEditionDefaults<ParentT>,
        WithAttachAllOptions<ParentT> {
        }

        public static interface Blank<ParentT>
        extends WithAllDifferentOptions<ParentT> {
        }
    }

    public static interface SqlDatabaseDefinition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithAllDifferentOptions<ParentT>,
    DefinitionStages.WithElasticPoolName<ParentT>,
    DefinitionStages.WithRestorableDroppedDatabase<ParentT>,
    DefinitionStages.WithImportFrom<ParentT>,
    DefinitionStages.WithStorageKey<ParentT>,
    DefinitionStages.WithAuthentication<ParentT>,
    DefinitionStages.WithRestorePointDatabase<ParentT>,
    DefinitionStages.WithSourceDatabaseId<ParentT>,
    DefinitionStages.WithCreateMode<ParentT>,
    DefinitionStages.WithAttachAllOptions<ParentT>,
    DefinitionStages.WithAttachFinal<ParentT> {
    }
}

