/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGateways;
import com.microsoft.azure.management.network.ApplicationSecurityGroups;
import com.microsoft.azure.management.network.DdosProtectionPlans;
import com.microsoft.azure.management.network.ExpressRouteCircuits;
import com.microsoft.azure.management.network.ExpressRouteCrossConnections;
import com.microsoft.azure.management.network.LoadBalancers;
import com.microsoft.azure.management.network.LocalNetworkGateways;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterfaces;
import com.microsoft.azure.management.network.NetworkSecurityGroups;
import com.microsoft.azure.management.network.NetworkUsages;
import com.microsoft.azure.management.network.NetworkWatchers;
import com.microsoft.azure.management.network.Networks;
import com.microsoft.azure.management.network.PublicIPAddresses;
import com.microsoft.azure.management.network.RouteFilters;
import com.microsoft.azure.management.network.RouteTables;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.VirtualNetworkGateways;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysImpl;
import com.microsoft.azure.management.network.implementation.ApplicationSecurityGroupsImpl;
import com.microsoft.azure.management.network.implementation.DdosProtectionPlansImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitsImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionsImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancersImpl;
import com.microsoft.azure.management.network.implementation.LocalNetworkGatewaysImpl;
import com.microsoft.azure.management.network.implementation.NetworkInterfacesImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupsImpl;
import com.microsoft.azure.management.network.implementation.NetworkUsagesImpl;
import com.microsoft.azure.management.network.implementation.NetworkWatchersImpl;
import com.microsoft.azure.management.network.implementation.NetworksImpl;
import com.microsoft.azure.management.network.implementation.PublicIPAddressesImpl;
import com.microsoft.azure.management.network.implementation.RouteFiltersImpl;
import com.microsoft.azure.management.network.implementation.RouteTablesImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewaysImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import okhttp3.Interceptor;

public final class NetworkManager
extends Manager<NetworkManager, NetworkManagementClientImpl> {
    private PublicIPAddresses publicIPAddresses;
    private Networks networks;
    private NetworkSecurityGroups networkSecurityGroups;
    private NetworkInterfaces networkInterfaces;
    private LoadBalancers loadBalancers;
    private RouteTables routeTables;
    private ApplicationGateways applicationGateways;
    private NetworkUsages networkUsages;
    private NetworkWatchers networkWatchers;
    private VirtualNetworkGateways virtualNetworkGateways;
    private LocalNetworkGateways localNetworkGateways;
    private ExpressRouteCircuits expressRouteCircuits;
    private ApplicationSecurityGroups applicationSecurityGroups;
    private RouteFilters routeFilters;
    private DdosProtectionPlans ddosProtectionPlans;
    private ExpressRouteCrossConnections expressRouteCrossConnections;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static NetworkManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new NetworkManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static NetworkManager authenticate(RestClient restClient, String subscriptionId) {
        return new NetworkManager(restClient, subscriptionId);
    }

    private NetworkManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new NetworkManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public RouteTables routeTables() {
        if (this.routeTables == null) {
            this.routeTables = new RouteTablesImpl(this);
        }
        return this.routeTables;
    }

    public Networks networks() {
        if (this.networks == null) {
            this.networks = new NetworksImpl(this);
        }
        return this.networks;
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        if (this.networkSecurityGroups == null) {
            this.networkSecurityGroups = new NetworkSecurityGroupsImpl(this);
        }
        return this.networkSecurityGroups;
    }

    public PublicIPAddresses publicIPAddresses() {
        if (this.publicIPAddresses == null) {
            this.publicIPAddresses = new PublicIPAddressesImpl(this);
        }
        return this.publicIPAddresses;
    }

    public NetworkInterfaces networkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new NetworkInterfacesImpl(this);
        }
        return this.networkInterfaces;
    }

    public ApplicationGateways applicationGateways() {
        if (this.applicationGateways == null) {
            this.applicationGateways = new ApplicationGatewaysImpl(this);
        }
        return this.applicationGateways;
    }

    public LoadBalancers loadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new LoadBalancersImpl(this);
        }
        return this.loadBalancers;
    }

    public NetworkUsages usages() {
        if (this.networkUsages == null) {
            this.networkUsages = new NetworkUsagesImpl((NetworkManagementClientImpl)((Object)this.innerManagementClient));
        }
        return this.networkUsages;
    }

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public NetworkWatchers networkWatchers() {
        if (this.networkWatchers == null) {
            this.networkWatchers = new NetworkWatchersImpl(this);
        }
        return this.networkWatchers;
    }

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public VirtualNetworkGateways virtualNetworkGateways() {
        if (this.virtualNetworkGateways == null) {
            this.virtualNetworkGateways = new VirtualNetworkGatewaysImpl(this);
        }
        return this.virtualNetworkGateways;
    }

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public LocalNetworkGateways localNetworkGateways() {
        if (this.localNetworkGateways == null) {
            this.localNetworkGateways = new LocalNetworkGatewaysImpl(this);
        }
        return this.localNetworkGateways;
    }

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public ExpressRouteCircuits expressRouteCircuits() {
        if (this.expressRouteCircuits == null) {
            this.expressRouteCircuits = new ExpressRouteCircuitsImpl(this);
        }
        return this.expressRouteCircuits;
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public ApplicationSecurityGroups applicationSecurityGroups() {
        if (this.applicationSecurityGroups == null) {
            this.applicationSecurityGroups = new ApplicationSecurityGroupsImpl(this);
        }
        return this.applicationSecurityGroups;
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public RouteFilters routeFilters() {
        if (this.routeFilters == null) {
            this.routeFilters = new RouteFiltersImpl(this);
        }
        return this.routeFilters;
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public DdosProtectionPlans ddosProtectionPlans() {
        if (this.ddosProtectionPlans == null) {
            this.ddosProtectionPlans = new DdosProtectionPlansImpl(this);
        }
        return this.ddosProtectionPlans;
    }

    @Beta(value=Beta.SinceVersion.V1_11_0)
    public ExpressRouteCrossConnections expressRouteCrossConnections() {
        if (this.expressRouteCrossConnections == null) {
            this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsImpl(this);
        }
        return this.expressRouteCrossConnections;
    }

    Subnet getAssociatedSubnet(SubResource subnetRef) {
        if (subnetRef == null) {
            return null;
        }
        String vnetId = ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        String subnetName = ResourceUtils.nameFromResourceId((String)subnetRef.id());
        if (vnetId == null || subnetName == null) {
            return null;
        }
        Network network = (Network)this.networks().getById(vnetId);
        if (network == null) {
            return null;
        }
        return network.subnets().get(subnetName);
    }

    List<Subnet> listAssociatedSubnets(List<SubnetInner> subnetRefs) {
        HashMap<String, Network> networks = new HashMap<String, Network>();
        ArrayList<Subnet> subnets = new ArrayList<Subnet>();
        if (subnetRefs != null) {
            for (SubnetInner subnetRef : subnetRefs) {
                String networkId = ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
                Network network = (Network)networks.get(networkId.toLowerCase());
                if (network == null) {
                    network = (Network)this.networks().getById(networkId);
                    networks.put(networkId.toLowerCase(), network);
                }
                String subnetName = ResourceUtils.nameFromResourceId((String)subnetRef.id());
                subnets.add(network.subnets().get(subnetName));
            }
        }
        return Collections.unmodifiableList(subnets);
    }

    Collection<ApplicationGatewayBackend> listAssociatedApplicationGatewayBackends(List<ApplicationGatewayBackendAddressPoolInner> backendRefs) {
        HashMap<String, ApplicationGateway> appGateways = new HashMap<String, ApplicationGateway>();
        ArrayList<ApplicationGatewayBackend> backends = new ArrayList<ApplicationGatewayBackend>();
        if (backendRefs != null) {
            for (ApplicationGatewayBackendAddressPoolInner backendRef : backendRefs) {
                String appGatewayId = ResourceUtils.parentResourceIdFromResourceId((String)backendRef.id());
                ApplicationGateway appGateway = (ApplicationGateway)appGateways.get(appGatewayId.toLowerCase());
                if (appGateway == null) {
                    appGateway = (ApplicationGateway)this.applicationGateways().getById(appGatewayId);
                    appGateways.put(appGatewayId.toLowerCase(), appGateway);
                }
                String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
                backends.add(appGateway.backends().get(backendName));
            }
        }
        return Collections.unmodifiableCollection(backends);
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public NetworkManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return NetworkManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public NetworkManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

