/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.msi.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.msi.implementation.OperationsInner;
import com.microsoft.azure.management.msi.implementation.UserAssignedIdentitiesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ManagedServiceIdentityClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private UserAssignedIdentitiesInner userAssignedIdentities;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ManagedServiceIdentityClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ManagedServiceIdentityClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ManagedServiceIdentityClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ManagedServiceIdentityClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public UserAssignedIdentitiesInner userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ManagedServiceIdentityClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ManagedServiceIdentityClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ManagedServiceIdentityClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-11-30";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.userAssignedIdentities = new UserAssignedIdentitiesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "ManagedServiceIdentityClient", "2018-11-30");
    }
}

