/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import org.apache.hadoop.util.VersionInfo;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsPre2_3;

public class HadoopShimsFactory {
    private static final String CURRENT_SHIM_NAME = "org.apache.orc.impl.HadoopShimsCurrent";
    private static final String PRE_2_6_SHIM_NAME = "org.apache.orc.impl.HadoopShimsPre2_6";
    private static final String PRE_2_7_SHIM_NAME = "org.apache.orc.impl.HadoopShimsPre2_7";
    private static HadoopShims SHIMS = null;

    private static HadoopShims createShimByName(String name) {
        try {
            Class<?> cls = Class.forName(name);
            return (HadoopShims)cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Can't create shims for " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Can't create shims for " + name, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can't create shims for " + name, e);
        }
    }

    public static synchronized HadoopShims get() {
        if (SHIMS == null) {
            String[] versionParts = VersionInfo.getVersion().split("[.]");
            int major = Integer.parseInt(versionParts[0]);
            int minor = Integer.parseInt(versionParts[1]);
            SHIMS = major < 2 || major == 2 && minor < 3 ? new HadoopShimsPre2_3() : (major == 2 && minor < 6 ? HadoopShimsFactory.createShimByName(PRE_2_6_SHIM_NAME) : (major == 2 && minor < 7 ? HadoopShimsFactory.createShimByName(PRE_2_7_SHIM_NAME) : HadoopShimsFactory.createShimByName(CURRENT_SHIM_NAME)));
        }
        return SHIMS;
    }
}

