/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.presto.authorizer;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaRoutineName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.ranger.authorization.presto.authorizer.RangerConfig;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static final String RANGER_PLUGIN_TYPE = "presto";
    private static final String RANGER_PRESTO_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.presto.authorizer.RangerSystemAccessControl";
    private final RangerPluginClassLoader rangerPluginClassLoader;
    private final SystemAccessControl systemAccessControlImpl;

    @Inject
    public RangerSystemAccessControl(RangerConfig config) {
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_PRESTO_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (config.getKeytab() != null && config.getPrincipal() != null) {
                configMap.put("ranger.keytab", config.getKeytab());
                configMap.put("ranger.principal", config.getPrincipal());
            }
            configMap.put("ranger.use_ugi", Boolean.toString(config.isUseUgi()));
            if (config.getHadoopConfigPath() != null) {
                configMap.put("ranger.hadoop_config", config.getHadoopConfigPath());
            }
            this.systemAccessControlImpl = (SystemAccessControl)cls.getDeclaredConstructor(Map.class).newInstance(configMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetSystemSessionProperty(context, propertyName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanAccessCatalog(context, catalogName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        Set filteredCatalogs;
        try {
            this.activatePluginClassLoader();
            filteredCatalogs = this.systemAccessControlImpl.filterCatalogs(context, catalogs);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredCatalogs;
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateSchema(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropSchema(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameSchema(context, schema, newSchemaName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowSchemas(context, catalogName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        Set filteredSchemas;
        try {
            this.activatePluginClassLoader();
            filteredSchemas = this.systemAccessControlImpl.filterSchemas(context, catalogName, schemaNames);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredSchemas;
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameTable(context, table, newTable);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        Set filteredTableNames;
        try {
            this.activatePluginClassLoader();
            filteredTableNames = this.systemAccessControlImpl.filterTables(context, catalogName, tableNames);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredTableNames;
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanAddColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameColumn(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSelectFromColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanInsertIntoTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDeleteFromTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateView(context, view);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanDropView(context, view);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanCreateViewWithSelectFromColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanImpersonateUser(context, userName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteQuery(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanViewQueryOwnedBy(context, queryOwner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        Set filteredQueryOwners;
        try {
            this.activatePluginClassLoader();
            filteredQueryOwners = this.systemAccessControlImpl.filterViewQueryOwnedBy(context, queryOwners);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredQueryOwners;
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanKillQueryOwnedBy(context, queryOwner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowCreateTable(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetTableComment(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowTables(context, schema);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowColumns(context, table);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, List<ColumnMetadata> columns) {
        List filteredColumns;
        try {
            this.activatePluginClassLoader();
            filteredColumns = this.systemAccessControlImpl.filterColumns(context, table, columns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return filteredColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRenameView(context, view, newView);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanGrantTablePrivilege(context, privilege, table, grantee, withGrantOption);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOptionFor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowRoles(context, catalogName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        Optional viewExpression;
        try {
            this.activatePluginClassLoader();
            viewExpression = this.systemAccessControlImpl.getRowFilter(context, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        Optional viewExpression;
        try {
            this.activatePluginClassLoader();
            viewExpression = this.systemAccessControlImpl.getColumnMask(context, tableName, columnName, type);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        return viewExpression;
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetUser(principal, userName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, PrestoPrincipal grantee, boolean grantOption) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, PrestoPrincipal principal) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanSetSchemaAuthorization(context, schema, principal);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanShowCreateSchema(context, schemaName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteProcedure(systemSecurityContext, procedure);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        try {
            this.activatePluginClassLoader();
            this.systemAccessControlImpl.checkCanExecuteFunction(systemSecurityContext, functionName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

