/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;
import org.apache.qpid.protonj2.types.messaging.Footer;
import org.apache.qpid.protonj2.types.messaging.Header;
import org.apache.qpid.protonj2.types.messaging.MessageAnnotations;
import org.apache.qpid.protonj2.types.messaging.Properties;
import org.apache.qpid.protonj2.types.messaging.Section;

public final class ClientMessage<E>
implements AdvancedMessage<E> {
    private Header header;
    private MessageAnnotations messageAnnotations;
    private Properties properties;
    private ApplicationProperties applicationProperties;
    private Section<E> body;
    private List<Section<?>> bodySections;
    private Footer footer;
    private int messageFormat;

    ClientMessage() {
        this.body = null;
    }

    ClientMessage(Section<E> body) {
        this.body = body;
    }

    @Override
    public AdvancedMessage<E> toAdvancedMessage() {
        return this;
    }

    public static <V> ClientMessage<V> create() {
        return new ClientMessage();
    }

    public static <V> ClientMessage<V> create(Section<V> body) {
        return new ClientMessage<V>(body);
    }

    public static <V> ClientMessage<V> createAdvancedMessage() {
        return new ClientMessage();
    }

    @Override
    public boolean durable() {
        return this.header == null ? false : this.header.isDurable();
    }

    @Override
    public ClientMessage<E> durable(boolean durable) {
        this.lazyCreateHeader().setDurable(durable);
        return this;
    }

    @Override
    public byte priority() {
        return this.header == null ? (byte)4 : this.header.getPriority();
    }

    @Override
    public ClientMessage<E> priority(byte priority) {
        this.lazyCreateHeader().setPriority(priority);
        return this;
    }

    @Override
    public long timeToLive() {
        return this.header == null ? Header.DEFAULT_TIME_TO_LIVE : this.header.getTimeToLive();
    }

    @Override
    public ClientMessage<E> timeToLive(long timeToLive) {
        this.lazyCreateHeader().setTimeToLive(timeToLive);
        return this;
    }

    @Override
    public boolean firstAcquirer() {
        return this.header == null ? false : this.header.isFirstAcquirer();
    }

    @Override
    public ClientMessage<E> firstAcquirer(boolean firstAcquirer) {
        this.lazyCreateHeader().setFirstAcquirer(firstAcquirer);
        return this;
    }

    @Override
    public long deliveryCount() {
        return this.header == null ? 0L : this.header.getDeliveryCount();
    }

    @Override
    public ClientMessage<E> deliveryCount(long deliveryCount) {
        this.lazyCreateHeader().setDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public Object messageId() {
        return this.properties != null ? this.properties.getMessageId() : null;
    }

    @Override
    public Message<E> messageId(Object messageId) {
        this.lazyCreateProperties().setMessageId(messageId);
        return this;
    }

    @Override
    public byte[] userId() {
        byte[] copyOfUserId = null;
        if (this.properties != null && this.properties.getUserId() != null) {
            copyOfUserId = this.properties.getUserId().asByteArray();
        }
        return copyOfUserId;
    }

    @Override
    public Message<E> userId(byte[] userId) {
        this.lazyCreateProperties().setUserId(new Binary(Arrays.copyOf(userId, userId.length)));
        return this;
    }

    @Override
    public String to() {
        return this.properties != null ? this.properties.getTo() : null;
    }

    @Override
    public Message<E> to(String to) {
        this.lazyCreateProperties().setTo(to);
        return this;
    }

    @Override
    public String subject() {
        return this.properties != null ? this.properties.getSubject() : null;
    }

    @Override
    public Message<E> subject(String subject) {
        this.lazyCreateProperties().setSubject(subject);
        return this;
    }

    @Override
    public String replyTo() {
        return this.properties != null ? this.properties.getReplyTo() : null;
    }

    @Override
    public Message<E> replyTo(String replyTo) {
        this.lazyCreateProperties().setReplyTo(replyTo);
        return this;
    }

    @Override
    public Object correlationId() {
        return this.properties != null ? this.properties.getCorrelationId() : null;
    }

    @Override
    public Message<E> correlationId(Object correlationId) {
        this.lazyCreateProperties().setCorrelationId(correlationId);
        return this;
    }

    @Override
    public String contentType() {
        return this.properties != null ? this.properties.getContentType() : null;
    }

    @Override
    public Message<E> contentType(String contentType) {
        this.lazyCreateProperties().setContentType(contentType);
        return this;
    }

    @Override
    public String contentEncoding() {
        return this.properties != null ? this.properties.getContentEncoding() : null;
    }

    @Override
    public Message<E> contentEncoding(String contentEncoding) {
        this.lazyCreateProperties().setContentEncoding(contentEncoding);
        return this;
    }

    @Override
    public long absoluteExpiryTime() {
        return this.properties != null ? this.properties.getAbsoluteExpiryTime() : 0L;
    }

    @Override
    public Message<E> absoluteExpiryTime(long expiryTime) {
        this.lazyCreateProperties().setAbsoluteExpiryTime(expiryTime);
        return this;
    }

    @Override
    public long creationTime() {
        return this.properties != null ? this.properties.getCreationTime() : 0L;
    }

    @Override
    public Message<E> creationTime(long createTime) {
        this.lazyCreateProperties().setCreationTime(createTime);
        return this;
    }

    @Override
    public String groupId() {
        return this.properties != null ? this.properties.getGroupId() : null;
    }

    @Override
    public Message<E> groupId(String groupId) {
        this.lazyCreateProperties().setGroupId(groupId);
        return this;
    }

    @Override
    public int groupSequence() {
        return this.properties != null ? (int)this.properties.getGroupSequence() : 0;
    }

    @Override
    public Message<E> groupSequence(int groupSequence) {
        this.lazyCreateProperties().setGroupSequence(groupSequence);
        return this;
    }

    @Override
    public String replyToGroupId() {
        return this.properties != null ? this.properties.getReplyToGroupId() : null;
    }

    @Override
    public Message<E> replyToGroupId(String replyToGroupId) {
        this.lazyCreateProperties().setReplyToGroupId(replyToGroupId);
        return this;
    }

    @Override
    public Object annotation(String key) {
        if (this.hasAnnotations()) {
            return this.messageAnnotations.getValue().get(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String key) {
        if (this.hasAnnotations()) {
            return this.messageAnnotations.getValue().containsKey(Symbol.valueOf((String)key));
        }
        return false;
    }

    @Override
    public boolean hasAnnotations() {
        return this.messageAnnotations != null && this.messageAnnotations.getValue() != null && this.messageAnnotations.getValue().size() > 0;
    }

    @Override
    public Object removeAnnotation(String key) {
        if (this.hasAnnotations()) {
            return this.messageAnnotations.getValue().remove(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public Message<E> forEachAnnotation(BiConsumer<String, Object> action) {
        if (this.hasAnnotations()) {
            this.messageAnnotations.getValue().forEach((key, value) -> action.accept(key.toString(), value));
        }
        return this;
    }

    @Override
    public ClientMessage<E> annotation(String key, Object value) {
        this.lazyCreateMessageAnnotations().getValue().put(Symbol.valueOf((String)key), value);
        return this;
    }

    @Override
    public Object property(String key) {
        if (this.hasProperties()) {
            return this.applicationProperties.getValue().get(key);
        }
        return null;
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.hasProperties()) {
            return this.applicationProperties.getValue().containsKey(key);
        }
        return false;
    }

    @Override
    public boolean hasProperties() {
        return this.applicationProperties != null && this.applicationProperties.getValue() != null && this.applicationProperties.getValue().size() > 0;
    }

    @Override
    public Object removeProperty(String key) {
        if (this.hasProperties()) {
            return this.applicationProperties.getValue().remove(key);
        }
        return null;
    }

    @Override
    public Message<E> forEachProperty(BiConsumer<String, Object> action) {
        if (this.hasProperties()) {
            this.applicationProperties.getValue().forEach(action);
        }
        return this;
    }

    @Override
    public ClientMessage<E> property(String key, Object value) {
        this.lazyCreateApplicationProperties().getValue().put(key, value);
        return this;
    }

    @Override
    public Object footer(String key) {
        if (this.hasFooters()) {
            return this.footer.getValue().get(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public boolean hasFooter(String key) {
        if (this.hasFooters()) {
            return this.footer.getValue().containsKey(Symbol.valueOf((String)key));
        }
        return false;
    }

    @Override
    public boolean hasFooters() {
        return this.footer != null && this.footer.getValue() != null && this.footer.getValue().size() > 0;
    }

    @Override
    public Object removeFooter(String key) {
        if (this.hasFooters()) {
            return this.footer.getValue().remove(Symbol.valueOf((String)key));
        }
        return null;
    }

    @Override
    public Message<E> forEachFooter(BiConsumer<String, Object> action) {
        if (this.hasFooters()) {
            this.footer.getValue().forEach((key, value) -> action.accept(key.toString(), value));
        }
        return this;
    }

    @Override
    public ClientMessage<E> footer(String key, Object value) {
        this.lazyCreateFooter().getValue().put(Symbol.valueOf((String)key), value);
        return this;
    }

    @Override
    public E body() {
        Object section = this.body;
        if (this.bodySections != null) {
            section = this.bodySections.get(0);
        }
        return (E)(section != null ? section.getValue() : null);
    }

    @Override
    public ClientMessage<E> body(E value) {
        this.clearBodySections();
        this.body = ClientMessageSupport.createSectionFromValue(value);
        return this;
    }

    private Header lazyCreateHeader() {
        if (this.header == null) {
            this.header = new Header();
        }
        return this.header;
    }

    private Properties lazyCreateProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    private ApplicationProperties lazyCreateApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = new ApplicationProperties(new LinkedHashMap());
        }
        return this.applicationProperties;
    }

    private MessageAnnotations lazyCreateMessageAnnotations() {
        if (this.messageAnnotations == null) {
            this.messageAnnotations = new MessageAnnotations(new LinkedHashMap());
        }
        return this.messageAnnotations;
    }

    private Footer lazyCreateFooter() {
        if (this.footer == null) {
            this.footer = new Footer(new LinkedHashMap());
        }
        return this.footer;
    }

    @Override
    public Header header() {
        return this.header;
    }

    @Override
    public ClientMessage<E> header(Header header) {
        this.header = header;
        return this;
    }

    @Override
    public MessageAnnotations annotations() {
        return this.messageAnnotations;
    }

    @Override
    public ClientMessage<E> annotations(MessageAnnotations messageAnnotations) {
        this.messageAnnotations = messageAnnotations;
        return this;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public ClientMessage<E> properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public ApplicationProperties applicationProperties() {
        return this.applicationProperties;
    }

    @Override
    public ClientMessage<E> applicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        return this;
    }

    @Override
    public Footer footer() {
        return this.footer;
    }

    @Override
    public ClientMessage<E> footer(Footer footer) {
        this.footer = footer;
        return this;
    }

    @Override
    public int messageFormat() {
        return this.messageFormat;
    }

    @Override
    public ClientMessage<E> messageFormat(int messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    @Override
    public ProtonBuffer encode(Map<String, Object> deliveryAnnotations, ProtonBufferAllocator allocator) throws ClientException {
        return ClientMessageSupport.encodeMessage(this, deliveryAnnotations, allocator);
    }

    @Override
    public ClientMessage<E> addBodySection(Section<?> bodySection) {
        Objects.requireNonNull(bodySection, "Additional Body Section cannot be null");
        if (this.body == null && this.bodySections == null) {
            this.body = bodySection;
        } else {
            if (this.bodySections == null) {
                this.bodySections = new ArrayList();
                if (this.body != null) {
                    this.bodySections.add(this.body);
                    this.body = null;
                }
            }
            this.bodySections.add(ClientMessage.validateBodySections(this.messageFormat, this.bodySections, bodySection));
        }
        return this;
    }

    @Override
    public ClientMessage<E> bodySections(Collection<Section<?>> sections) {
        if (sections == null || sections.isEmpty()) {
            this.bodySections = null;
        } else {
            ArrayList result = new ArrayList(sections.size());
            sections.forEach(section -> result.add(ClientMessage.validateBodySections(this.messageFormat, result, section)));
            this.bodySections = result;
        }
        this.body = null;
        return this;
    }

    @Override
    public Collection<Section<?>> bodySections() {
        if (this.bodySections == null && this.body == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.body != null) {
            return Collections.singletonList(this.body);
        }
        ArrayList result = new ArrayList();
        this.forEachBodySection((T section) -> result.add(section));
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public ClientMessage<E> forEachBodySection(Consumer<Section<?>> consumer) {
        if (this.bodySections != null) {
            this.bodySections.forEach(section -> consumer.accept((Section<?>)section));
        } else if (this.body != null) {
            consumer.accept(this.body);
        }
        return this;
    }

    @Override
    public ClientMessage<E> clearBodySections() {
        this.bodySections = null;
        this.body = null;
        return this;
    }

    private static Section<?> validateBodySections(int messageFormat, List<Section<?>> target, Section<?> section) {
        if (messageFormat == 0 && target != null && !target.isEmpty()) {
            switch (section.getType()) {
                case AmqpSequence: {
                    if (target.get(0).getType() == Section.SectionType.AmqpSequence) break;
                    throw new IllegalArgumentException("Message Format violation: AmqpSequence expected but got type: " + String.valueOf(section.getType()));
                }
                case AmqpValue: {
                    throw new IllegalArgumentException("Message Format violation: Only one AmqpValue section allowed");
                }
                case Data: {
                    if (target.get(0).getType() == Section.SectionType.Data) break;
                    throw new IllegalArgumentException("Message Format violation: Data Section expected but got type: " + String.valueOf(section.getType()));
                }
            }
        }
        return section;
    }
}

