/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonBufferUtils;
import org.apache.qpid.protonj2.buffer.ProtonCompositeBuffer;
import org.apache.qpid.protonj2.buffer.impl.ProtonByteArrayBuffer;

public final class ProtonByteArrayBufferAllocator
implements ProtonBufferAllocator {
    private static final ProtonBufferAllocator DEFAULT = ProtonBufferUtils.unclosable(new ProtonByteArrayBufferAllocator());
    private boolean closed;

    @Override
    public void close() {
        this.closed = true;
    }

    public static final ProtonBufferAllocator allocator() {
        return DEFAULT;
    }

    @Override
    public ProtonBuffer outputBuffer(int initialCapacity) {
        this.checkClosed();
        return new ProtonByteArrayBuffer(initialCapacity);
    }

    @Override
    public ProtonBuffer allocate() {
        this.checkClosed();
        return new ProtonByteArrayBuffer();
    }

    @Override
    public ProtonBuffer allocate(int initialCapacity) {
        this.checkClosed();
        return new ProtonByteArrayBuffer(initialCapacity);
    }

    @Override
    public ProtonBuffer allocateHeapBuffer() {
        this.checkClosed();
        return new ProtonByteArrayBuffer();
    }

    @Override
    public ProtonBuffer allocateHeapBuffer(int initialCapacity) {
        this.checkClosed();
        return new ProtonByteArrayBuffer(initialCapacity);
    }

    @Override
    public ProtonBuffer copy(byte[] array, int offset, int length) {
        this.checkClosed();
        byte[] copy = new byte[length];
        System.arraycopy(array, offset, copy, 0, length);
        return new ProtonByteArrayBuffer(copy, 0, length).setWriteOffset(length);
    }

    public ProtonBuffer wrap(byte[] array, int offset, int length) {
        this.checkClosed();
        return new ProtonByteArrayBuffer(array, offset, length, 0x7FFFFFF7).setWriteOffset(length);
    }

    @Override
    public ProtonCompositeBuffer composite() {
        this.checkClosed();
        return ProtonCompositeBuffer.create(this);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer buffer) {
        return ProtonCompositeBuffer.create(ProtonBufferAllocator.defaultAllocator(), buffer);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer[] buffers) {
        return ProtonCompositeBuffer.create(ProtonBufferAllocator.defaultAllocator(), buffers);
    }

    public static ProtonBuffer wrapped(byte[] array) {
        return new ProtonByteArrayBuffer(array, 0, array.length, 0x7FFFFFF7).setWriteOffset(array.length);
    }

    public static ProtonBuffer wrapped(byte[] array, int offset, int length) {
        return new ProtonByteArrayBuffer(array, offset, length, 0x7FFFFFF7).setWriteOffset(length);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("This allocator instance is closed");
        }
    }
}

