/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferClosedException;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import org.apache.qpid.protonj2.buffer.ProtonBufferIterator;
import org.apache.qpid.protonj2.buffer.ProtonBufferUtils;
import org.apache.qpid.protonj2.resource.SharedResource;

public final class ProtonByteArrayBuffer
extends SharedResource<ProtonBuffer>
implements ProtonBuffer,
ProtonBufferComponent,
ProtonBufferComponentAccessor {
    public static final int DEFAULT_CAPACITY = 64;
    public static final int DEFAULT_MAXIMUM_CAPACITY = 0x7FFFFFF7;
    private static final int CLOSED_MARKER = -1;
    private byte[] array;
    private int arrayOffset;
    private int readCapacity;
    private int writeCapacity;
    private int implicitGrowthLimit = 0x7FFFFFF7;
    private int readOffset;
    private int writeOffset;
    private boolean readOnly;
    private boolean closed;

    public ProtonByteArrayBuffer() {
        this(64, 0x7FFFFFF7);
    }

    public ProtonByteArrayBuffer(int initialCapacity) {
        this(initialCapacity, 0x7FFFFFF7);
    }

    public ProtonByteArrayBuffer(int initialCapacity, int implicitGrowthLimit) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity cannot be < 0");
        }
        if (initialCapacity > implicitGrowthLimit) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity.");
        }
        this.array = new byte[initialCapacity];
        this.arrayOffset = 0;
        this.readCapacity = this.array.length;
        this.writeCapacity = this.array.length;
        this.implicitGrowthLimit = implicitGrowthLimit;
    }

    public ProtonByteArrayBuffer(byte[] backingArray) {
        this(backingArray, 0, 0x7FFFFFF7);
    }

    public ProtonByteArrayBuffer(byte[] backingArray, int implicitGrowthLimit) {
        this(backingArray, 0, implicitGrowthLimit);
    }

    public ProtonByteArrayBuffer(byte[] backingArray, int arrayOffset, int implicitGrowthLimit) {
        this(backingArray, arrayOffset, backingArray.length - arrayOffset, implicitGrowthLimit);
    }

    public ProtonByteArrayBuffer(byte[] backingArray, int arrayOffset, int capacity, int implicitGrowthLimit) {
        if (arrayOffset > backingArray.length) {
            throw new IndexOutOfBoundsException("Array offset cannot exceed the array length");
        }
        if (capacity > backingArray.length - arrayOffset) {
            throw new IndexOutOfBoundsException("Array segment capacity cannot exceed the configured array length minus the offset");
        }
        this.array = backingArray;
        this.arrayOffset = arrayOffset;
        this.readCapacity = capacity;
        this.writeCapacity = capacity;
        this.implicitGrowthLimit = implicitGrowthLimit;
    }

    private ProtonByteArrayBuffer(byte[] backingArray, int arrayOffset, boolean readOnly) {
        this.array = backingArray;
        this.arrayOffset = arrayOffset;
        this.readOnly = readOnly;
    }

    @Override
    public ProtonBuffer unwrap() {
        return this;
    }

    public String toString() {
        return "ProtonByteArrayBuffer{ read:" + this.readOffset + ", write: " + this.writeOffset + ", capacity: " + this.readCapacity + "}";
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public int readableComponentCount() {
        return this.isReadable() ? 1 : 0;
    }

    @Override
    public int writableComponentCount() {
        return this.isWritable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public ProtonByteArrayBuffer convertToReadOnly() {
        this.readOnly = true;
        this.writeCapacity = -1;
        return this;
    }

    @Override
    public int capacity() {
        return Math.max(0, this.readCapacity);
    }

    @Override
    public int getReadableBytes() {
        return this.writeOffset - this.readOffset;
    }

    @Override
    public int getWritableBytes() {
        return Math.max(0, this.writeCapacity - this.writeOffset);
    }

    @Override
    public int getReadOffset() {
        return this.readOffset;
    }

    @Override
    public int getWriteOffset() {
        return this.writeOffset;
    }

    @Override
    public ProtonBuffer setWriteOffset(int value) {
        this.checkWrite(value, 0, false);
        this.writeOffset = value;
        return this;
    }

    @Override
    public ProtonBuffer setReadOffset(int value) {
        this.checkRead(value, 0);
        this.readOffset = value;
        return this;
    }

    @Override
    public ProtonBuffer fill(byte value) {
        this.checkSet(0, 1);
        Arrays.fill(this.array, this.arrayOffset, this.arrayOffset + this.readCapacity, value);
        return this;
    }

    @Override
    public ProtonBuffer split(int splitOffset) {
        ProtonBufferUtils.checkIsNotNegative(splitOffset, "The split offset cannot be negative");
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (this.isClosed()) {
            throw new ProtonBufferClosedException("Cannot split a closed buffer");
        }
        ProtonByteArrayBuffer front = new ProtonByteArrayBuffer(this.array, this.arrayOffset, splitOffset, 0x7FFFFFF7);
        front.writeOffset = Math.min(this.writeOffset, splitOffset);
        front.readOffset = Math.min(this.readOffset, splitOffset);
        if (this.isReadOnly()) {
            front.convertToReadOnly();
        }
        this.arrayOffset += splitOffset;
        this.readCapacity -= splitOffset;
        this.writeCapacity = this.isReadOnly() ? -1 : this.readCapacity;
        this.writeOffset = Math.max(this.writeOffset, splitOffset) - splitOffset;
        this.readOffset = Math.max(this.readOffset, splitOffset) - splitOffset;
        return front;
    }

    public boolean equals(Object o) {
        return o instanceof ProtonBuffer && ProtonBufferUtils.equals(this, (ProtonBuffer)o);
    }

    public int hashCode() {
        return ProtonBufferUtils.hashCode(this);
    }

    @Override
    public byte peekByte() {
        this.checkPeek();
        return ProtonBufferUtils.readByte(this.array, this.offset(this.readOffset));
    }

    @Override
    public byte getByte(int index) {
        this.checkGet(index, 1);
        return ProtonBufferUtils.readByte(this.array, this.offset(index));
    }

    @Override
    public char getChar(int index) {
        this.checkGet(index, 2);
        return ProtonBufferUtils.readChar(this.array, this.offset(index));
    }

    @Override
    public short getShort(int index) {
        this.checkGet(index, 2);
        return ProtonBufferUtils.readShort(this.array, this.offset(index));
    }

    @Override
    public int getInt(int index) {
        this.checkGet(index, 4);
        return ProtonBufferUtils.readInt(this.array, this.offset(index));
    }

    @Override
    public long getLong(int index) {
        this.checkGet(index, 8);
        return ProtonBufferUtils.readLong(this.array, this.offset(index));
    }

    @Override
    public byte readByte() {
        this.checkRead(this.readOffset, 1);
        byte result = ProtonBufferUtils.readByte(this.array, this.offset(this.readOffset));
        ++this.readOffset;
        return result;
    }

    @Override
    public char readChar() {
        this.checkRead(this.readOffset, 2);
        char result = ProtonBufferUtils.readChar(this.array, this.offset(this.readOffset));
        this.readOffset += 2;
        return result;
    }

    @Override
    public short readShort() {
        this.checkRead(this.readOffset, 2);
        short result = ProtonBufferUtils.readShort(this.array, this.offset(this.readOffset));
        this.readOffset += 2;
        return result;
    }

    @Override
    public int readInt() {
        this.checkRead(this.readOffset, 4);
        int result = ProtonBufferUtils.readInt(this.array, this.offset(this.readOffset));
        this.readOffset += 4;
        return result;
    }

    @Override
    public long readLong() {
        this.checkRead(this.readOffset, 8);
        long result = ProtonBufferUtils.readLong(this.array, this.offset(this.readOffset));
        this.readOffset += 8;
        return result;
    }

    @Override
    public ProtonBuffer setByte(int index, byte value) {
        this.checkSet(index, 1);
        ProtonBufferUtils.writeByte(value, this.array, this.offset(index));
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, char value) {
        this.checkSet(index, 2);
        ProtonBufferUtils.writeChar(value, this.array, this.offset(index));
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, short value) {
        this.checkSet(index, 2);
        ProtonBufferUtils.writeShort(value, this.array, this.offset(index));
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.checkSet(index, 4);
        ProtonBufferUtils.writeInt(value, this.array, this.offset(index));
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.checkSet(index, 8);
        ProtonBufferUtils.writeLong(value, this.array, this.offset(index));
        return this;
    }

    @Override
    public ProtonBuffer writeByte(byte value) {
        this.checkWrite(this.writeOffset, 1, true);
        ProtonBufferUtils.writeByte(value, this.array, this.offset(this.writeOffset++));
        return this;
    }

    @Override
    public ProtonBuffer writeChar(char value) {
        this.checkWrite(this.writeOffset, 2, true);
        ProtonBufferUtils.writeChar(value, this.array, this.offset(this.writeOffset));
        this.writeOffset += 2;
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        this.checkWrite(this.writeOffset, 2, true);
        ProtonBufferUtils.writeShort(value, this.array, this.offset(this.writeOffset));
        this.writeOffset += 2;
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        this.checkWrite(this.writeOffset, 4, true);
        ProtonBufferUtils.writeInt(value, this.array, this.offset(this.writeOffset));
        this.writeOffset += 4;
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        this.checkWrite(this.writeOffset, 8, true);
        ProtonBufferUtils.writeLong(value, this.array, this.offset(this.writeOffset));
        this.writeOffset += 8;
        return this;
    }

    @Override
    public ProtonBuffer copy(int offset, int length, boolean readOnly) throws IllegalArgumentException {
        ProtonByteArrayBuffer result;
        ProtonBufferUtils.checkLength(length);
        if (readOnly && this.isReadOnly()) {
            result = new ProtonByteArrayBuffer(this.array, this.offset(offset), length, this.implicitGrowthLimit);
            result.writeOffset = length;
        } else {
            this.checkGet(offset, length);
            byte[] copyBytes = Arrays.copyOfRange(this.array, this.offset(offset), this.offset(offset) + length);
            result = new ProtonByteArrayBuffer(copyBytes);
            result.writeOffset = length;
        }
        if (readOnly) {
            result.convertToReadOnly();
        }
        return result;
    }

    @Override
    public void copyInto(int offset, byte[] destination, int destOffset, int length) {
        this.checkCopyIntoArgs(offset, length, destOffset, destination.length);
        System.arraycopy(this.array, this.offset(offset), destination, destOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int offset, ByteBuffer destination, int destOffset, int length) {
        if (destination.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        this.checkCopyIntoArgs(offset, length, destOffset, destination.capacity());
        if (destination.hasArray()) {
            System.arraycopy(this.array, this.offset(offset), destination.array(), destination.arrayOffset() + destOffset, length);
        } else {
            int oldPos = destination.position();
            try {
                destination.position(destOffset);
                destination.put(this.array, this.offset(offset), length);
            }
            finally {
                destination.position(oldPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int offset, ProtonBuffer destination, int destOffset, int length) {
        ProtonBufferUtils.checkIsClosed(destination);
        ProtonBufferUtils.checkIsReadOnly(destination);
        this.checkCopyIntoArgs(offset, length, destOffset, destination.capacity());
        int originalReadOffset = destination.getReadOffset();
        int originalWriteOffset = destination.getWriteOffset();
        destination.setReadOffset(0);
        destination.setWriteOffset(destOffset);
        try {
            destination.writeBytes(this.array, this.offset(offset), length);
        }
        finally {
            destination.setReadOffset(originalReadOffset);
            destination.setWriteOffset(originalWriteOffset);
        }
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source, int offset, int length) {
        this.checkWrite(this.writeOffset, length, true);
        System.arraycopy(source, offset, this.array, this.offset(this.writeOffset), length);
        this.writeOffset += length;
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer source) {
        int length = source.getReadableBytes();
        this.checkWrite(this.writeOffset, length, true);
        source.readBytes(this.array, this.arrayOffset + this.writeOffset, length);
        this.writeOffset += length;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ByteBuffer destination) {
        int byteCount = destination.remaining();
        this.checkCopyIntoArgs(this.readOffset, byteCount, destination.position(), destination.capacity());
        destination.put(this.array, this.offset(this.readOffset), byteCount);
        this.readOffset += byteCount;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] destination, int offset, int length) {
        this.checkCopyIntoArgs(this.readOffset, length, offset, destination.length);
        System.arraycopy(this.array, this.offset(this.readOffset), destination, offset, length);
        this.readOffset += length;
        return this;
    }

    @Override
    public int implicitGrowthLimit() {
        return this.implicitGrowthLimit;
    }

    @Override
    public ProtonBuffer implicitGrowthLimit(int limit) {
        ProtonBufferUtils.checkImplicitGrowthLimit(limit, this.capacity());
        this.implicitGrowthLimit = limit;
        return this;
    }

    @Override
    public ProtonBuffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (size < 0) {
            throw new IllegalArgumentException("Cannot ensure writable for a negative size: " + size + ".");
        }
        if (minimumGrowth < 0) {
            throw new IllegalArgumentException("The minimum growth cannot be negative: " + minimumGrowth + ".");
        }
        if (this.writeCapacity == -1) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        if (this.getWritableBytes() > size) {
            return this;
        }
        if (allowCompaction && this.getWritableBytes() + this.getReadOffset() >= size) {
            return this.compact();
        }
        long newSize = (long)this.capacity() + (long)Math.max(size - this.getWritableBytes(), minimumGrowth);
        ProtonBufferUtils.checkIsNotNegative(newSize, "The buffer cannot be resized to a negative value");
        if (newSize > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("The buffer cannot grow to a size greater than 2147483639, requested size was " + newSize);
        }
        byte[] newArray = new byte[(int)newSize];
        this.copyInto(0, newArray, 0, this.capacity());
        this.array = newArray;
        this.arrayOffset = 0;
        this.readCapacity = this.array.length;
        this.writeCapacity = this.readOnly ? -1 : this.array.length;
        return this;
    }

    @Override
    public ProtonBuffer compact() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        if (this.readOffset != 0) {
            System.arraycopy(this.array, this.arrayOffset + this.readOffset, this.array, 0, this.writeOffset - this.readOffset);
            this.writeOffset -= this.readOffset;
            this.readOffset = 0;
        }
        return this;
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "TransferTo length cannot be negative: " + length);
        int writableBytes = Math.min(this.getReadableBytes(), length);
        this.checkGet(this.readOffset, writableBytes);
        if (writableBytes == 0) {
            return 0;
        }
        ByteBuffer ioWrapper = ByteBuffer.wrap(this.array, this.readOffset, writableBytes);
        int actualWrite = channel.write(ioWrapper);
        this.readOffset += actualWrite;
        return actualWrite;
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsReadOnly(this);
        length = Math.min(this.getWritableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.getWriteOffset(), length);
        ByteBuffer target = this.getWritableBuffer().limit(length);
        int bytesRead = channel.read(target.limit(target.position() + length));
        if (bytesRead != -1) {
            this.writeOffset += bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsReadOnly(this);
        length = Math.min(this.getWritableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.getWriteOffset(), length);
        ByteBuffer target = this.getWritableBuffer().limit(length);
        int bytesRead = channel.read(target.limit(target.position() + length), position);
        if (bytesRead != -1) {
            this.writeOffset += bytesRead;
        }
        return bytesRead;
    }

    @Override
    public ProtonBufferComponentAccessor componentAccessor() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        return (ProtonBufferComponentAccessor)this.acquire();
    }

    @Override
    public ProtonBufferComponent first() {
        return this;
    }

    @Override
    public ProtonBufferComponent next() {
        return null;
    }

    @Override
    public ProtonBufferIterator bufferIterator() {
        return this.bufferIterator(this.getReadOffset(), this.getReadableBytes());
    }

    @Override
    public ProtonBufferIterator bufferIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkArgumentIsNotNegative(offset, "offset");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "length");
        this.checkGet(offset, length);
        return new ProtonByteArrayBufferIterator(this.array, this.offset(offset), length);
    }

    @Override
    public ProtonBufferIterator bufferReverseIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkArgumentIsNotNegative(offset, "offset");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "length");
        if (offset >= this.capacity()) {
            throw new IndexOutOfBoundsException("Read offset must be within the bounds of the buffer: offset = " + offset + ", capacity = " + this.capacity());
        }
        if (offset - length < -1) {
            throw new IndexOutOfBoundsException("Cannot read past start of buffer: offset = " + offset + ", length = " + length);
        }
        return new ProtonByteArrayBufferReverseIterator(this.array, this.offset(offset), length);
    }

    @Override
    public boolean hasReadbleArray() {
        return this.isReadable();
    }

    @Override
    public ProtonByteArrayBuffer advanceReadOffset(int amount) {
        return (ProtonByteArrayBuffer)ProtonBuffer.super.advanceReadOffset(amount);
    }

    @Override
    public byte[] getReadableArray() {
        return this.array;
    }

    @Override
    public int getReadableArrayOffset() {
        return this.arrayOffset;
    }

    @Override
    public int getReadableArrayLength() {
        return this.writeOffset - this.readOffset;
    }

    @Override
    public ByteBuffer getReadableBuffer() {
        return ByteBuffer.wrap(this.array, this.arrayOffset + this.readOffset, this.readCapacity - this.readOffset).asReadOnlyBuffer();
    }

    @Override
    public ProtonByteArrayBuffer advanceWriteOffset(int amount) {
        return (ProtonByteArrayBuffer)ProtonBuffer.super.advanceWriteOffset(amount);
    }

    @Override
    public boolean hasWritableArray() {
        return this.writeCapacity > 0;
    }

    @Override
    public byte[] getWritableArray() {
        return this.array;
    }

    @Override
    public int getWritableArrayOffset() {
        return this.arrayOffset + this.writeOffset;
    }

    @Override
    public int getWritableArrayLength() {
        return this.getWritableBytes();
    }

    @Override
    public ByteBuffer getWritableBuffer() {
        if (this.writeCapacity < 0) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(this.array, this.arrayOffset + this.writeOffset, this.getWritableBytes());
    }

    @Override
    public long getNativeAddress() {
        return 0L;
    }

    @Override
    public long getNativeReadAddress() {
        return 0L;
    }

    @Override
    public long getNativeWriteAddress() {
        return 0L;
    }

    @Override
    public int indexOf(byte needle, int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        this.checkIndexOfBounds(offset, length);
        int end = offset + length;
        if (length > 7) {
            long pattern = ((long)needle & 0xFFL) * 0x101010101010101L;
            int stopAfter = offset + (length >>> 3) * 8;
            while (offset < stopAfter) {
                long word = ProtonBufferUtils.readLong(this.array, this.offset(offset));
                long input = word ^ pattern;
                long tmp = (input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
                int index = Long.numberOfLeadingZeros(tmp = (tmp | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL) >>> 3;
                if (index < 8) {
                    return offset + index;
                }
                offset += 8;
            }
        }
        while (offset < end) {
            if (this.array[this.offset(offset)] == needle) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @Override
    protected void releaseResourceOwnership() {
        this.closed = true;
        this.readOnly = false;
        this.writeCapacity = -1;
        this.readCapacity = -1;
        this.readOffset = 0;
        this.writeOffset = 0;
        this.array = null;
    }

    @Override
    protected ProtonBuffer transferTheResource() {
        ProtonByteArrayBuffer transfer = new ProtonByteArrayBuffer(this.array, this.arrayOffset, this.readOnly);
        transfer.readCapacity = this.readCapacity;
        transfer.writeCapacity = this.writeCapacity;
        transfer.readOffset = this.readOffset;
        transfer.writeOffset = this.writeOffset;
        return transfer;
    }

    @Override
    protected RuntimeException resourceIsClosedException() {
        return ProtonBufferUtils.genericBufferIsClosed(this);
    }

    private int offset(int index) {
        return index + this.arrayOffset;
    }

    private void checkWrite(int index, int size, boolean allowExpansion) {
        if (index < this.readOffset || this.writeCapacity < index + size) {
            this.expandOrThrowError(index, size, allowExpansion);
        }
    }

    private void checkPeek() {
        if (this.readOffset == this.writeOffset) {
            if (this.closed) {
                throw ProtonBufferUtils.genericBufferIsClosed(this);
            }
            throw ProtonBufferUtils.genericOutOfBounds(this, this.readOffset);
        }
    }

    private void checkRead(int index, int size) {
        if (index < 0 || this.writeOffset < index + size || this.closed) {
            if (this.closed) {
                throw ProtonBufferUtils.genericBufferIsClosed(this);
            }
            throw ProtonBufferUtils.genericOutOfBounds(this, index);
        }
    }

    private void checkGet(int index, int size) {
        if (index < 0 || this.readCapacity < index + size) {
            if (this.closed) {
                throw ProtonBufferUtils.genericBufferIsClosed(this);
            }
            throw ProtonBufferUtils.genericOutOfBounds(this, index);
        }
    }

    private void checkSet(int index, int size) {
        if (index < 0 || this.writeCapacity < index + size) {
            this.expandOrThrowError(index, size, false);
        }
    }

    private void checkIndexOfBounds(int index, int size) {
        if (index < this.readOffset || this.writeOffset < index + size) {
            throw new IndexOutOfBoundsException("Search range [read " + index + " length " + size + "] is out of bounds: [read " + this.readOffset + " length " + this.getReadableBytes() + "].");
        }
    }

    private void expandOrThrowError(int index, int size, boolean mayExpand) {
        if (this.readCapacity == -1) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.readOnly) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        int capacity = this.capacity();
        if (mayExpand && index >= 0 && index <= capacity && this.writeOffset + size <= this.implicitGrowthLimit) {
            int minimumGrowth = Math.min(Math.max(capacity * 2, size), this.implicitGrowthLimit) - capacity;
            this.ensureWritable(size, minimumGrowth, false);
            this.checkSet(index, size);
            return;
        }
        throw ProtonBufferUtils.genericOutOfBounds(this, index);
    }

    private void checkCopyIntoArgs(int srcPos, int length, int destPos, int destLength) {
        if (this.readCapacity == -1) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (srcPos < 0) {
            throw new IndexOutOfBoundsException("The srcPos cannot be negative: " + srcPos + ".");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("The length value cannot be negative " + length + ".");
        }
        if (this.readCapacity < srcPos + length) {
            throw new IndexOutOfBoundsException("The srcPos + length is beyond the end of the buffer: srcPos = " + srcPos + ", length = " + length + ".");
        }
        if (destPos < 0) {
            throw new IndexOutOfBoundsException("The destPos cannot be negative: " + destPos + ".");
        }
        if (destLength < destPos + length) {
            throw new IndexOutOfBoundsException("The destPos + length is beyond the end of the destination: destPos = " + destPos + ", length = " + length + ".");
        }
    }

    private static final class ProtonByteArrayBufferIterator
    implements ProtonBufferIterator {
        private final int endPos;
        private final byte[] array;
        private int current;

        public ProtonByteArrayBufferIterator(byte[] array, int offset, int length) {
            this.array = array;
            this.current = offset;
            this.endPos = offset + length;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endPos;
        }

        @Override
        public byte next() {
            if (this.current == this.endPos) {
                throw new NoSuchElementException("Buffer iteration complete, no additional bytes available");
            }
            return this.array[this.current++];
        }

        @Override
        public int remaining() {
            return this.endPos - this.current;
        }

        @Override
        public int offset() {
            return this.current;
        }
    }

    private static final class ProtonByteArrayBufferReverseIterator
    implements ProtonBufferIterator {
        private final int endPos;
        private final byte[] array;
        private int current;

        public ProtonByteArrayBufferReverseIterator(byte[] array, int offset, int length) {
            this.array = array;
            this.current = offset;
            this.endPos = offset - length;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endPos;
        }

        @Override
        public byte next() {
            if (this.current == this.endPos) {
                throw new NoSuchElementException("Buffer iteration complete, no additional bytes available");
            }
            return this.array[this.current--];
        }

        @Override
        public int remaining() {
            return Math.abs(this.endPos - this.current);
        }

        @Override
        public int offset() {
            return this.current;
        }
    }
}

