/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import java.util.List;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.AmqpSequence;

public final class AmqpSequenceTypeEncoder
extends AbstractDescribedTypeEncoder<AmqpSequence> {
    private static final byte[] SEQUENCE_PREAMBLE = new byte[]{0, 83, AmqpSequence.DESCRIPTOR_CODE.byteValue()};

    @Override
    public Class<AmqpSequence> getTypeClass() {
        return AmqpSequence.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return AmqpSequence.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return AmqpSequence.DESCRIPTOR_SYMBOL;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, AmqpSequence value) {
        buffer.writeBytes(SEQUENCE_PREAMBLE);
        state.getEncoder().writeList(buffer, state, value.getValue());
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        Object[] elements = new List[values.length];
        for (int i = 0; i < values.length; ++i) {
            AmqpSequence sequence = (AmqpSequence)values[i];
            elements[i] = sequence.getValue();
        }
        TypeEncoder<?> entryEncoder = state.getEncoder().getTypeEncoder(List.class);
        entryEncoder.writeRawArray(buffer, state, elements);
    }
}

