/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.ScanningContext;
import org.apache.qpid.protonj2.codec.decoders.StreamScanningContext;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;

public abstract class AbstractMapTypeDecoder
extends AbstractPrimitiveTypeDecoder<Map>
implements MapTypeDecoder {
    @Override
    public Map<Object, Object> readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int size = this.readSize(buffer, state);
        if (size > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        int count = this.readCount(buffer, state);
        if (count % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", count));
        }
        Decoder decoder = state.getDecoder();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Object key = decoder.readObject(buffer, state);
            Object value = decoder.readObject(buffer, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(this.readSize(buffer, state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KeyType> void scanKeys(ProtonBuffer buffer, DecoderState state, ScanningContext<KeyType> context, BiConsumer<KeyType, Object> matchConsumer) throws DecodeException {
        Decoder decoder = state.getDecoder();
        int encodedSize = this.readSize(buffer, state);
        if (encodedSize > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", encodedSize, buffer.getReadableBytes()));
        }
        int completionOffset = buffer.getReadOffset() + encodedSize;
        int encodedEntries = this.readCount(buffer, state);
        if (encodedEntries % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", encodedEntries));
        }
        try {
            for (int i = 0; i < encodedEntries / 2 && !context.isComplete(); ++i) {
                int keySize;
                TypeDecoder<?> keyDecoder = state.getDecoder().readNextTypeDecoder(buffer, state);
                boolean matched = context.matches(keyDecoder, buffer, keySize = keyDecoder.readSize(buffer, state), key -> {
                    buffer.advanceReadOffset(keySize);
                    matchConsumer.accept(key, decoder.readObject(buffer, state));
                });
                if (matched) continue;
                buffer.advanceReadOffset(keySize);
                decoder.readNextTypeDecoder(buffer, state).skipValue(buffer, state);
            }
            buffer.setReadOffset(completionOffset);
        }
        finally {
            context.reset();
        }
    }

    @Override
    public Map<Object, Object> readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        this.readSize(stream, state);
        int count = this.readCount(stream, state);
        if (count % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", count));
        }
        StreamDecoder decoder = state.getDecoder();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Object key = decoder.readObject(stream, state);
            Object value = decoder.readObject(stream, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream, state));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Map payload bytes", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KeyType> void scanKeys(InputStream stream, StreamDecoderState state, StreamScanningContext<KeyType> context, BiConsumer<KeyType, Object> matchConsumer) throws DecodeException {
        StreamDecoder decoder = state.getDecoder();
        int encodedSize = this.readSize(stream, state);
        int encodedEntries = this.readCount(stream, state);
        if (encodedEntries % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", encodedEntries));
        }
        try {
            for (int i = 0; i < encodedEntries / 2; ++i) {
                int keySize;
                StreamTypeDecoder<?> keyDecoder = state.getDecoder().readNextTypeDecoder(stream, state);
                boolean matched = context.matches(keyDecoder, stream, keySize = keyDecoder.readSize(stream, state), key -> {
                    ProtonStreamUtils.skipBytes(stream, keySize);
                    matchConsumer.accept(key, decoder.readObject(stream, state));
                });
                if (matched) continue;
                ProtonStreamUtils.skipBytes(stream, keySize);
                decoder.readNextTypeDecoder(stream, state).skipValue(stream, state);
            }
        }
        finally {
            context.reset();
        }
    }
}

