/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.types.transport.Attach;
import org.apache.qpid.protonj2.types.transport.Begin;
import org.apache.qpid.protonj2.types.transport.Close;
import org.apache.qpid.protonj2.types.transport.Detach;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.End;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.Open;
import org.apache.qpid.protonj2.types.transport.Performative;
import org.apache.qpid.protonj2.types.transport.Transfer;

public final class PerformativeEncoder
implements Performative.PerformativeHandler<Encoder> {
    private final TypeEncoder<Attach> attachEncoder;
    private final TypeEncoder<Begin> beginEncoder;
    private final TypeEncoder<Close> closeEncoder;
    private final TypeEncoder<Detach> detachEncoder;
    private final TypeEncoder<Disposition> dispositionEncoder;
    private final TypeEncoder<End> endEncoder;
    private final TypeEncoder<Flow> flowEncoder;
    private final TypeEncoder<Open> openEncoder;
    private final TypeEncoder<Transfer> transferEncoder;
    private final Encoder encoder;
    private final EncoderState encoderState;

    public PerformativeEncoder(Encoder encoder) {
        this.encoder = encoder;
        this.encoderState = encoder.newEncoderState();
        this.attachEncoder = encoder.getTypeEncoder(Attach.class);
        this.beginEncoder = encoder.getTypeEncoder(Begin.class);
        this.closeEncoder = encoder.getTypeEncoder(Close.class);
        this.detachEncoder = encoder.getTypeEncoder(Detach.class);
        this.dispositionEncoder = encoder.getTypeEncoder(Disposition.class);
        this.endEncoder = encoder.getTypeEncoder(End.class);
        this.flowEncoder = encoder.getTypeEncoder(Flow.class);
        this.openEncoder = encoder.getTypeEncoder(Open.class);
        this.transferEncoder = encoder.getTypeEncoder(Transfer.class);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public EncoderState getEncoderState() {
        return this.encoderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOpen(Open open, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.openEncoder.writeType(target, this.encoderState, open);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBegin(Begin begin, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.beginEncoder.writeType(target, this.encoderState, begin);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAttach(Attach attach, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.attachEncoder.writeType(target, this.encoderState, attach);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFlow(Flow flow, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.flowEncoder.writeType(target, this.encoderState, flow);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTransfer(Transfer transfer, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.transferEncoder.writeType(target, this.encoderState, transfer);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDisposition(Disposition disposition, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.dispositionEncoder.writeType(target, this.encoderState, disposition);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDetach(Detach detach, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.detachEncoder.writeType(target, this.encoderState, detach);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEnd(End end, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.endEncoder.writeType(target, this.encoderState, end);
        }
        finally {
            this.encoderState.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClose(Close close, ProtonBuffer target, int channel, Encoder encoder) {
        try {
            this.closeEncoder.writeType(target, this.encoderState, close);
        }
        finally {
            this.encoderState.reset();
        }
    }
}

