/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.protonj2.client.impl.ClientDelivery;
import org.apache.qpid.protonj2.client.util.DeliveryQueue;

public final class FifoDeliveryQueue
implements DeliveryQueue {
    private static final AtomicIntegerFieldUpdater<FifoDeliveryQueue> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FifoDeliveryQueue.class, "state");
    private static final int CLOSED = 0;
    private static final int STOPPED = 1;
    private static final int RUNNING = 2;
    private volatile int state = 1;
    private int waiters = 0;
    private final Deque<ClientDelivery> queue;

    public FifoDeliveryQueue(int queueDepth) {
        this.queue = new ArrayDeque<ClientDelivery>(Math.max(1, queueDepth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueFirst(ClientDelivery envelope) {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            this.queue.addFirst(envelope);
            if (this.waiters > 0) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(ClientDelivery envelope) {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            this.queue.addLast(envelope);
            if (this.waiters > 0) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientDelivery dequeue(long timeout) throws InterruptedException {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            while (timeout != 0L && this.isRunning() && this.queue.isEmpty()) {
                if (timeout == -1L) {
                    ++this.waiters;
                    try {
                        this.queue.wait();
                        continue;
                    }
                    finally {
                        --this.waiters;
                        continue;
                    }
                }
                long start = System.currentTimeMillis();
                ++this.waiters;
                try {
                    this.queue.wait(timeout);
                }
                finally {
                    --this.waiters;
                }
                timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
            }
            if (!this.isRunning()) {
                return null;
            }
            return this.queue.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientDelivery dequeueNoWait() {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            if (!this.isRunning()) {
                return null;
            }
            return this.queue.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 1, 2)) {
            Deque<ClientDelivery> deque = this.queue;
            synchronized (deque) {
                if (this.waiters > 0) {
                    this.queue.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 2, 1)) {
            Deque<ClientDelivery> deque = this.queue;
            synchronized (deque) {
                if (this.waiters > 0) {
                    this.queue.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (STATE_FIELD_UPDATER.getAndSet(this, 0) > 0) {
            Deque<ClientDelivery> deque = this.queue;
            synchronized (deque) {
                if (this.waiters > 0) {
                    this.queue.notifyAll();
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.state == 2;
    }

    @Override
    public boolean isClosed() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Deque<ClientDelivery> deque = this.queue;
        synchronized (deque) {
            return this.queue.toString();
        }
    }
}

