/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedMapTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonScanningContext;
import org.apache.qpid.protonj2.codec.decoders.ScanningContext;
import org.apache.qpid.protonj2.codec.decoders.StreamScanningContext;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;

public final class ApplicationPropertiesTypeDecoder
extends AbstractDescribedMapTypeDecoder<ApplicationProperties> {
    @Override
    public Class<ApplicationProperties> getTypeClass() {
        return ApplicationProperties.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return ApplicationProperties.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return ApplicationProperties.DESCRIPTOR_SYMBOL;
    }

    @Override
    public ApplicationProperties readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (decoder.isNull()) {
            return new ApplicationProperties(null);
        }
        return new ApplicationProperties(this.readMap(buffer, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public ApplicationProperties[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ApplicationProperties[] result = new ApplicationProperties[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new ApplicationProperties(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new ApplicationProperties(this.readMap(buffer, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    private Map<String, Object> readMap(ProtonBuffer buffer, DecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(buffer, state);
        int count = mapDecoder.readCount(buffer, state);
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        Decoder decoder = state.getDecoder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            map.put(decoder.readString(buffer, state), decoder.readObject(buffer, state));
        }
        return map;
    }

    @Override
    public ApplicationProperties readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (decoder.isNull()) {
            return new ApplicationProperties(null);
        }
        return new ApplicationProperties(this.readMap(stream, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public ApplicationProperties[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ApplicationProperties[] result = new ApplicationProperties[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new ApplicationProperties(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new ApplicationProperties(this.readMap(stream, state, (MapTypeDecoder)ApplicationPropertiesTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    private Map<String, Object> readMap(InputStream stream, StreamDecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(stream, state);
        int count = mapDecoder.readCount(stream, state);
        StreamDecoder decoder = state.getDecoder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            map.put(decoder.readString(stream, state), decoder.readObject(stream, state));
        }
        return map;
    }

    public static ScanningContext<String> createScanContext(String ... keys) {
        return ProtonScanningContext.createStringScanContext(keys);
    }

    public static ScanningContext<String> createScanContext(Collection<String> keys) {
        return ProtonScanningContext.createStringScanContext(keys);
    }

    public static StreamScanningContext<String> createStreamScanContext(String ... keys) {
        return ProtonScanningContext.createStringScanContext(keys);
    }

    public static StreamScanningContext<String> createStreamScanContext(Collection<String> keys) {
        return ProtonScanningContext.createStringScanContext(keys);
    }

    public void scanProperties(ProtonBuffer buffer, DecoderState state, ScanningContext<String> context, BiConsumer<String, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(buffer, state, context, matchConsumer);
    }

    public void scanProperties(InputStream stream, StreamDecoderState state, StreamScanningContext<String> context, BiConsumer<String, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(stream, state, context, matchConsumer);
    }
}

