/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.BindingController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.DestinationController;

public class ExchangeController
extends DestinationController {
    public static final String TYPE = "Exchange";

    ExchangeController(LegacyManagementController legacyManagementController, Set<TypeController> typeControllers) {
        super(legacyManagementController, TYPE, new String[]{"VirtualHost"}, null, typeControllers);
    }

    @Override
    protected LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        return new LegacyExchange(this.getManagementController(), object);
    }

    public static class LegacyExchange
    extends DestinationController.LegacyDestination {
        LegacyExchange(LegacyManagementController managementController, LegacyConfiguredObject nextVersionQueue) {
            super(managementController, nextVersionQueue, ExchangeController.TYPE);
        }

        @Override
        public Collection<LegacyConfiguredObject> getChildren(String category) {
            if ("Binding".equals(category)) {
                Collection bindings = (Collection)this.getAttribute("bindings");
                if (bindings != null) {
                    Map<String, LegacyConfiguredObject> queues = this.getNextVersionLegacyConfiguredObject().getParent("VirtualHost").getChildren("Queue").stream().collect(Collectors.toMap(q -> (String)q.getAttribute("name"), q -> q));
                    return bindings.stream().map(b -> new BindingController.LegacyBinding(this.getManagementController(), this.getNextVersionLegacyConfiguredObject(), (LegacyConfiguredObject)queues.get(b.getName()), b.getBindingKey(), b.getArguments())).collect(Collectors.toList());
                }
                return List.of();
            }
            return super.getChildren(category);
        }
    }
}

