/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The "importNode(importedNode,deep)" method for a
 * Document should import the given importedNode into that Document.
 * The importedNode is of type Document_Fragment.
 * Create a DocumentFragment in a different document.
 * Create a Comment child node for the Document Fragment.
 * Invoke method importNode(importedNode,deep) on this document
 * with importedNode being the newly created DocumentFragment.
 * Method should return a node of type DocumentFragment whose child has
 * comment value "descendant1".
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 */
public class importNode04 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staff", true);
        Document aNewDoc = load("staff", true);
        DocumentFragment docFrag = aNewDoc.createDocumentFragment();
        Comment comment = aNewDoc.createComment("descendant1");
        Node aNode = docFrag.appendChild(comment);
        aNode = doc.importNode(docFrag, true);
        NodeList children = aNode.getChildNodes();
        assertEquals(1, children.getLength(), "throw_Size");
        Node child = aNode.getFirstChild();
        String childValue = child.getNodeValue();
        assertEquals("descendant1", childValue, "descendant1");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/importNode04";
    }

}
