/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ComponentTracer;
import net.sf.saxon.expr.instruct.OnEmptyExpr;
import net.sf.saxon.expr.instruct.OnNonEmptyExpr;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.TransformFn;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.tree.AttributeLocation;

public class XSLTTraceCodeInjector
extends TraceCodeInjector {
    @Override
    protected boolean isApplicable(Expression exp) {
        if (this.traceLevel == 3) {
            return !(exp instanceof TraceExpression) && !(exp instanceof OnEmptyExpr) && !(exp instanceof OnNonEmptyExpr);
        }
        return XSLTTraceCodeInjector.isTraceableExpression(exp);
    }

    public static boolean isTraceableExpression(Expression exp) {
        if (Literal.isEmptySequence(exp)) {
            return false;
        }
        if (exp instanceof OnEmptyExpr || exp instanceof OnNonEmptyExpr) {
            return false;
        }
        Expression parent = exp.getParentExpression();
        if (parent instanceof TraceExpression) {
            parent = parent.getParentExpression();
        }
        if (exp.isCallOn(TransformFn.class)) {
            return true;
        }
        if (parent != null && parent.getLocation() instanceof XPathParser.NestedLocation) {
            return false;
        }
        Location loc = exp.getLocation();
        if (loc instanceof XPathParser.NestedLocation) {
            loc = ((XPathParser.NestedLocation)loc).getContainingLocation();
        }
        if (loc instanceof AttributeLocation) {
            StructuredQName elementName = ((AttributeLocation)loc).getElementName();
            return elementName.hasURI(NamespaceUri.XSLT) && elementName.getLocalPart().equals("sequence");
        }
        return loc != null && loc.getLineNumber() != -1 && (parent == null || loc != parent.getLocation() || parent instanceof Block || parent instanceof ComponentTracer);
    }
}

