/**
 * Copyright (c) 2010 Yahoo! Inc. All rights reserved.                                                                                                                             
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.omid.benchmarks.utils;

/**
 * A generator that is capable of generating ints as well as strings
 *
 * @author cooperb
 *
 */
public abstract class IntegerGenerator extends Generator {
    int lastint;

    /**
     * Set the last value generated. IntegerGenerator subclasses must use this call
     * to properly set the last string value, or the lastString() and lastInt() calls won't work.
     * @param last value
     */
    protected void setLastInt(int last) {
        lastint = last;
    }

    /**
     *  When overriding this method, be sure to call setLastString() properly, or the lastString() call won't work
     * @return Return the next value as an int.
     */
    public abstract int nextInt();

    /**
     * @return Generate the next string in the distribution.
     */
    public String nextString() {
        return "" + nextInt();
    }

    /**
     * @return the previous string generated by the distribution; e.g., returned from the last nextString() call.
     * Calling lastString() should not advance the distribution or have any side effects. If nextString() has not yet
     * been called, lastString() should return something reasonable.
     */
    @Override
    public String lastString() {
        return "" + lastInt();
    }

    /**
     * @return the previous int generated by the distribution. This call is unique to IntegerGenerator subclasses, and assumes
     * IntegerGenerator subclasses always return ints for nextInt() (e.g. not arbitrary strings).
     */
    public int lastInt() {
        return lastint;
    }

    /**
     * @return the expected value (mean) of the values this generator will return.
     */
    public abstract double mean();
}
