/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import java.util.HashMap;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.tree.ClassNode;

public class EnhancementProject {
    private HashMap<String, ClassNodeTracker> classNodeTrackers = new HashMap();

    public boolean containsClass(String type) {
        return this.classNodeTrackers.containsKey(type);
    }

    public ClassNodeTracker loadClass(String name) {
        return this.loadClass(name, null);
    }

    public ClassNodeTracker loadClass(Class<?> type) {
        return this.loadClass(type.getName(), type.getClassLoader());
    }

    public ClassNodeTracker loadClass(String name, ClassLoader loader) {
        ClassNode classNode;
        ClassNodeTracker cached = this.classNodeTrackers.get(name);
        if (cached != null) {
            return cached;
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            classNode = AsmHelper.readClassNode(loader, name);
        }
        catch (ClassNotFoundException e) {
            classNode = new ClassNode(589824);
            classNode.version = this.detectJavaBytecodeVersion();
            classNode.name = name.replace(".", "/");
            classNode.access = 1;
            classNode.superName = "java/lang/Object";
        }
        ClassNodeTracker cnt = new ClassNodeTracker(this, classNode, loader);
        return cnt;
    }

    private int detectJavaBytecodeVersion() {
        return JavaVersions.VERSION + 44;
    }

    public ClassNodeTracker loadClass(byte[] bytes, ClassLoader loader) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, AsmHelper.ATTRS, 0);
        ClassNodeTracker cnt = new ClassNodeTracker(this, classNode, loader);
        return cnt;
    }

    public void clear() {
        this.classNodeTrackers.clear();
    }

    void putClass(String name, ClassNodeTracker cnt) {
        this.classNodeTrackers.put(name, cnt);
    }
}

