/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.AttributeTranslator;
import org.apache.openjpa.enhance.DynamicPersistenceCapable;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PCSubclassValidator;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.Services;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.util.git.GitUtils;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.BigDecimalId;
import org.apache.openjpa.util.BigIntegerId;
import org.apache.openjpa.util.ByteId;
import org.apache.openjpa.util.CharId;
import org.apache.openjpa.util.DateId;
import org.apache.openjpa.util.DoubleId;
import org.apache.openjpa.util.FloatId;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ShortId;
import org.apache.openjpa.util.StringId;
import org.apache.openjpa.util.UserException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.BytecodeWriter;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.openjpa.util.asm.RedefinedAttribute;
import org.apache.xbean.asm9.Attribute;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.AbstractInsnNode;
import org.apache.xbean.asm9.tree.AnnotationNode;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.FieldNode;
import org.apache.xbean.asm9.tree.IincInsnNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.IntInsnNode;
import org.apache.xbean.asm9.tree.JumpInsnNode;
import org.apache.xbean.asm9.tree.LabelNode;
import org.apache.xbean.asm9.tree.LookupSwitchInsnNode;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.TableSwitchInsnNode;
import org.apache.xbean.asm9.tree.TypeInsnNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

public class PCEnhancer {
    public static final int ENHANCER_VERSION;
    public static final int ENHANCE_NONE = 0;
    public static final int ENHANCE_AWARE = 2;
    public static final int ENHANCE_INTERFACE = 4;
    public static final int ENHANCE_PC = 8;
    public static final String PRE = "pc";
    public static final String ISDETACHEDSTATEDEFINITIVE = "pcisDetachedStateDefinitive";
    private static final Class<?> PCTYPE;
    private static final Type TYPE_PCTYPE;
    private static final String SM = "pcStateManager";
    private static final Class<?> SMTYPE;
    private static final String INHERIT = "pcInheritedFieldCount";
    private static final String CONTEXTNAME = "GenericContext";
    private static final Class<?> USEREXCEP;
    private static final Class<?> INTERNEXCEP;
    private static final Class<?> HELPERTYPE;
    private static final String SUPER = "pcPCSuperclass";
    private static final Class OIDFSTYPE;
    private static final Class<?> OIDFCTYPE;
    private static final String VERSION_INIT_STR = "pcVersionInit";
    private static final Localizer _loc;
    private static final AuxiliaryEnhancer[] _auxEnhancers;
    private static final Method LONG_VALUE_OF;
    private final MetaDataRepository _repos;
    private final ClassMetaData _meta;
    private final Log _log;
    boolean _addVersionInitFlag = true;
    private final EnhancementProject project;
    private final ClassNodeTracker managedType;
    private ClassNodeTracker pc;
    private boolean _defCons = true;
    private boolean _redefine = false;
    private boolean _subclass = false;
    private boolean _fail = false;
    private Set _violations = null;
    private File _dir = null;
    private BytecodeWriter _writer = null;
    private Map<String, String> _backingFields = null;
    private Map<String, String> _attrsToFields = null;
    private Map<String, String> _fieldsToAttrs = null;
    private boolean _isAlreadyRedefined = false;
    private boolean _isAlreadySubclassed = false;
    private boolean _bcsConfigured = false;
    private boolean _optimizeIdCopy = false;

    public PCEnhancer(OpenJPAConfiguration conf, Class<?> type) {
        this(conf, new EnhancementProject().loadClass(type), (MetaDataRepository)null);
    }

    public PCEnhancer(OpenJPAConfiguration conf, ClassMetaData meta) {
        this(conf, new EnhancementProject().loadClass(meta.getDescribedType()), meta.getRepository());
    }

    @Deprecated
    public PCEnhancer(OpenJPAConfiguration conf, ClassNodeTracker type, MetaDataRepository repos) {
        this(conf, type, repos, null);
    }

    public PCEnhancer(OpenJPAConfiguration conf, ClassNodeTracker type, MetaDataRepository repos, ClassLoader loader) {
        this.project = type.getProject();
        this.pc = this.managedType = type;
        this._log = conf.getLog("openjpa.Enhance");
        if (repos == null) {
            this._repos = conf.newMetaDataRepositoryInstance();
            this._repos.setSourceMode(1);
        } else {
            this._repos = repos;
        }
        this._meta = this._repos.getMetaData(type.getType(), loader, false);
        this.configureOptimizeIdCopy();
    }

    public PCEnhancer(MetaDataRepository repos, ClassNodeTracker type, ClassMetaData meta) {
        this.project = type.getProject();
        this.pc = this.managedType = type;
        this._log = repos.getConfiguration().getLog("openjpa.Enhance");
        this._repos = repos;
        this._meta = meta;
    }

    static String toPCSubclassName(ClassNodeTracker cnt) {
        return ClassUtil.getPackageName(PCEnhancer.class) + "." + cnt.getClassNode().name.replace('/', '$') + "$pcsubclass";
    }

    @Deprecated
    static String toPCSubclassName(Class cls) {
        return ClassUtil.getPackageName(PCEnhancer.class) + "." + cls.getName().replace('.', '$') + "$pcsubclass";
    }

    public static boolean isPCSubclassName(String className) {
        return className.startsWith(ClassUtil.getPackageName(PCEnhancer.class)) && className.endsWith("$pcsubclass");
    }

    public static String toManagedTypeName(String className) {
        if (PCEnhancer.isPCSubclassName(className)) {
            className = className.substring(ClassUtil.getPackageName(PCEnhancer.class).length() + 1);
            className = className.substring(0, className.lastIndexOf("$"));
            className = className.replace('$', '.');
        }
        return className;
    }

    public ClassNodeTracker getPCBytecode() {
        return this.pc;
    }

    public ClassNodeTracker getManagedTypeBytecode() {
        return this.managedType;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public boolean getAddDefaultConstructor() {
        return this._defCons;
    }

    public void setAddDefaultConstructor(boolean addDefaultConstructor) {
        this._defCons = addDefaultConstructor;
    }

    public boolean getRedefine() {
        return this._redefine;
    }

    public void setRedefine(boolean redefine) {
        this._redefine = redefine;
    }

    public boolean isAlreadyRedefined() {
        return this._isAlreadyRedefined;
    }

    public boolean isAlreadySubclassed() {
        return this._isAlreadySubclassed;
    }

    public boolean getCreateSubclass() {
        return this._subclass;
    }

    public void setCreateSubclass(boolean subclass) {
        this._subclass = subclass;
        this._addVersionInitFlag = false;
    }

    public boolean getEnforcePropertyRestrictions() {
        return this._fail;
    }

    public void setEnforcePropertyRestrictions(boolean fail) {
        this._fail = fail;
    }

    public File getDirectory() {
        return this._dir;
    }

    public void setDirectory(File dir) {
        this._dir = dir;
    }

    public BytecodeWriter getBytecodeWriter() {
        return this._writer;
    }

    public void setBytecodeWriter(BytecodeWriter writer) {
        this._writer = writer;
    }

    public int run() {
        try {
            if ((this.managedType.getClassNode().access & 0x4000) > 0) {
                return 0;
            }
            if ((this.managedType.getClassNode().access & 0x200) > 0) {
                return 4;
            }
            ClassLoader loader = this.managedType.getClassLoader();
            for (String iface : this.managedType.getClassNode().interfaces) {
                String pctypeInternalName;
                if (!iface.equals(pctypeInternalName = TYPE_PCTYPE.getInternalName())) continue;
                if (this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("pc-type", this.managedType.getClassNode().name, loader));
                }
                return 0;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("enhance-start", this.managedType.getClassNode().name));
            }
            this.configureBCs();
            if (this.isPropertyAccess(this._meta)) {
                this.validateProperties();
                if (this.getCreateSubclass()) {
                    this.addAttributeTranslation();
                }
            }
            this.replaceAndValidateFieldAccess();
            this.processViolations();
            if (this._meta != null) {
                this.enhanceClass(this.pc);
                this.addFields(this.pc);
                this.addStaticInitializer(this.pc);
                this.addPCMethods();
                this.addAccessors(this.pc);
                this.addAttachDetachCode();
                this.addSerializationCode();
                this.addCloningCode();
                this.runAuxiliaryEnhancers();
                return 8;
            }
            return 2;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(_loc.get("enhance-error", this.managedType.getClassNode().name, e.getMessage()), (Throwable)e);
        }
    }

    private void configureBCs() {
        if (!this._bcsConfigured) {
            if (this.getRedefine()) {
                boolean isRedefined;
                boolean bl = isRedefined = this.managedType.getClassNode().attrs != null && this.managedType.getClassNode().attrs.stream().anyMatch(a -> a.isUnknown() && a.type.equals("org/apache/openjpa/Redefined"));
                if (!isRedefined) {
                    if (this.managedType.getClassNode().attrs == null) {
                        this.managedType.getClassNode().attrs = new ArrayList<Attribute>();
                    }
                    this.managedType.getClassNode().attrs.add(new RedefinedAttribute());
                } else {
                    this._isAlreadyRedefined = true;
                }
            }
            if (this.getCreateSubclass()) {
                PCSubclassValidator val = new PCSubclassValidator(this._meta, this.managedType.getClassNode(), this._log, this._fail);
                val.assertCanSubclass();
                this.pc = this.project.loadClass(PCEnhancer.toPCSubclassName(this.managedType));
                if (this.pc.getClassNode().superName.equals("java/lang/Object")) {
                    this.pc.getClassNode().superName = this.managedType.getClassNode().name;
                    if ((this.managedType.getClassNode().access & 0x400) > 0) {
                        this.pc.getClassNode().access |= 0x400;
                    }
                    this.pc.declareInterface(DynamicPersistenceCapable.class);
                } else {
                    this._isAlreadySubclassed = true;
                }
            }
            this._bcsConfigured = true;
        }
    }

    public void record() throws IOException {
        if (this.managedType != this.pc && this.getRedefine()) {
            this.record(this.managedType);
        }
        this.record(this.pc);
    }

    private void record(ClassNodeTracker cnt) throws IOException {
        if (this._writer != null) {
            this._writer.write(cnt);
        } else if (this._dir == null) {
            String name = cnt.getClassNode().name.replace(".", "/");
            ClassLoader cl = cnt.getClassLoader();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            URL resource = cl.getResource(name + ".class");
            try (FileOutputStream out = new FileOutputStream(URLDecoder.decode(resource.getFile()));){
                ((OutputStream)out).write(AsmHelper.toByteArray(cnt));
                out.flush();
            }
        } else {
            String name = cnt.getClassNode().name.replace(".", "/") + ".class";
            File targetFile = new File(this._dir, name);
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            Files.write(targetFile.toPath(), AsmHelper.toByteArray(cnt), new OpenOption[0]);
        }
    }

    private void validateProperties() {
        ClassNode classNode = this.managedType.getClassNode();
        FieldMetaData[] fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        Field assigned = null;
        for (FieldMetaData fmd : fmds) {
            Method setter;
            if (!(fmd.getBackingMember() instanceof Method)) {
                if (this._meta.isMixedAccess()) continue;
                this.addViolation("property-bad-member", new Object[]{fmd, fmd.getBackingMember()}, true);
                continue;
            }
            Method getter = (Method)fmd.getBackingMember();
            if (getter == null) {
                this.addViolation("property-no-getter", new Object[]{fmd}, true);
                continue;
            }
            Field returned = PCEnhancer.getReturnedField(classNode, getter);
            if (returned != null) {
                this.registerBackingFieldInfo(fmd, getter, returned);
            }
            if ((setter = PCEnhancer.getMethod(getter.getDeclaringClass(), PCEnhancer.getSetterName(fmd), fmd.getDeclaredType())) == null) {
                if (returned == null) {
                    this.addViolation("property-no-setter", new Object[]{fmd}, true);
                    continue;
                }
                if (!this.getRedefine()) {
                    MethodNode setterNode = new MethodNode(2, PCEnhancer.getSetterName(fmd), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(fmd.getDeclaredType())), null, null);
                    this.pc.getClassNode().methods.add(setterNode);
                    InsnList instructions = setterNode.instructions;
                    instructions.add(new VarInsnNode(25, 0));
                    instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(fmd.getDeclaredType()), 1));
                    instructions.add(new FieldInsnNode(181, Type.getInternalName(returned.getDeclaringClass()), returned.getName(), Type.getDescriptor(fmd.getDeclaredType())));
                    instructions.add(new InsnNode(177));
                }
            }
            if (setter != null) {
                assigned = PCEnhancer.getAssignedField(classNode, PCEnhancer.getMethod(fmd.getDeclaringType(), fmd.getSetterName(), fmd.getDeclaredType()));
            }
            if (assigned == null) continue;
            if (setter != null) {
                this.registerBackingFieldInfo(fmd, setter, assigned);
            }
            if (assigned.equals(returned)) continue;
            this.addViolation("property-setter-getter-mismatch", new Object[]{fmd, assigned.getName(), returned == null ? null : returned.getName()}, false);
        }
    }

    private void registerBackingFieldInfo(FieldMetaData fmd, Method method, Field field) {
        if (this._backingFields == null) {
            this._backingFields = new HashMap<String, String>();
        }
        this._backingFields.put(method.getName(), field.getName());
        if (this._attrsToFields == null) {
            this._attrsToFields = new HashMap<String, String>();
        }
        this._attrsToFields.put(fmd.getName(), field.getName());
        if (this._fieldsToAttrs == null) {
            this._fieldsToAttrs = new HashMap<String, String>();
        }
        this._fieldsToAttrs.put(field.getName(), fmd.getName());
    }

    private void addAttributeTranslation() {
        ArrayList<Integer> propFmds = new ArrayList<Integer>();
        FieldMetaData[] fmds = this._meta.getFields();
        if (this._meta.isMixedAccess()) {
            propFmds = new ArrayList();
            for (int i = 0; i < fmds.length; ++i) {
                if (!this.isPropertyAccess(fmds[i])) continue;
                propFmds.add(i);
            }
            if (propFmds.size() == 0) {
                return;
            }
        }
        ClassNode classNode = this.pc.getClassNode();
        classNode.interfaces.add(Type.getInternalName(AttributeTranslator.class));
        MethodNode attrIdxMeth = new MethodNode(1, "pcAttributeIndexToFieldName", Type.getMethodDescriptor(Type.getType(String.class), Type.INT_TYPE), null, null);
        classNode.methods.add(attrIdxMeth);
        InsnList instructions = attrIdxMeth.instructions;
        instructions.add(new VarInsnNode(21, 1));
        if (!this._meta.isMixedAccess()) {
            LabelNode defLbl = new LabelNode();
            TableSwitchInsnNode switchNd = new TableSwitchInsnNode(0, fmds.length - 1, defLbl, new LabelNode[0]);
            instructions.add(switchNd);
            for (FieldMetaData fmd : fmds) {
                LabelNode caseLabel = new LabelNode();
                switchNd.labels.add(caseLabel);
                instructions.add(caseLabel);
                instructions.add(AsmHelper.getLoadConstantInsn(this._attrsToFields.get(fmd.getName())));
                instructions.add(new InsnNode(176));
            }
            instructions.add(defLbl);
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        } else {
            LabelNode defLbl = new LabelNode();
            LookupSwitchInsnNode switchNd = new LookupSwitchInsnNode(defLbl, null, null);
            instructions.add(switchNd);
            for (Integer i : propFmds) {
                LabelNode caseLabel = new LabelNode();
                instructions.add(caseLabel);
                switchNd.labels.add(caseLabel);
                switchNd.keys.add((Integer)propFmds.get(i));
                instructions.add(AsmHelper.getLoadConstantInsn(this._attrsToFields.get(fmds[i].getName())));
                instructions.add(new InsnNode(176));
            }
        }
    }

    private static String getSetterName(FieldMetaData fmd) {
        return fmd.getSetterName();
    }

    static Field getReturnedField(ClassNode classNode, Method meth) {
        return PCEnhancer.findField(classNode, meth, ain -> ain.getOpcode() == AsmHelper.getReturnInsn(meth.getReturnType()), false);
    }

    static Field getAssignedField(ClassNode classNode, Method meth) {
        return PCEnhancer.findField(classNode, meth, ain -> ain.getOpcode() == 181, true);
    }

    private static Field findField(ClassNode classNode, Method meth, Predicate<AbstractInsnNode> ain, boolean findAccessed) {
        if (Modifier.isStatic(meth.getModifiers())) {
            return null;
        }
        if (meth.getDeclaringClass().isInterface()) {
            return null;
        }
        MethodNode methodNode = PCEnhancer.findMethodNode(classNode, meth);
        Field field = null;
        for (AbstractInsnNode insn : methodNode.instructions) {
            Field cur;
            FieldInsnNode fieldInsn;
            if (!ain.test(insn)) continue;
            AbstractInsnNode prevInsn = insn.getPrevious();
            if (prevInsn == null) {
                return null;
            }
            if ((prevInsn.getOpcode() == 193 || prevInsn.getOpcode() == 192) && prevInsn.getPrevious() != null) {
                prevInsn = prevInsn.getPrevious();
            }
            if (prevInsn.getPrevious() == null) {
                return null;
            }
            AbstractInsnNode earlierInsn = prevInsn.getPrevious();
            if (!AsmHelper.isLoadInsn(earlierInsn) || !AsmHelper.isThisInsn(earlierInsn)) {
                return null;
            }
            if (!findAccessed && prevInsn.getOpcode() == 180) {
                fieldInsn = (FieldInsnNode)prevInsn;
                cur = PCEnhancer.getField(meth.getDeclaringClass(), fieldInsn.name);
            } else if (findAccessed && AsmHelper.isLoadInsn(prevInsn) && ((VarInsnNode)prevInsn).var == 1) {
                fieldInsn = (FieldInsnNode)insn;
                cur = PCEnhancer.getField(meth.getDeclaringClass(), fieldInsn.name);
            } else {
                return null;
            }
            if (field != null && !cur.equals(field)) {
                return null;
            }
            field = cur;
        }
        return field;
    }

    private static MethodNode findMethodNode(ClassNode classNode, Method meth) {
        return AsmHelper.getMethodNode(classNode, meth).get();
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == Object.class) {
                throw new IllegalStateException("Cannot find field " + fieldName + " in Class " + clazz);
            }
            return PCEnhancer.getField(clazz.getSuperclass(), fieldName);
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() == Object.class) {
                throw new IllegalStateException("Cannot find method " + methodName + " in Class " + clazz);
            }
            return PCEnhancer.getMethod(clazz.getSuperclass(), methodName, new Class[0]);
        }
    }

    private void addViolation(String key, Object[] args, boolean fatal) {
        if (this._violations == null) {
            this._violations = new HashSet();
        }
        this._violations.add(_loc.get(key, args));
        this._fail |= fatal;
    }

    private void processViolations() {
        if (this._violations == null) {
            return;
        }
        String sep = J2DoPrivHelper.getLineSeparator();
        StringBuilder buf = new StringBuilder();
        Iterator itr = this._violations.iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(sep);
        }
        Localizer.Message msg = _loc.get("property-violations", buf);
        if (this._fail) {
            throw new UserException(msg);
        }
        if (this._log.isWarnEnabled()) {
            this._log.warn(msg);
        }
    }

    private void replaceAndValidateFieldAccess() throws NoSuchMethodException, ClassNotFoundException {
        ClassNode classNode = this.pc.getClassNode();
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.instructions.size() <= 0 || this.skipEnhance(methodNode)) continue;
            this.replaceAndValidateFieldAccess(classNode, methodNode, a -> a.getOpcode() == 180, true);
            this.replaceAndValidateFieldAccess(classNode, methodNode, a -> a.getOpcode() == 181, false);
        }
    }

    private void replaceAndValidateFieldAccess(ClassNode classNode, MethodNode methodNode, Predicate<AbstractInsnNode> insnCheck, boolean get) throws NoSuchMethodException, ClassNotFoundException {
        AbstractInsnNode currentInsn = methodNode.instructions.getFirst();
        while ((currentInsn = this.searchNextInstruction(currentInsn, insnCheck)) != null) {
            FieldMetaData fmd;
            FieldInsnNode fi = (FieldInsnNode)currentInsn;
            String name = fi.name;
            ClassMetaData owner = null;
            if (fi.owner != null) {
                Class<?> declarerType = AsmHelper.getDescribedClass(this.managedType.getClassLoader(), fi.owner);
                owner = this.getPersistenceCapableOwner(name, declarerType);
            }
            FieldMetaData fieldMetaData = fmd = owner == null ? null : owner.getField(name);
            if (this.isPropertyAccess(fmd)) {
                if (owner != this._meta && owner.getDeclaredField(name) != null && this._meta != null && !owner.getDescribedType().isAssignableFrom(this._meta.getDescribedType())) {
                    throw new UserException(_loc.get("property-field-access", new Object[]{this._meta, owner, name, methodNode.name}));
                }
                if (this.isBackingFieldOfAnotherProperty(methodNode, name)) {
                    this.addViolation("property-field-access", new Object[]{this._meta, owner, name, methodNode.name}, false);
                }
            }
            if (owner != null && owner.getDeclaredField(this.fromBackingFieldName(name)) != null) {
                if (!this.getRedefine() && !this.getCreateSubclass() && this.isFieldAccess(fmd)) {
                    Type ownerType = Type.getType(this.getType(owner));
                    MethodInsnNode pcCall = get ? new MethodInsnNode(184, ownerType.getInternalName(), "pcGet" + name, Type.getMethodDescriptor(Type.getType(fi.desc), ownerType)) : new MethodInsnNode(184, ownerType.getInternalName(), "pcSet" + name, Type.getMethodDescriptor(Type.VOID_TYPE, ownerType, Type.getType(fi.desc)));
                    methodNode.instructions.insertBefore(currentInsn, pcCall);
                    methodNode.instructions.remove(currentInsn);
                    currentInsn = pcCall;
                } else if (this.getRedefine()) {
                    name = this.fromBackingFieldName(name);
                    if (get) {
                        this.addNotifyAccess(methodNode, currentInsn, owner.getField(name));
                    } else {
                        int valVarPos;
                        InsnList insns = new InsnList();
                        insns.add(new VarInsnNode(25, 0));
                        ++methodNode.maxLocals;
                        insns.add(new VarInsnNode(AsmHelper.getCorrespondingLoadInsn(fi.getOpcode()), valVarPos));
                        currentInsn = this.addNotifyMutation(classNode, methodNode, currentInsn, owner.getField(name), valVarPos, -1);
                    }
                }
            }
            currentInsn = currentInsn.getNext();
        }
    }

    private AbstractInsnNode searchNextInstruction(AbstractInsnNode currentInsn, Predicate<AbstractInsnNode> insnCheck) {
        while (currentInsn != null && !insnCheck.test(currentInsn)) {
            currentInsn = currentInsn.getNext();
        }
        return currentInsn;
    }

    private void addNotifyAccess(MethodNode methodNode, AbstractInsnNode currentInsn, FieldMetaData fmd) {
        InsnList insns = new InsnList();
        insns.add(new VarInsnNode(25, 0));
        insns.add(AsmHelper.getLoadConstantInsn(fmd.getIndex()));
        insns.add(new MethodInsnNode(184, Type.getInternalName(RedefinitionHelper.class), "accessingField", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.INT_TYPE)));
        if (methodNode.instructions.size() == 0) {
            methodNode.instructions.add(insns);
        } else {
            methodNode.instructions.insertBefore(currentInsn, insns);
        }
    }

    private AbstractInsnNode addNotifyMutation(ClassNode classNode, MethodNode methodNode, AbstractInsnNode currentInsn, FieldMetaData fmd, int valVarPos, int param) {
        InsnList insns = new InsnList();
        insns.add(new VarInsnNode(25, 0));
        insns.add(AsmHelper.getLoadConstantInsn(fmd.getIndex()));
        Class<Object> type = fmd.getDeclaredType();
        if (!type.isPrimitive() && type != String.class) {
            type = Object.class;
        }
        insns.add(new VarInsnNode(AsmHelper.getLoadInsn(type), valVarPos));
        if (param == -1) {
            insns.add(new VarInsnNode(25, 0));
            this.addGetManagedValueCode(classNode, insns, fmd, true);
        } else {
            insns.add(new VarInsnNode(AsmHelper.getLoadInsn(type), param + 1));
        }
        insns.add(new MethodInsnNode(184, Type.getInternalName(RedefinitionHelper.class), "settingField", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.INT_TYPE, Type.getType(type), Type.getType(type))));
        methodNode.instructions.insert(currentInsn, insns);
        return insns.getLast();
    }

    private boolean isBackingFieldOfAnotherProperty(MethodNode methodNode, String name) {
        String methName = methodNode.name;
        return !"<init>".equals(methName) && this._backingFields != null && !name.equals(this._backingFields.get(methName)) && this._backingFields.containsValue(name);
    }

    private ClassMetaData getPersistenceCapableOwner(String fieldName, Class owner) {
        Field f = Reflection.findField(owner, fieldName, false);
        if (f == null) {
            return null;
        }
        if (this._meta != null && this._meta.getDescribedType().isInterface()) {
            return this._meta;
        }
        return this._repos.getMetaData(f.getDeclaringClass(), null, false);
    }

    private void addPCMethods() throws NoSuchMethodException {
        this.addClearFieldsMethod(this.pc.getClassNode());
        this.addNewInstanceMethod(this.pc.getClassNode(), true);
        this.addNewInstanceMethod(this.pc.getClassNode(), false);
        this.addManagedFieldCountMethod(this.pc.getClassNode());
        this.addReplaceFieldsMethods(this.pc.getClassNode());
        this.addProvideFieldsMethods(this.pc.getClassNode());
        this.addCopyFieldsMethod(this.pc.getClassNode());
        if (this._meta.getPCSuperclass() == null || this.getCreateSubclass()) {
            this.addStockMethods();
            this.addGetVersionMethod();
            this.addReplaceStateManagerMethod();
            if (this._meta.getIdentityType() != 2) {
                this.addNoOpApplicationIdentityMethods();
            }
        }
        if (this._meta.getIdentityType() == 2 && (this._meta.getPCSuperclass() == null || this.getCreateSubclass() || this._meta.getObjectIdType() != this._meta.getPCSuperclassMetaData().getObjectIdType())) {
            this.addCopyKeyFieldsToObjectIdMethod(true);
            this.addCopyKeyFieldsToObjectIdMethod(false);
            this.addCopyKeyFieldsFromObjectIdMethod(true);
            this.addCopyKeyFieldsFromObjectIdMethod(false);
            if (this._meta.hasAbstractPKField()) {
                this.addGetIDOwningClass();
            }
            if (this._meta.isEmbeddable() && this._meta.getIdentityType() == 2) {
                this._log.warn(_loc.get("ID-field-in-embeddable-unsupported", this._meta.toString()));
            }
            this.addNewObjectIdInstanceMethod(true);
            this.addNewObjectIdInstanceMethod(false);
        } else if (this._meta.hasPKFieldsFromAbstractClass()) {
            this.addGetIDOwningClass();
        }
    }

    private void addClearFieldsMethod(ClassNode classNode) throws NoSuchMethodException {
        FieldMetaData[] fmds;
        MethodNode clearFieldMethod = new MethodNode(4, "pcClearFields", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        classNode.methods.add(clearFieldMethod);
        InsnList instructions = clearFieldMethod.instructions;
        if (this._meta.getPCSuperclass() != null && !this.getCreateSubclass()) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(this.getType(this._meta.getPCSuperclassMetaData())), "pcClearFields", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
        }
        block6: for (FieldMetaData fmd : fmds = this._meta.getDeclaredFields()) {
            if (fmd.getManagement() != 3) continue;
            instructions.add(new VarInsnNode(25, 0));
            switch (fmd.getDeclaredTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: {
                    instructions.add(this.getSetValueInsns(classNode, fmd, 0));
                    continue block6;
                }
                case 3: {
                    instructions.add(this.getSetValueInsns(classNode, fmd, 0.0));
                    continue block6;
                }
                case 4: {
                    instructions.add(this.getSetValueInsns(classNode, fmd, Float.valueOf(0.0f)));
                    continue block6;
                }
                case 6: {
                    instructions.add(this.getSetValueInsns(classNode, fmd, 0L));
                    continue block6;
                }
                default: {
                    instructions.add(this.getSetValueInsns(classNode, fmd, null));
                }
            }
        }
        instructions.add(new InsnNode(177));
    }

    private void addNewInstanceMethod(ClassNode classNode, boolean oid) {
        String desc = oid ? Type.getMethodDescriptor(Type.getType(PCTYPE), Type.getType(SMTYPE), AsmHelper.TYPE_OBJECT, Type.BOOLEAN_TYPE) : Type.getMethodDescriptor(Type.getType(PCTYPE), Type.getType(SMTYPE), Type.BOOLEAN_TYPE);
        MethodNode newInstance = new MethodNode(1, "pcNewInstance", desc, null, null);
        classNode.methods.add(newInstance);
        InsnList instructions = newInstance.instructions;
        if ((this.pc.getClassNode().access & 0x400) > 0) {
            instructions.add(AsmHelper.throwException(USEREXCEP));
            return;
        }
        instructions.add(new TypeInsnNode(187, classNode.name));
        instructions.add(new InsnNode(89));
        instructions.add(new MethodInsnNode(183, classNode.name, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
        int newPcVarPos = oid ? 4 : 3;
        instructions.add(new VarInsnNode(58, newPcVarPos));
        instructions.add(new VarInsnNode(21, oid ? 3 : 2));
        LabelNode labelAfterClearFields = new LabelNode();
        instructions.add(new JumpInsnNode(153, labelAfterClearFields));
        instructions.add(new VarInsnNode(25, newPcVarPos));
        instructions.add(new MethodInsnNode(182, classNode.name, "pcClearFields", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
        instructions.add(labelAfterClearFields);
        instructions.add(new VarInsnNode(25, newPcVarPos));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new FieldInsnNode(181, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        if (oid) {
            instructions.add(new VarInsnNode(25, newPcVarPos));
            instructions.add(new VarInsnNode(25, 2));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcCopyKeyFieldsFromObjectId", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT)));
        }
        instructions.add(new VarInsnNode(25, newPcVarPos));
        instructions.add(new InsnNode(176));
    }

    private void addManagedFieldCountMethod(ClassNode classNode) {
        MethodNode getFieldCountMeth = new MethodNode(12, "pcGetManagedFieldCount", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), null, null);
        classNode.methods.add(getFieldCountMeth);
        InsnList instructions = getFieldCountMeth.instructions;
        instructions.add(AsmHelper.getLoadConstantInsn(this._meta.getDeclaredFields().length));
        if (this._meta.getPCSuperclass() != null) {
            Class superClass = this.getType(this._meta.getPCSuperclassMetaData());
            String superName = this.getCreateSubclass() ? PCEnhancer.toPCSubclassName(superClass).replace(".", "/") : Type.getInternalName(superClass);
            instructions.add(new MethodInsnNode(184, superName, "pcGetManagedFieldCount", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0])));
            instructions.add(new InsnNode(96));
        }
        instructions.add(new InsnNode(172));
    }

    private void addProvideFieldsMethods(ClassNode classNode) throws NoSuchMethodException {
        FieldMetaData[] fmds;
        MethodNode provideFieldsMeth = new MethodNode(1, "pcProvideField", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE), null, null);
        classNode.methods.add(provideFieldsMeth);
        InsnList instructions = provideFieldsMeth.instructions;
        int relLocal = this.beginSwitchMethod(classNode, "pcProvideField", instructions, false);
        FieldMetaData[] fieldMetaDataArray = fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        } else {
            instructions.add(new VarInsnNode(21, relLocal));
            LabelNode defaultCase = new LabelNode();
            TableSwitchInsnNode ts = new TableSwitchInsnNode(0, fmds.length - 1, defaultCase, new LabelNode[0]);
            instructions.add(ts);
            for (FieldMetaData fmd : fmds) {
                LabelNode caseLabel = new LabelNode();
                instructions.add(caseLabel);
                ts.labels.add(caseLabel);
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                Method smProvidedMeth = this.getStateManagerMethod(fmd.getDeclaredType(), "provided", false, false);
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new VarInsnNode(21, 1));
                instructions.add(new VarInsnNode(25, 0));
                this.addGetManagedValueCode(classNode, instructions, fmd, true);
                instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), smProvidedMeth.getName(), Type.getMethodDescriptor(smProvidedMeth)));
                instructions.add(new InsnNode(177));
            }
            instructions.add(defaultCase);
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        }
        this.addMultipleFieldsMethodVersion(classNode, provideFieldsMeth, false);
    }

    private void addReplaceFieldsMethods(ClassNode classNode) throws NoSuchMethodException {
        FieldMetaData[] fmds;
        MethodNode replaceFieldMeth = new MethodNode(1, "pcReplaceField", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE), null, null);
        classNode.methods.add(replaceFieldMeth);
        InsnList instructions = replaceFieldMeth.instructions;
        int relLocal = this.beginSwitchMethod(classNode, "pcReplaceField", instructions, false);
        FieldMetaData[] fieldMetaDataArray = fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        } else {
            instructions.add(new VarInsnNode(21, relLocal));
            LabelNode defaultCase = new LabelNode();
            TableSwitchInsnNode ts = new TableSwitchInsnNode(0, fmds.length - 1, defaultCase, new LabelNode[0]);
            instructions.add(ts);
            for (FieldMetaData fmd : fmds) {
                LabelNode caseLabel = new LabelNode();
                instructions.add(caseLabel);
                ts.labels.add(caseLabel);
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new VarInsnNode(21, 1));
                Method rmReplaceMeth = this.getStateManagerMethod(fmd.getDeclaredType(), "replace", true, false);
                instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), rmReplaceMeth.getName(), Type.getMethodDescriptor(rmReplaceMeth)));
                if (!fmd.getDeclaredType().isPrimitive()) {
                    instructions.add(new TypeInsnNode(192, Type.getInternalName(fmd.getDeclaredType())));
                }
                this.addSetManagedValueCode(classNode, instructions, fmd);
                if (this._addVersionInitFlag && fmd.isVersion()) {
                    instructions.add(new VarInsnNode(25, 0));
                    instructions.add(new InsnNode(4));
                    this.putfield(classNode, instructions, this.getType(this._meta), VERSION_INIT_STR, Boolean.TYPE);
                }
                instructions.add(new InsnNode(177));
            }
            instructions.add(defaultCase);
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        }
        this.addMultipleFieldsMethodVersion(classNode, replaceFieldMeth, false);
    }

    private void addCopyFieldsMethod(ClassNode classNode) {
        FieldMetaData[] fmds;
        MethodNode copyFieldMeth = new MethodNode(4, "pcCopyField", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getObjectType(this.managedType.getClassNode().name), Type.INT_TYPE), null, null);
        classNode.methods.add(copyFieldMeth);
        InsnList instructions = copyFieldMeth.instructions;
        int relLocal = this.beginSwitchMethod(classNode, "pcCopyField", instructions, true);
        FieldMetaData[] fieldMetaDataArray = fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        if (fmds.length == 0) {
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        } else {
            instructions.add(new VarInsnNode(21, relLocal));
            LabelNode defaultCase = new LabelNode();
            TableSwitchInsnNode ts = new TableSwitchInsnNode(0, fmds.length - 1, defaultCase, new LabelNode[0]);
            instructions.add(ts);
            for (FieldMetaData fmd : fmds) {
                LabelNode caseLabel = new LabelNode();
                instructions.add(caseLabel);
                ts.labels.add(caseLabel);
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new VarInsnNode(25, 1));
                this.addGetManagedValueCode(classNode, instructions, fmd, false);
                this.addSetManagedValueCode(classNode, instructions, fmd);
                instructions.add(new InsnNode(177));
            }
            instructions.add(defaultCase);
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        }
        this.addMultipleFieldsMethodVersion(classNode, copyFieldMeth, true);
    }

    private int beginSwitchMethod(ClassNode classNode, String name, InsnList instructions, boolean copy) {
        int fieldNumber = copy ? 2 : 1;
        int relLocal = fieldNumber + 1;
        if (this.getCreateSubclass()) {
            instructions.add(new VarInsnNode(21, fieldNumber));
            instructions.add(new VarInsnNode(54, relLocal));
            return relLocal;
        }
        instructions.add(new VarInsnNode(21, fieldNumber));
        instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
        instructions.add(new InsnNode(100));
        instructions.add(new VarInsnNode(54, relLocal));
        LabelNode afterRelCheck = new LabelNode();
        instructions.add(new VarInsnNode(21, relLocal));
        instructions.add(new JumpInsnNode(156, afterRelCheck));
        if (this._meta.getPCSuperclass() != null) {
            String mDesc;
            instructions.add(new VarInsnNode(25, 0));
            Class pcSuperClass = this.getType(this._meta.getPCSuperclassMetaData());
            String string = mDesc = copy ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(pcSuperClass), Type.INT_TYPE) : Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE);
            if (copy) {
                instructions.add(new VarInsnNode(25, 1));
            }
            instructions.add(new VarInsnNode(21, fieldNumber));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(pcSuperClass), name, mDesc));
            instructions.add(new InsnNode(177));
        } else {
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
        }
        instructions.add(afterRelCheck);
        return relLocal;
    }

    private void addMultipleFieldsMethodVersion(ClassNode classNode, MethodNode single, boolean copy) {
        String desc = copy ? Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.getType(int[].class)) : Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(int[].class));
        MethodNode multiMeth = new MethodNode(1, single.name + "s", desc, null, null);
        InsnList instructions = multiMeth.instructions;
        classNode.methods.add(multiMeth);
        int instVarPos = 0;
        if (copy) {
            instVarPos = 3;
            if (this.getCreateSubclass()) {
                instructions.add(new VarInsnNode(25, 1));
                instructions.add(new MethodInsnNode(184, Type.getInternalName(ImplHelper.class), "getManagedInstance", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, AsmHelper.TYPE_OBJECT)));
                instructions.add(new TypeInsnNode(192, this.managedType.getClassNode().name));
                instructions.add(new VarInsnNode(58, instVarPos));
                instructions.add(new VarInsnNode(25, 1));
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                instructions.add(new MethodInsnNode(184, Type.getInternalName(ImplHelper.class), "toPersistenceCapable", Type.getMethodDescriptor(Type.getType(PersistenceCapable.class), AsmHelper.TYPE_OBJECT, AsmHelper.TYPE_OBJECT)));
                instructions.add(new MethodInsnNode(185, Type.getInternalName(PersistenceCapable.class), "pcGetStateManager", Type.getMethodDescriptor(Type.getType(StateManager.class), new Type[0])));
            } else {
                instructions.add(new VarInsnNode(25, 1));
                instructions.add(new TypeInsnNode(192, this.pc.getClassNode().name));
                instructions.add(new VarInsnNode(58, instVarPos));
                instructions.add(new VarInsnNode(25, instVarPos));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            }
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            LabelNode toEndSmCmp = new LabelNode();
            instructions.add(new JumpInsnNode(165, toEndSmCmp));
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class));
            instructions.add(toEndSmCmp);
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            LabelNode toEndSmNull = new LabelNode();
            instructions.add(new JumpInsnNode(199, toEndSmNull));
            instructions.add(AsmHelper.throwException(IllegalStateException.class));
            instructions.add(toEndSmNull);
        }
        int iVarPos = copy ? 4 : 2;
        instructions.add(new InsnNode(3));
        instructions.add(new VarInsnNode(54, iVarPos));
        LabelNode toI = new LabelNode();
        instructions.add(toI);
        int fieldNumbersPos = copy ? 2 : 1;
        instructions.add(new VarInsnNode(21, iVarPos));
        instructions.add(new VarInsnNode(25, fieldNumbersPos));
        instructions.add(new InsnNode(190));
        LabelNode toEnd = new LabelNode();
        instructions.add(new JumpInsnNode(162, toEnd));
        instructions.add(new VarInsnNode(25, 0));
        if (copy) {
            instructions.add(new VarInsnNode(25, instVarPos));
        }
        instructions.add(new VarInsnNode(25, fieldNumbersPos));
        instructions.add(new VarInsnNode(21, iVarPos));
        instructions.add(new InsnNode(46));
        instructions.add(new MethodInsnNode(182, classNode.name, single.name, single.desc));
        instructions.add(new IincInsnNode(iVarPos, 1));
        instructions.add(new JumpInsnNode(167, toI));
        instructions.add(toEnd);
        instructions.add(new InsnNode(177));
    }

    private void addStockMethods() throws NoSuchMethodException {
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("getGenericContext", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("fetchObjectId", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isDeleted", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isDirty", new Class[0]), true);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isNew", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isPersistent", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("isTransactional", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("serializing", new Class[0]), false);
        this.translateFromStateManagerMethod(SMTYPE.getDeclaredMethod("dirty", String.class), false);
        MethodNode getSmMeth = new MethodNode(1, "pcGetStateManager", Type.getMethodDescriptor(Type.getType(SMTYPE), new Type[0]), null, null);
        this.pc.getClassNode().methods.add(getSmMeth);
        InsnList instructions = getSmMeth.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, this.pc.getClassNode().name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new InsnNode(176));
    }

    private void translateFromStateManagerMethod(Method m, boolean isDirtyCheckMethod) {
        String name = PRE + StringUtil.capitalize(m.getName());
        Class<?>[] params = m.getParameterTypes();
        Type[] paramTypes = (Type[])Arrays.stream(params).map(Type::getType).toArray(Type[]::new);
        Class<?> returnType = m.getReturnType();
        ClassNode classNode = this.pc.getClassNode();
        MethodNode methodNode = new MethodNode(1, name, Type.getMethodDescriptor(Type.getType(returnType), paramTypes), null, null);
        InsnList instructions = methodNode.instructions;
        classNode.methods.add(methodNode);
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode lblAfterIf = new LabelNode();
        instructions.add(new JumpInsnNode(199, lblAfterIf));
        if (returnType.equals(Boolean.TYPE)) {
            instructions.add(new InsnNode(3));
        } else if (!returnType.equals(Void.TYPE)) {
            instructions.add(new InsnNode(1));
        }
        instructions.add(new InsnNode(AsmHelper.getReturnInsn(returnType)));
        instructions.add(lblAfterIf);
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        if (isDirtyCheckMethod && !this.getRedefine()) {
            instructions.add(new InsnNode(89));
            instructions.add(new MethodInsnNode(184, Type.getInternalName(RedefinitionHelper.class), "dirtyCheck", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(SMTYPE))));
        }
        for (int i = 0; i < params.length; ++i) {
            instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(params[i]), i + 1));
        }
        instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), m.getName(), Type.getMethodDescriptor(m)));
        instructions.add(new InsnNode(AsmHelper.getReturnInsn(returnType)));
    }

    private void addGetVersionMethod() throws NoSuchMethodException {
        ClassNode classNode = this.pc.getClassNode();
        MethodNode getVersionMeth = new MethodNode(1, "pcGetVersion", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]), null, null);
        classNode.methods.add(getVersionMeth);
        InsnList instructions = getVersionMeth.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode lblAfterIf = new LabelNode();
        instructions.add(new JumpInsnNode(199, lblAfterIf));
        FieldMetaData versionField = this._meta.getVersionField();
        if (versionField == null) {
            instructions.add(new InsnNode(1));
        } else {
            Class wrapper = this.toPrimitiveWrapper(versionField);
            if (wrapper != versionField.getDeclaredType()) {
                instructions.add(new TypeInsnNode(187, Type.getInternalName(wrapper)));
                instructions.add(new InsnNode(89));
            }
            instructions.add(new VarInsnNode(25, 0));
            this.addGetManagedValueCode(classNode, instructions, versionField, true);
            if (wrapper != versionField.getDeclaredType()) {
                instructions.add(new MethodInsnNode(183, Type.getInternalName(wrapper), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(versionField.getDeclaredType()))));
            }
        }
        instructions.add(new InsnNode(176));
        instructions.add(lblAfterIf);
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "getVersion", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
        instructions.add(new InsnNode(176));
    }

    private Class toPrimitiveWrapper(FieldMetaData fmd) {
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Byte.class;
            }
            case 2: {
                return Character.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Short.class;
            }
        }
        return fmd.getDeclaredType();
    }

    private void addReplaceStateManagerMethod() {
        MethodNode replaceSmMeth = new MethodNode(1, "pcReplaceStateManager", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(SMTYPE)), null, new String[]{Type.getInternalName(SecurityException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(replaceSmMeth);
        InsnList instructions = replaceSmMeth.instructions;
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode lblEndIfNull = new LabelNode();
        instructions.add(new JumpInsnNode(198, lblEndIfNull));
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "replaceStateManager", Type.getMethodDescriptor(Type.getType(SMTYPE), Type.getType(SMTYPE))));
        instructions.add(new FieldInsnNode(181, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new InsnNode(177));
        instructions.add(lblEndIfNull);
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new FieldInsnNode(181, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new InsnNode(177));
    }

    private void addNoOpApplicationIdentityMethods() {
        ClassNode classNode = this.pc.getClassNode();
        MethodNode copyKeyMeth = new MethodNode(1, "pcCopyKeyFieldsToObjectId", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(OIDFSTYPE), AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(177));
        copyKeyMeth = new MethodNode(1, "pcCopyKeyFieldsToObjectId", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(177));
        copyKeyMeth = new MethodNode(1, "pcCopyKeyFieldsFromObjectId", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(OIDFCTYPE), AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(177));
        copyKeyMeth = new MethodNode(1, "pcCopyKeyFieldsFromObjectId", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(177));
        copyKeyMeth = new MethodNode(1, "pcNewObjectIdInstance", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(1));
        copyKeyMeth.instructions.add(new InsnNode(176));
        copyKeyMeth = new MethodNode(1, "pcNewObjectIdInstance", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(copyKeyMeth);
        copyKeyMeth.instructions.add(new InsnNode(1));
        copyKeyMeth.instructions.add(new InsnNode(176));
    }

    private void addCopyKeyFieldsToObjectIdMethod(boolean fieldManager) throws NoSuchMethodException {
        int[] parmOrder;
        ArrayList<Integer> pkfields;
        FieldMetaData[] fmds;
        String mDesc = fieldManager ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(OIDFSTYPE), AsmHelper.TYPE_OBJECT) : Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT);
        MethodNode copyKFMeth = new MethodNode(1, "pcCopyKeyFieldsToObjectId", mDesc, null, null);
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(copyKFMeth);
        InsnList instructions = copyKFMeth.instructions;
        if (this._meta.isOpenJPAIdentity()) {
            instructions.add(AsmHelper.throwException(INTERNEXCEP));
            return;
        }
        if (this._meta.getPCSuperclass() != null && !this.getCreateSubclass()) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            if (fieldManager) {
                instructions.add(new VarInsnNode(25, 2));
            }
            instructions.add(new MethodInsnNode(183, Type.getInternalName(this.getType(this._meta.getPCSuperclassMetaData())), "pcCopyKeyFieldsToObjectId", mDesc));
        }
        if (fieldManager) {
            instructions.add(new VarInsnNode(25, 2));
        } else {
            instructions.add(new VarInsnNode(25, 1));
        }
        if (this._meta.isObjectIdTypeShared()) {
            instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
            instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
        }
        int nextFreeVarPos = fieldManager ? 3 : 2;
        int idVarPos = nextFreeVarPos++;
        Class<?> oidType = this._meta.getObjectIdType();
        instructions.add(new TypeInsnNode(192, Type.getInternalName(oidType)));
        instructions.add(new VarInsnNode(58, idVarPos));
        int inherited = 0;
        if (fieldManager) {
            instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
            inherited = nextFreeVarPos++;
            instructions.add(new VarInsnNode(54, inherited));
        }
        FieldMetaData[] fieldMetaDataArray = fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        if (this._optimizeIdCopy && (pkfields = this.optimizeIdCopy(oidType, fmds)) != null && (parmOrder = this.getIdClassConstructorParmOrder(oidType, pkfields, fmds)) != null) {
            int[] localIndexes = new int[fmds.length];
            if (fieldManager) {
                for (int k = 0; k < fmds.length; ++k) {
                    if (!fmds[k].isPrimaryKey()) continue;
                    instructions.add(new VarInsnNode(25, 1));
                    instructions.add(AsmHelper.getLoadConstantInsn(k));
                    instructions.add(new VarInsnNode(21, inherited));
                    instructions.add(new InsnNode(96));
                    Method fieldSupplierMethod = this.getFieldSupplierMethod(fmds[k].getObjectIdFieldType());
                    instructions.add(new MethodInsnNode(185, Type.getInternalName(fieldSupplierMethod.getDeclaringClass()), fieldSupplierMethod.getName(), Type.getMethodDescriptor(fieldSupplierMethod)));
                    localIndexes[k] = nextFreeVarPos++;
                    instructions.add(new VarInsnNode(AsmHelper.getStoreInsn(fmds[k].getObjectIdFieldType()), localIndexes[k]));
                }
            }
            instructions.add(new TypeInsnNode(187, Type.getInternalName(oidType)));
            instructions.add(new InsnNode(89));
            Class[] clsArgs = new Class[parmOrder.length];
            for (int i = 0; i < clsArgs.length; ++i) {
                int parmIndex = parmOrder[i];
                clsArgs[i] = fmds[parmIndex].getObjectIdFieldType();
                if (!fieldManager) {
                    instructions.add(new VarInsnNode(25, 0));
                    this.addGetManagedValueCode(classNode, instructions, fmds[parmIndex], true);
                    continue;
                }
                instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(fmds[parmIndex].getObjectIdFieldType()), localIndexes[parmIndex]));
                if (fmds[parmIndex].getObjectIdFieldTypeCode() == 8 && !fmds[parmIndex].getDeclaredType().isEnum()) {
                    instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
                    instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                }
                if (clsArgs[i].isPrimitive() || clsArgs[i].getName().equals(String.class.getName())) continue;
                instructions.add(new TypeInsnNode(192, Type.getInternalName(clsArgs[i])));
            }
            Type[] parms = (Type[])Arrays.stream(clsArgs).map(Type::getType).toArray(Type[]::new);
            instructions.add(new MethodInsnNode(183, Type.getInternalName(oidType), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, parms)));
            int retVarPos = inherited + fmds.length;
            instructions.add(new VarInsnNode(58, retVarPos));
            instructions.add(new VarInsnNode(25, fieldManager ? 2 : 1));
            instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
            instructions.add(new VarInsnNode(25, retVarPos));
            instructions.add(new MethodInsnNode(184, Type.getInternalName(ApplicationIds.class), "setAppId", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectId.class), AsmHelper.TYPE_OBJECT)));
            instructions.add(new InsnNode(177));
            return;
        }
        Field field = null;
        Method setter = null;
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey()) continue;
            instructions.add(new VarInsnNode(25, idVarPos));
            String name = fmds[i].getName();
            Class<?> type = fmds[i].getObjectIdFieldType();
            boolean reflect = false;
            if (this.isFieldAccess(fmds[i])) {
                field = Reflection.findField(oidType, name, true);
                boolean bl = reflect = !Modifier.isPublic(field.getModifiers());
                if (reflect) {
                    instructions.add(AsmHelper.getLoadConstantInsn(oidType));
                    instructions.add(AsmHelper.getLoadConstantInsn(name));
                    instructions.add(AsmHelper.getLoadConstantInsn(true));
                    instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findField", Type.getMethodDescriptor(Type.getType(Field.class), Type.getType(Class.class), Type.getType(String.class), Type.BOOLEAN_TYPE)));
                }
            } else {
                setter = Reflection.findSetter(oidType, name, type, true);
                boolean bl = reflect = !Modifier.isPublic(setter.getModifiers());
                if (reflect) {
                    instructions.add(AsmHelper.getLoadConstantInsn(oidType));
                    instructions.add(AsmHelper.getLoadConstantInsn(name));
                    instructions.add(AsmHelper.getLoadConstantInsn(type));
                    instructions.add(AsmHelper.getLoadConstantInsn(true));
                    instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findSetter", Type.getMethodDescriptor(Type.getType(Method.class), Type.getType(Class.class), Type.getType(String.class), Type.getType(Class.class), Type.BOOLEAN_TYPE)));
                }
            }
            if (fieldManager) {
                instructions.add(new VarInsnNode(25, 1));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add(new VarInsnNode(21, inherited));
                instructions.add(new InsnNode(96));
                Method fieldSupplierMethod = this.getFieldSupplierMethod(type);
                instructions.add(new MethodInsnNode(185, Type.getInternalName(fieldSupplierMethod.getDeclaringClass()), fieldSupplierMethod.getName(), Type.getMethodDescriptor(fieldSupplierMethod)));
                if (fmds[i].getObjectIdFieldTypeCode() == 8 && !fmds[i].getDeclaredType().isEnum()) {
                    instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
                    instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                }
                if (!(reflect || type.isPrimitive() || type.getName().equals(String.class.getName()))) {
                    instructions.add(new TypeInsnNode(192, Type.getInternalName(type)));
                }
            } else {
                instructions.add(new VarInsnNode(25, 0));
                this.addGetManagedValueCode(classNode, instructions, fmds[i], true);
                if (fmds[i].getDeclaredTypeCode() == 15) {
                    this.addExtractObjectIdFieldValueCode(classNode, instructions, fmds[i], nextFreeVarPos++);
                }
            }
            if (reflect && field != null) {
                instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "set", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.getType(Field.class), type.isPrimitive() ? Type.getType(type) : AsmHelper.TYPE_OBJECT)));
                continue;
            }
            if (reflect) {
                instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "set", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, Type.getType(Method.class), type.isPrimitive() ? Type.getType(type) : AsmHelper.TYPE_OBJECT)));
                continue;
            }
            if (field != null) {
                instructions.add(new FieldInsnNode(181, Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType())));
                continue;
            }
            instructions.add(new MethodInsnNode(182, Type.getInternalName(setter.getDeclaringClass()), setter.getName(), Type.getMethodDescriptor(setter)));
        }
        instructions.add(new InsnNode(177));
    }

    private void addExtractObjectIdFieldValueCode(ClassNode classNode, InsnList instructions, FieldMetaData pk, int nextFreeVarPos) {
        int pkcode;
        LabelNode lblAfterIfNull2;
        LabelNode lblAfterIfNull;
        block44: {
            Class<?> pktype;
            ClassMetaData pkmeta;
            int oidVarPos;
            block46: {
                block45: {
                    block43: {
                        int pcVarPos = nextFreeVarPos++;
                        instructions.add(new VarInsnNode(58, pcVarPos));
                        instructions.add(new VarInsnNode(25, pcVarPos));
                        lblAfterIfNull = new LabelNode();
                        instructions.add(new JumpInsnNode(198, lblAfterIfNull));
                        instructions.add(new VarInsnNode(25, pcVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(PersistenceCapable.class)));
                        if (!pk.getTypeMetaData().isOpenJPAIdentity()) {
                            instructions.add(new MethodInsnNode(185, Type.getInternalName(PersistenceCapable.class), "pcFetchObjectId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                        } else {
                            instructions.add(new MethodInsnNode(185, Type.getInternalName(PersistenceCapable.class), "pcNewObjectIdInstance", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                        }
                        oidVarPos = nextFreeVarPos++;
                        instructions.add(new VarInsnNode(58, oidVarPos));
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        lblAfterIfNull2 = new LabelNode();
                        instructions.add(new JumpInsnNode(198, lblAfterIfNull2));
                        pkmeta = pk.getDeclaredTypeMetaData();
                        pkcode = pk.getObjectIdFieldTypeCode();
                        pktype = pk.getObjectIdFieldType();
                        if (pkmeta.getIdentityType() != 1 || pkcode != 6) break block43;
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(Id.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(Id.class), "getId", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0])));
                        break block44;
                    }
                    if (pkmeta.getIdentityType() != 1) break block45;
                    instructions.add(new VarInsnNode(25, oidVarPos));
                    break block44;
                }
                if (!pkmeta.isOpenJPAIdentity()) break block46;
                switch (pkcode) {
                    case 17: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Byte.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 1: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(ByteId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(ByteId.class), "getId", Type.getMethodDescriptor(Type.BYTE_TYPE, new Type[0])));
                        if (pkcode == 17) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Byte.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.BYTE_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 18: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Character.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 2: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(CharId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(CharId.class), "getId", Type.getMethodDescriptor(Type.CHAR_TYPE, new Type[0])));
                        if (pkcode == 18) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Character.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.CHAR_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 19: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Double.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 3: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(DoubleId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(DoubleId.class), "getId", Type.getMethodDescriptor(Type.DOUBLE_TYPE, new Type[0])));
                        if (pkcode == 19) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Character.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.CHAR_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 20: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Float.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 4: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(FloatId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(FloatId.class), "getId", Type.getMethodDescriptor(Type.FLOAT_TYPE, new Type[0])));
                        if (pkcode == 20) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Float.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.FLOAT_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 21: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Integer.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 5: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(IntId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(IntId.class), "getId", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0])));
                        if (pkcode == 21) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Integer.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 22: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Long.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 6: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(LongId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(LongId.class), "getId", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0])));
                        if (pkcode == 22) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Long.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.LONG_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 23: {
                        instructions.add(new TypeInsnNode(187, Type.getInternalName(Short.class)));
                        instructions.add(new InsnNode(89));
                    }
                    case 7: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(ShortId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(ShortId.class), "getId", Type.getMethodDescriptor(Type.SHORT_TYPE, new Type[0])));
                        if (pkcode == 23) {
                            instructions.add(new MethodInsnNode(183, Type.getInternalName(Short.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.SHORT_TYPE)));
                            break;
                        }
                        break block44;
                    }
                    case 14: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(DateId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(DateId.class), "getId", Type.getMethodDescriptor(Type.getType(Date.class), new Type[0])));
                        if (pktype != Date.class) {
                            instructions.add(new TypeInsnNode(192, Type.getInternalName(pktype)));
                            break;
                        }
                        break block44;
                    }
                    case 9: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(StringId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(StringId.class), "getId", Type.getMethodDescriptor(Type.getType(String.class), new Type[0])));
                        break;
                    }
                    case 24: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(BigDecimalId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(BigDecimalId.class), "getId", Type.getMethodDescriptor(Type.getType(BigDecimal.class), new Type[0])));
                        break;
                    }
                    case 25: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(BigIntegerId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(BigIntegerId.class), "getId", Type.getMethodDescriptor(Type.getType(BigInteger.class), new Type[0])));
                        break;
                    }
                    default: {
                        instructions.add(new VarInsnNode(25, oidVarPos));
                        instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0])));
                        break;
                    }
                }
                break block44;
            }
            if (pkmeta.getObjectIdType() != null) {
                instructions.add(new VarInsnNode(25, oidVarPos));
                if (pkcode == 8) {
                    instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
                    instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                }
                instructions.add(new TypeInsnNode(192, Type.getInternalName(pktype)));
            } else {
                instructions.add(new VarInsnNode(25, oidVarPos));
            }
        }
        LabelNode lblGo2End = new LabelNode();
        instructions.add(new JumpInsnNode(167, lblGo2End));
        instructions.add(lblAfterIfNull);
        instructions.add(lblAfterIfNull2);
        switch (pkcode) {
            case 0: {
                instructions.add(AsmHelper.getLoadConstantInsn(false));
                break;
            }
            case 1: {
                instructions.add(AsmHelper.getLoadConstantInsn(0));
                break;
            }
            case 2: {
                instructions.add(AsmHelper.getLoadConstantInsn(0));
                break;
            }
            case 3: {
                instructions.add(AsmHelper.getLoadConstantInsn(0.0));
                break;
            }
            case 4: {
                instructions.add(AsmHelper.getLoadConstantInsn(Float.valueOf(0.0f)));
                break;
            }
            case 5: {
                instructions.add(AsmHelper.getLoadConstantInsn(0));
                break;
            }
            case 6: {
                instructions.add(AsmHelper.getLoadConstantInsn(0L));
                break;
            }
            case 7: {
                instructions.add(AsmHelper.getLoadConstantInsn((short)0));
                break;
            }
            default: {
                instructions.add(AsmHelper.getLoadConstantInsn(null));
            }
        }
        instructions.add(lblGo2End);
    }

    private void addCopyKeyFieldsFromObjectIdMethod(boolean fieldManager) throws NoSuchMethodException {
        String mDesc = fieldManager ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(OIDFCTYPE), AsmHelper.TYPE_OBJECT) : Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT);
        MethodNode copyKFMeth = new MethodNode(1, "pcCopyKeyFieldsFromObjectId", mDesc, null, null);
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(copyKFMeth);
        InsnList instructions = copyKFMeth.instructions;
        if (this._meta.getPCSuperclass() != null && !this.getCreateSubclass()) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            if (fieldManager) {
                instructions.add(new VarInsnNode(25, 2));
            }
            instructions.add(new MethodInsnNode(183, Type.getInternalName(this.getType(this._meta.getPCSuperclassMetaData())), "pcCopyKeyFieldsFromObjectId", mDesc));
        }
        if (fieldManager) {
            instructions.add(new VarInsnNode(25, 2));
        } else {
            instructions.add(new VarInsnNode(25, 1));
        }
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            instructions.add(new TypeInsnNode(192, Type.getInternalName(ObjectId.class)));
            instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectId.class), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
        }
        int nextFreeVarPos = fieldManager ? 3 : 2;
        int idVarPos = nextFreeVarPos++;
        Class<?> oidType = this._meta.getObjectIdType();
        instructions.add(new TypeInsnNode(192, Type.getInternalName(oidType)));
        instructions.add(new VarInsnNode(58, idVarPos));
        FieldMetaData[] fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey()) continue;
            String name = fmds[i].getName();
            Class type = fmds[i].getObjectIdFieldType();
            if (!fieldManager && fmds[i].getDeclaredTypeCode() == 15) {
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                LabelNode lblEndIfNotNull = new LabelNode();
                instructions.add(new JumpInsnNode(199, lblEndIfNotNull));
                instructions.add(new InsnNode(177));
                instructions.add(lblEndIfNotNull);
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new InsnNode(89));
                instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                instructions.add(new VarInsnNode(25, idVarPos));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
                instructions.add(new InsnNode(96));
                instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "getPCPrimaryKey", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, AsmHelper.TYPE_OBJECT, Type.INT_TYPE)));
                instructions.add(new TypeInsnNode(192, Type.getInternalName(fmds[i].getDeclaredType())));
            } else {
                Class unwrapped;
                Class clazz = unwrapped = fmds[i].getDeclaredTypeCode() == 15 ? type : this.unwrapSingleFieldIdentity(fmds[i]);
                if (fieldManager) {
                    instructions.add(new VarInsnNode(25, 1));
                    instructions.add(AsmHelper.getLoadConstantInsn(i));
                    instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
                    instructions.add(new InsnNode(96));
                } else {
                    instructions.add(new VarInsnNode(25, 0));
                }
                if (unwrapped != type && type != Long.class) {
                    instructions.add(new TypeInsnNode(187, Type.getInternalName(type)));
                    instructions.add(new InsnNode(89));
                }
                instructions.add(new VarInsnNode(25, idVarPos));
                if (this._meta.isOpenJPAIdentity()) {
                    if (oidType == ObjectId.class) {
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(oidType), "getId", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
                        if (!fieldManager && type != Object.class) {
                            instructions.add(new TypeInsnNode(192, Type.getInternalName(fmds[i].getDeclaredType())));
                        }
                    } else if (oidType == DateId.class) {
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(oidType), "getId", Type.getMethodDescriptor(Type.getType(Date.class), new Type[0])));
                        if (!fieldManager && type != Date.class) {
                            instructions.add(new TypeInsnNode(192, Type.getInternalName(fmds[i].getDeclaredType())));
                        }
                    } else {
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(oidType), "getId", Type.getMethodDescriptor(Type.getType(unwrapped), new Type[0])));
                        if (unwrapped != type) {
                            if (type == Long.class) {
                                instructions.add(new MethodInsnNode(184, Type.getInternalName(type), LONG_VALUE_OF.getName(), Type.getMethodDescriptor(LONG_VALUE_OF)));
                            } else {
                                instructions.add(new MethodInsnNode(183, Type.getInternalName(type), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(unwrapped))));
                            }
                        }
                    }
                } else if (this.isFieldAccess(fmds[i])) {
                    Field field = Reflection.findField(oidType, name, true);
                    if (Modifier.isPublic(field.getModifiers())) {
                        instructions.add(new FieldInsnNode(180, Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType())));
                    } else {
                        Method getter;
                        boolean usedFastOid = false;
                        if (this._optimizeIdCopy && (getter = Reflection.findGetter(oidType, name, false)) != null && Modifier.isPublic(getter.getModifiers())) {
                            usedFastOid = true;
                            instructions.add(new MethodInsnNode(182, Type.getInternalName(getter.getDeclaringClass()), getter.getName(), Type.getMethodDescriptor(getter)));
                        }
                        if (!usedFastOid) {
                            instructions.add(AsmHelper.getLoadConstantInsn(oidType));
                            instructions.add(AsmHelper.getLoadConstantInsn(name));
                            instructions.add(AsmHelper.getLoadConstantInsn(true));
                            instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findField", Type.getMethodDescriptor(Type.getType(Field.class), Type.getType(Class.class), Type.getType(String.class), Type.BOOLEAN_TYPE)));
                            Method reflectionGetterMethod = this.getReflectionGetterMethod(type, Field.class);
                            instructions.add(new MethodInsnNode(184, Type.getInternalName(reflectionGetterMethod.getDeclaringClass()), reflectionGetterMethod.getName(), Type.getMethodDescriptor(reflectionGetterMethod)));
                            if (!type.isPrimitive() && type != Object.class) {
                                instructions.add(new TypeInsnNode(192, Type.getInternalName(type)));
                            }
                        }
                    }
                } else {
                    Method getter = Reflection.findGetter(oidType, name, true);
                    if (Modifier.isPublic(getter.getModifiers())) {
                        instructions.add(new MethodInsnNode(182, Type.getInternalName(getter.getDeclaringClass()), getter.getName(), Type.getMethodDescriptor(getter)));
                    } else {
                        instructions.add(AsmHelper.getLoadConstantInsn(oidType));
                        instructions.add(AsmHelper.getLoadConstantInsn(name));
                        instructions.add(AsmHelper.getLoadConstantInsn(true));
                        instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findGetter", Type.getMethodDescriptor(Type.getType(Method.class), Type.getType(Class.class), Type.getType(String.class), Type.BOOLEAN_TYPE)));
                        Method reflectionGetterMethod = this.getReflectionGetterMethod(type, Method.class);
                        instructions.add(new MethodInsnNode(184, Type.getInternalName(reflectionGetterMethod.getDeclaringClass()), reflectionGetterMethod.getName(), Type.getMethodDescriptor(reflectionGetterMethod)));
                        if (!type.isPrimitive() && type != Object.class) {
                            instructions.add(new TypeInsnNode(192, Type.getInternalName(type)));
                        }
                    }
                }
            }
            if (fieldManager) {
                Method fieldConsumerMethod = this.getFieldConsumerMethod(type);
                instructions.add(new MethodInsnNode(185, Type.getInternalName(fieldConsumerMethod.getDeclaringClass()), fieldConsumerMethod.getName(), Type.getMethodDescriptor(fieldConsumerMethod)));
                continue;
            }
            this.addSetManagedValueCode(classNode, instructions, fmds[i]);
        }
        instructions.add(new InsnNode(177));
    }

    private Boolean usesClassStringIdConstructor() {
        if (this._meta.getIdentityType() != 2) {
            return Boolean.FALSE;
        }
        if (this._meta.isOpenJPAIdentity()) {
            if (this._meta.getObjectIdType() == ObjectId.class) {
                return null;
            }
            return Boolean.TRUE;
        }
        Class<?> oidType = this._meta.getObjectIdType();
        try {
            oidType.getConstructor(Class.class, String.class);
            return Boolean.TRUE;
        }
        catch (Throwable throwable) {
            try {
                oidType.getConstructor(String.class);
                return Boolean.FALSE;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    private Class unwrapSingleFieldIdentity(FieldMetaData fmd) {
        if (!fmd.getDefiningMetaData().isOpenJPAIdentity()) {
            return fmd.getDeclaredType();
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 17: {
                return Byte.TYPE;
            }
            case 18: {
                return Character.TYPE;
            }
            case 19: {
                return Double.TYPE;
            }
            case 20: {
                return Float.TYPE;
            }
            case 21: {
                return Integer.TYPE;
            }
            case 23: {
                return Short.TYPE;
            }
            case 22: {
                return Long.TYPE;
            }
        }
        return fmd.getDeclaredType();
    }

    private Method getReflectionGetterMethod(Class type, Class argType) throws NoSuchMethodException {
        Object name = "get";
        if (type.isPrimitive()) {
            name = (String)name + StringUtil.capitalize(type.getName());
        }
        return Reflection.class.getMethod((String)name, Object.class, argType);
    }

    private Method getFieldSupplierMethod(Class type) throws NoSuchMethodException {
        return this.getMethod(OIDFSTYPE, type, "fetch", true, false, false);
    }

    private Method getFieldConsumerMethod(Class type) throws NoSuchMethodException {
        return this.getMethod(OIDFCTYPE, type, "store", false, false, false);
    }

    private void addNewObjectIdInstanceMethod(boolean obj) throws NoSuchMethodException {
        String mDesc = obj ? Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, AsmHelper.TYPE_OBJECT) : Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]);
        MethodNode newOidMeth = new MethodNode(1, "pcNewObjectIdInstance", mDesc, null, null);
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(newOidMeth);
        InsnList instructions = newOidMeth.instructions;
        Boolean usesClsString = this.usesClassStringIdConstructor();
        Class<?> oidType = this._meta.getObjectIdType();
        if (obj && usesClsString == null) {
            String msg = _loc.get("str-cons", oidType, this._meta.getDescribedType()).getMessage();
            instructions.add(AsmHelper.throwException(IllegalArgumentException.class, msg));
            return;
        }
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            instructions.add(new TypeInsnNode(187, Type.getInternalName(ObjectId.class)));
            instructions.add(new InsnNode(89));
            if (this._meta.isEmbeddedOnly() || this._meta.hasAbstractPKField()) {
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new MethodInsnNode(182, classNode.name, "pcGetIDOwningClass", Type.getMethodDescriptor(Type.getType(Class.class), new Type[0])));
            } else {
                instructions.add(AsmHelper.getLoadConstantInsn(this.getType(this._meta)));
            }
        }
        instructions.add(new TypeInsnNode(187, Type.getInternalName(oidType)));
        instructions.add(new InsnNode(89));
        if (this._meta.isOpenJPAIdentity() || obj && usesClsString == Boolean.TRUE) {
            if (this._meta.isEmbeddedOnly() && (!this._meta.isEmbeddable() || this._meta.getIdentityType() != 2) || this._meta.hasAbstractPKField()) {
                instructions.add(new VarInsnNode(25, 0));
                instructions.add(new MethodInsnNode(182, classNode.name, "pcGetIDOwningClass", Type.getMethodDescriptor(Type.getType(Class.class), new Type[0])));
            } else {
                instructions.add(AsmHelper.getLoadConstantInsn(this.getType(this._meta)));
            }
        }
        String mDescInit = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
        if (obj) {
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new TypeInsnNode(192, Type.getInternalName(String.class)));
            if (usesClsString == Boolean.TRUE) {
                mDescInit = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(String.class));
            } else if (usesClsString == Boolean.FALSE) {
                mDescInit = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class));
            }
        } else if (this._meta.isOpenJPAIdentity()) {
            instructions.add(new VarInsnNode(25, 0));
            FieldMetaData pk = this._meta.getPrimaryKeyFields()[0];
            this.addGetManagedValueCode(classNode, instructions, pk, true);
            if (pk.getDeclaredTypeCode() == 15) {
                int nextFreeVarPos = 1;
                this.addExtractObjectIdFieldValueCode(classNode, instructions, pk, nextFreeVarPos);
            }
            mDescInit = this._meta.getObjectIdType() == ObjectId.class ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(Object.class)) : (this._meta.getObjectIdType() == Date.class ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(Date.class)) : Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(pk.getObjectIdFieldType())));
        }
        instructions.add(new MethodInsnNode(183, Type.getInternalName(oidType), "<init>", mDescInit));
        if (!this._meta.isOpenJPAIdentity() && this._meta.isObjectIdTypeShared()) {
            instructions.add(new MethodInsnNode(183, Type.getInternalName(ObjectId.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(Object.class))));
        }
        instructions.add(new InsnNode(176));
    }

    private Method getStateManagerMethod(Class type, String prefix, boolean get, boolean curValue) throws NoSuchMethodException {
        return this.getMethod(SMTYPE, type, prefix, get, true, curValue);
    }

    private Method getMethod(Class owner, Class type, String prefix, boolean get, boolean haspc, boolean curValue) throws NoSuchMethodException {
        Object typeName = type.getName();
        if (type.isPrimitive()) {
            typeName = ((String)typeName).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)typeName).substring(1);
        } else if (type.equals(String.class)) {
            typeName = "String";
        } else {
            typeName = "Object";
            type = Object.class;
        }
        ArrayList plist = new ArrayList(4);
        if (haspc) {
            plist.add(PCTYPE);
        }
        plist.add(Integer.TYPE);
        if (!get || curValue) {
            plist.add(type);
        }
        if (!get && curValue) {
            plist.add(type);
            plist.add(Integer.TYPE);
        }
        String name = prefix + (String)typeName + "Field";
        Class[] params = plist.toArray(new Class[0]);
        try {
            return AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(owner, name, params));
        }
        catch (PrivilegedActionException pae) {
            throw (NoSuchMethodException)pae.getException();
        }
    }

    private void enhanceClass(ClassNodeTracker classNodeTracker) {
        ClassNode classNode = classNodeTracker.getClassNode();
        classNode.interfaces.add(Type.getInternalName(PCTYPE));
        this.addGetEnhancementContractVersionMethod(classNodeTracker);
        boolean hasDefaultCt = classNode.methods.stream().anyMatch(m -> m.name.equals("<init>") && m.desc.equals("()V"));
        if (!hasDefaultCt) {
            String access;
            int accessMode;
            if (!this._defCons) {
                throw new UserException(_loc.get("enhance-defaultconst", classNode.name));
            }
            if (this._meta.isDetachable()) {
                accessMode = 1;
                access = "public";
            } else if ((this.pc.getClassNode().access & 0x10) > 0) {
                accessMode = 2;
                access = "private";
            } else {
                accessMode = 4;
                access = "protected";
            }
            MethodNode ctNode = new MethodNode(accessMode, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
            ctNode.instructions.add(new VarInsnNode(25, 0));
            ctNode.instructions.add(new MethodInsnNode(183, classNode.superName, "<init>", "()V"));
            ctNode.instructions.add(new InsnNode(177));
            classNode.methods.add(ctNode);
            if (!this._meta.getDescribedType().isInterface() && !this.getCreateSubclass() && this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("enhance-adddefaultconst", classNode.name, access));
            }
        }
    }

    private void addFields(ClassNodeTracker classNodeTracker) {
        ClassNode classNode = classNodeTracker.getClassNode();
        classNode.fields.add(new FieldNode(10, INHERIT, Type.getDescriptor(Integer.TYPE), null, null));
        classNode.fields.add(new FieldNode(10, "pcFieldNames", Type.getDescriptor(String[].class), null, null));
        classNode.fields.add(new FieldNode(10, "pcFieldTypes", Type.getDescriptor(Class[].class), null, null));
        classNode.fields.add(new FieldNode(10, "pcFieldFlags", Type.getDescriptor(byte[].class), null, null));
        classNode.fields.add(new FieldNode(10, SUPER, Type.getDescriptor(Class.class), null, null));
        if (this._addVersionInitFlag && this._meta.getVersionField() != null) {
            classNode.fields.add(new FieldNode(132, VERSION_INIT_STR, Type.getDescriptor(Boolean.TYPE), null, null));
        }
        if (this._meta.getPCSuperclass() == null || this.getCreateSubclass()) {
            classNode.fields.add(new FieldNode(132, SM, Type.getDescriptor(SMTYPE), null, null));
        }
    }

    private void addStaticInitializer(ClassNodeTracker classNodeTracker) {
        int i;
        ClassNode classNode = classNodeTracker.getClassNode();
        InsnList instructions = new InsnList();
        if (this._meta.getPCSuperclass() != null) {
            if (this.getCreateSubclass()) {
                instructions.add(AsmHelper.getLoadConstantInsn(0));
                instructions.add(new FieldInsnNode(179, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
            } else {
                instructions.add(new MethodInsnNode(184, classNode.superName, "pcGetManagedFieldCount", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0])));
                instructions.add(new FieldInsnNode(179, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
            }
            instructions.add(AsmHelper.getLoadConstantInsn(this._meta.getPCSuperclassMetaData().getDescribedType()));
            instructions.add(new FieldInsnNode(179, classNode.name, SUPER, Type.getDescriptor(Class.class)));
        }
        FieldMetaData[] fmds = this._meta.getDeclaredFields();
        instructions.add(AsmHelper.getLoadConstantInsn(fmds.length));
        instructions.add(new TypeInsnNode(189, Type.getInternalName(String.class)));
        for (i = 0; i < fmds.length; ++i) {
            instructions.add(new InsnNode(89));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add(AsmHelper.getLoadConstantInsn(fmds[i].getName()));
            instructions.add(new InsnNode(83));
        }
        instructions.add(new FieldInsnNode(179, classNode.name, "pcFieldNames", Type.getDescriptor(String[].class)));
        instructions.add(AsmHelper.getLoadConstantInsn(fmds.length));
        instructions.add(new TypeInsnNode(189, Type.getInternalName(Class.class)));
        for (i = 0; i < fmds.length; ++i) {
            instructions.add(new InsnNode(89));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add(AsmHelper.getLoadConstantInsn(fmds[i].getDeclaredType()));
            instructions.add(new InsnNode(83));
        }
        instructions.add(new FieldInsnNode(179, classNode.name, "pcFieldTypes", Type.getDescriptor(Class[].class)));
        instructions.add(AsmHelper.getLoadConstantInsn(fmds.length));
        instructions.add(new IntInsnNode(188, 8));
        for (i = 0; i < fmds.length; ++i) {
            instructions.add(new InsnNode(89));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add(AsmHelper.getLoadConstantInsn(PCEnhancer.getFieldFlag(fmds[i])));
            instructions.add(new InsnNode(84));
        }
        instructions.add(new FieldInsnNode(179, classNode.name, "pcFieldFlags", Type.getDescriptor(byte[].class)));
        instructions.add(AsmHelper.getLoadConstantInsn(this._meta.getDescribedType()));
        instructions.add(new FieldInsnNode(178, classNode.name, "pcFieldNames", Type.getDescriptor(String[].class)));
        instructions.add(new FieldInsnNode(178, classNode.name, "pcFieldTypes", Type.getDescriptor(Class[].class)));
        instructions.add(new FieldInsnNode(178, classNode.name, "pcFieldFlags", Type.getDescriptor(byte[].class)));
        instructions.add(new FieldInsnNode(178, classNode.name, SUPER, Type.getDescriptor(Class.class)));
        if (this._meta.isMapped() || this._meta.isAbstract()) {
            instructions.add(AsmHelper.getLoadConstantInsn(this._meta.getTypeAlias()));
        } else {
            instructions.add(new InsnNode(1));
        }
        if ((this.pc.getClassNode().access & 0x400) > 0) {
            instructions.add(new InsnNode(1));
        } else {
            instructions.add(new TypeInsnNode(187, classNode.name));
            instructions.add(new InsnNode(89));
            instructions.add(new MethodInsnNode(183, classNode.name, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
        }
        instructions.add(new MethodInsnNode(184, Type.getInternalName(HELPERTYPE), "register", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class), Type.getType(String[].class), Type.getType(Class[].class), Type.getType(byte[].class), Type.getType(Class.class), Type.getType(String.class), Type.getType(PersistenceCapable.class))));
        MethodNode clinit = this.getOrCreateClassInitMethod(classNode);
        AbstractInsnNode retInsn = clinit.instructions.getLast();
        if (retInsn.getOpcode() != 177) {
            throw new IllegalStateException("Problem with parsing instructions. RETURN expected");
        }
        clinit.instructions.insertBefore(retInsn, instructions);
    }

    private static byte getFieldFlag(FieldMetaData fmd) {
        if (fmd.getManagement() == 0) {
            return -1;
        }
        byte flags = 0;
        if (fmd.getDeclaredType().isPrimitive() || Serializable.class.isAssignableFrom(fmd.getDeclaredType())) {
            flags = 16;
        }
        flags = fmd.getManagement() == 1 ? (byte)((byte)(flags | 4)) : (!fmd.isPrimaryKey() && !fmd.isInDefaultFetchGroup() ? (byte)(flags | 5) : (byte)(flags | 0xA));
        return flags;
    }

    private void addSerializationCode() {
        MethodNode writeObjectMeth;
        boolean full;
        if (this.externalizeDetached() || !Serializable.class.isAssignableFrom(this._meta.getDescribedType())) {
            return;
        }
        if (this.getCreateSubclass()) {
            if (!Externalizable.class.isAssignableFrom(this._meta.getDescribedType())) {
                this.addSubclassSerializationCode();
            }
            return;
        }
        Optional<FieldNode> serialVersionUIDNode = this.pc.getClassNode().fields.stream().filter(f -> f.name.equals("serialVersionUID")).findFirst();
        if (serialVersionUIDNode.isEmpty()) {
            Long uid = null;
            try {
                uid = ObjectStreamClass.lookup(this._meta.getDescribedType()).getSerialVersionUID();
            }
            catch (Throwable t) {
                if (this._log.isTraceEnabled()) {
                    this._log.warn(_loc.get("enhance-uid-access", this._meta), t);
                }
                this._log.warn(_loc.get("enhance-uid-access", this._meta));
            }
            if (uid != null) {
                FieldNode serVersField = new FieldNode(26, "serialVersionUID", Type.LONG_TYPE.getDescriptor(), null, uid);
                this.pc.getClassNode().fields.add(serVersField);
            }
        }
        boolean bl = full = (writeObjectMeth = (MethodNode)AsmHelper.getMethodNode(this.pc.getClassNode(), "writeObject", Void.TYPE, ObjectOutputStream.class).orElse(null)) == null;
        if (full) {
            writeObjectMeth = new MethodNode(2, "writeObject", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectOutputStream.class)), null, new String[]{Type.getInternalName(IOException.class)});
            this.pc.getClassNode().methods.add(writeObjectMeth);
        }
        this.modifyWriteObjectMethod(this.pc.getClassNode(), writeObjectMeth, full);
        MethodNode readObjectMeth = AsmHelper.getMethodNode(this.pc.getClassNode(), "readObject", Void.TYPE, ObjectInputStream.class).orElse(null);
        boolean bl2 = full = readObjectMeth == null;
        if (full) {
            readObjectMeth = new MethodNode(2, "readObject", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInputStream.class)), null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
            this.pc.getClassNode().methods.add(readObjectMeth);
        }
        this.modifyReadObjectMethod(this.pc.getClassNode(), readObjectMeth, full);
    }

    private void addSubclassSerializationCode() {
        FieldMetaData[] fmds;
        MethodNode writeReplaceMeth = new MethodNode(2, "writeReplace", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]), null, new String[]{Type.getInternalName(ObjectStreamException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(writeReplaceMeth);
        InsnList instructions = writeReplaceMeth.instructions;
        instructions.add(new TypeInsnNode(187, this.managedType.getClassNode().name));
        instructions.add(new InsnNode(89));
        instructions.add(new InsnNode(89));
        instructions.add(new MethodInsnNode(183, this.managedType.getClassNode().name, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
        for (FieldMetaData fmd : fmds = this._meta.getFields()) {
            if (fmd.isTransient()) continue;
            instructions.add(new InsnNode(89));
            instructions.add(new VarInsnNode(25, 0));
            this.getfield(classNode, instructions, this._meta.getDescribedType(), fmd.getName(), fmd.getDeclaredType());
            this.putfield(classNode, instructions, this._meta.getDescribedType(), fmd.getName(), fmd.getDeclaredType());
        }
        instructions.add(new InsnNode(176));
    }

    private boolean externalizeDetached() {
        return "`syn".equals(this._meta.getDetachedState()) && Serializable.class.isAssignableFrom(this._meta.getDescribedType()) && !this._repos.getConfiguration().getDetachStateInstance().isDetachedStateTransient();
    }

    private void modifyWriteObjectMethod(ClassNode classNode, MethodNode method, boolean full) {
        InsnList instructions = new InsnList();
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new MethodInsnNode(182, classNode.name, "pcSerializing", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
        int clearVarPos = full ? 2 : method.maxLocals + 1;
        instructions.add(new VarInsnNode(54, clearVarPos));
        if (full) {
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectOutputStream.class), "defaultWriteObject", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
            instructions.add(new InsnNode(177));
            method.instructions.insert(instructions);
            instructions.clear();
        }
        AbstractInsnNode insn = method.instructions.getFirst();
        while ((insn = this.searchNextInstruction(insn, i -> i.getOpcode() == 177)) != null) {
            InsnList insns = new InsnList();
            insns.add(new VarInsnNode(21, clearVarPos));
            LabelNode lblEndIf = new LabelNode();
            insns.add(new JumpInsnNode(153, lblEndIf));
            insns.add(new VarInsnNode(25, 0));
            insns.add(new InsnNode(1));
            insns.add(new MethodInsnNode(182, classNode.name, "pcSetDetachedState", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Object.class))));
            insns.add(lblEndIf);
            method.instructions.insertBefore(insn, insns);
            insn = insn.getNext();
        }
        method.instructions.insert(instructions);
    }

    private void modifyReadObjectMethod(ClassNode classNode, MethodNode method, boolean full) {
        InsnList instructions = new InsnList();
        if ("`syn".equals(this._meta.getDetachedState())) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new FieldInsnNode(178, Type.getInternalName(PersistenceCapable.class), "DESERIALIZED", Type.getDescriptor(Object.class)));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcSetDetachedState", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT)));
        }
        if (full) {
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(182, Type.getInternalName(ObjectInputStream.class), "defaultReadObject", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0])));
            instructions.add(new InsnNode(177));
        }
        method.instructions.insert(instructions);
    }

    private void addIsDetachedMethod(ClassNode classNode) throws NoSuchMethodException {
        MethodNode isDetachedMeth = new MethodNode(1, "pcIsDetached", Type.getMethodDescriptor(Type.getType(Boolean.class), new Type[0]), null, null);
        classNode.methods.add(isDetachedMeth);
        boolean needsDefinitiveMethod = this.writeIsDetachedMethod(classNode, isDetachedMeth);
        if (!needsDefinitiveMethod) {
            return;
        }
        MethodNode isDetachedStateDefinitiveMeth = new MethodNode(2, ISDETACHEDSTATEDEFINITIVE, Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), null, null);
        classNode.methods.add(isDetachedStateDefinitiveMeth);
        isDetachedStateDefinitiveMeth.instructions.add(AsmHelper.getLoadConstantInsn(false));
        isDetachedStateDefinitiveMeth.instructions.add(new InsnNode(172));
    }

    private boolean writeIsDetachedMethod(ClassNode classNode, MethodNode meth) throws NoSuchMethodException {
        InsnList instructions = meth.instructions;
        if (!this._meta.isDetachable()) {
            instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
            instructions.add(new InsnNode(176));
            return false;
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode lblEndIfNull = new LabelNode();
        instructions.add(new JumpInsnNode(198, lblEndIfNull));
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "isDetached", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
        LabelNode lblEndIfFalse = new LabelNode();
        instructions.add(new JumpInsnNode(153, lblEndIfFalse));
        instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
        instructions.add(new InsnNode(176));
        instructions.add(lblEndIfFalse);
        instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
        instructions.add(new InsnNode(176));
        Boolean state = this._meta.usesDetachedState();
        LabelNode lblNotDeser = null;
        if (state != Boolean.FALSE) {
            instructions.add(lblEndIfNull);
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcGetDetachedState", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            lblEndIfNull = new LabelNode();
            instructions.add(new JumpInsnNode(198, lblEndIfNull));
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcGetDetachedState", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            instructions.add(new FieldInsnNode(178, Type.getInternalName(PersistenceCapable.class), "DESERIALIZED", AsmHelper.TYPE_OBJECT.getDescriptor()));
            lblNotDeser = new LabelNode();
            instructions.add(new JumpInsnNode(165, lblNotDeser));
            instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
            instructions.add(new InsnNode(176));
            if (state == Boolean.TRUE) {
                instructions.add(lblEndIfNull);
                instructions.add(lblNotDeser);
                instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
                instructions.add(new InsnNode(176));
                return false;
            }
        }
        instructions.add(lblEndIfNull);
        if (lblNotDeser != null) {
            instructions.add(lblNotDeser);
        }
        FieldMetaData version = this._meta.getVersionField();
        if (state != Boolean.TRUE && version != null) {
            instructions.add(new VarInsnNode(25, 0));
            this.addGetManagedValueCode(classNode, instructions, version, true);
            LabelNode lblAfterDefault = PCEnhancer.ifDefaultValue(instructions, version);
            instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
            instructions.add(new InsnNode(176));
            instructions.add(lblAfterDefault);
            if (!this._addVersionInitFlag) {
                instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
                instructions.add(new InsnNode(176));
            } else {
                instructions.add(new VarInsnNode(25, 0));
                this.getfield(classNode, instructions, null, VERSION_INIT_STR, Boolean.TYPE);
                LabelNode lblAfterEq = new LabelNode();
                instructions.add(new JumpInsnNode(153, lblAfterEq));
                instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
                instructions.add(new InsnNode(176));
                instructions.add(lblAfterEq);
                instructions.add(AsmHelper.getLoadConstantInsn(null));
                instructions.add(new InsnNode(176));
            }
            return false;
        }
        LabelNode ifIns = null;
        LabelNode ifIns2 = null;
        if (state != Boolean.TRUE && this._meta.getIdentityType() == 2) {
            FieldMetaData[] pks;
            for (FieldMetaData pk : pks = this._meta.getPrimaryKeyFields()) {
                if (pk.getValueStrategy() == 0) continue;
                if (ifIns != null) {
                    instructions.add(ifIns);
                }
                if (ifIns2 != null) {
                    instructions.add(ifIns2);
                }
                ifIns2 = null;
                instructions.add(new VarInsnNode(25, 0));
                this.addGetManagedValueCode(classNode, instructions, pk, true);
                ifIns = PCEnhancer.ifDefaultValue(instructions, pk);
                if (pk.getDeclaredTypeCode() == 9) {
                    instructions.add(AsmHelper.getLoadConstantInsn(""));
                    instructions.add(new VarInsnNode(25, 0));
                    this.addGetManagedValueCode(classNode, instructions, pk, true);
                    instructions.add(new MethodInsnNode(182, Type.getInternalName(String.class), "equals", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, AsmHelper.TYPE_OBJECT)));
                    ifIns2 = new LabelNode();
                    instructions.add(new JumpInsnNode(154, ifIns2));
                }
                instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
                instructions.add(new InsnNode(176));
            }
        }
        if (ifIns != null) {
            instructions.add(ifIns);
        }
        if (ifIns2 != null) {
            instructions.add(ifIns2);
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new MethodInsnNode(183, classNode.name, ISDETACHEDSTATEDEFINITIVE, Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0])));
        LabelNode lblAfterNe = new LabelNode();
        instructions.add(new JumpInsnNode(154, lblAfterNe));
        instructions.add(AsmHelper.getLoadConstantInsn(null));
        instructions.add(new InsnNode(176));
        instructions.add(lblAfterNe);
        if (!(state != null || "`syn".equals(this._meta.getDetachedState()) && Serializable.class.isAssignableFrom(this._meta.getDescribedType()) && this._repos.getConfiguration().getDetachStateInstance().isDetachedStateTransient())) {
            instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
            instructions.add(new InsnNode(176));
            return true;
        }
        if (state == null) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcGetDetachedState", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            LabelNode lblIfNn = new LabelNode();
            instructions.add(new JumpInsnNode(199, lblIfNn));
            instructions.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
            instructions.add(new InsnNode(176));
            instructions.add(lblIfNn);
        }
        instructions.add(AsmHelper.getLoadConstantInsn(null));
        instructions.add(new InsnNode(176));
        return true;
    }

    private static LabelNode ifDefaultValue(InsnList instructions, FieldMetaData fmd) {
        LabelNode lbl = new LabelNode();
        switch (fmd.getDeclaredTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                instructions.add(new JumpInsnNode(153, lbl));
                break;
            }
            case 3: {
                instructions.add(AsmHelper.getLoadConstantInsn(0.0));
                instructions.add(new InsnNode(151));
                instructions.add(new JumpInsnNode(153, lbl));
                break;
            }
            case 4: {
                instructions.add(AsmHelper.getLoadConstantInsn(Float.valueOf(0.0f)));
                instructions.add(new InsnNode(149));
                instructions.add(new JumpInsnNode(153, lbl));
                break;
            }
            case 6: {
                instructions.add(AsmHelper.getLoadConstantInsn(0L));
                instructions.add(new InsnNode(148));
                instructions.add(new JumpInsnNode(153, lbl));
                break;
            }
            default: {
                instructions.add(new JumpInsnNode(198, lbl));
            }
        }
        return lbl;
    }

    private MethodNode getOrCreateClassInitMethod(ClassNode classNode) {
        Optional<MethodNode> clinitMethodNode = classNode.methods.stream().filter(m -> m.name.equals("<clinit>")).findFirst();
        if (clinitMethodNode.isPresent()) {
            return clinitMethodNode.get();
        }
        MethodNode clinit = new MethodNode(8, "<clinit>", "()V", null, null);
        clinit.instructions.add(new InsnNode(177));
        classNode.methods.add(clinit);
        return clinit;
    }

    private void addCloningCode() {
        if (this._meta.getPCSuperclass() != null && !this.getCreateSubclass()) {
            return;
        }
        ClassNode classNode = this.pc.getClassNode();
        MethodNode cloneMeth = AsmHelper.getMethodNode(classNode, "clone", Object.class, new Class[0]).orElse(null);
        String superName = this.managedType.getClassNode().superName;
        if (cloneMeth == null) {
            boolean isCloneable = Cloneable.class.isAssignableFrom(this.managedType.getType());
            boolean extendsObject = superName.equals(Object.class.getName());
            if (!isCloneable || !extendsObject && !this.getCreateSubclass()) {
                return;
            }
            if (!this.getCreateSubclass() && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("enhance-cloneable", this.managedType.getClassNode().name));
            }
            if (!this.setVisibilityToSuperMethod(cloneMeth = new MethodNode(0, "clone", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]), null, new String[]{Type.getInternalName(CloneNotSupportedException.class)}))) {
                cloneMeth.access |= 4;
            }
            cloneMeth.instructions.add(new VarInsnNode(25, 0));
            cloneMeth.instructions.add(new MethodInsnNode(183, superName, "clone", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            cloneMeth.instructions.add(new InsnNode(176));
        } else if (cloneMeth.instructions.size() <= 1) {
            return;
        }
        AbstractInsnNode insn = cloneMeth.instructions.getFirst();
        insn = this.searchNextInstruction(insn, i -> i.getOpcode() == 183 && i instanceof MethodInsnNode && ((MethodInsnNode)i).name.equals("clone"));
        if (insn != null) {
            InsnList instructions = new InsnList();
            instructions.add(new InsnNode(89));
            instructions.add(new TypeInsnNode(192, this.pc.getClassNode().name));
            instructions.add(new InsnNode(1));
            instructions.add(new FieldInsnNode(181, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            cloneMeth.instructions.insert(insn, instructions);
        }
    }

    public AuxiliaryEnhancer[] getAuxiliaryEnhancers() {
        return _auxEnhancers;
    }

    private void runAuxiliaryEnhancers() {
        for (AuxiliaryEnhancer auxEnhancer : _auxEnhancers) {
            auxEnhancer.run(this.pc.getClassNode(), this._meta);
        }
    }

    private boolean skipEnhance(MethodNode method) {
        if ("<init>".equals(method.name) || "<clinit>".equals(method.name)) {
            return true;
        }
        for (AuxiliaryEnhancer auxEnhancer : _auxEnhancers) {
            if (!auxEnhancer.skipEnhance(method)) continue;
            return true;
        }
        return false;
    }

    private void addAccessors(ClassNodeTracker cnt) throws NoSuchMethodException {
        ClassNode classNode = cnt.getClassNode();
        FieldMetaData[] fmds = this.getCreateSubclass() ? this._meta.getFields() : this._meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (this.getCreateSubclass()) {
                if (this.getRedefine() || !this.isPropertyAccess(fmds[i])) continue;
                this.addSubclassSetMethod(classNode, fmds[i]);
                this.addSubclassGetMethod(classNode, fmds[i]);
                continue;
            }
            this.addGetMethod(classNode, i, fmds[i]);
            this.addSetMethod(classNode, i, fmds[i]);
        }
    }

    private void addSubclassSetMethod(ClassNode classNode, FieldMetaData fmd) throws NoSuchMethodException {
        Class propType = fmd.getDeclaredType();
        String setterName = PCEnhancer.getSetterName(fmd);
        MethodNode newMethod = new MethodNode(1, setterName, Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(propType)), null, null);
        classNode.methods.add(newMethod);
        InsnList instructions = newMethod.instructions;
        int nextFreeVarPos = 1 + Type.getType(propType).getSize();
        this.setVisibilityToSuperMethod(newMethod);
        if (!this.getRedefine()) {
            instructions.add(new VarInsnNode(25, 0));
            this.addGetManagedValueCode(classNode, instructions, fmd, true);
            int valVarPos = nextFreeVarPos++;
            instructions.add(new VarInsnNode(AsmHelper.getStoreInsn(fmd.getDeclaredType()), valVarPos));
            this.addNotifyMutation(classNode, newMethod, newMethod.instructions.getLast(), fmd, valVarPos, 0);
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(propType), 1));
        instructions.add(new MethodInsnNode(183, this.managedType.getClassNode().name, setterName, Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(propType))));
        instructions.add(new InsnNode(177));
    }

    private boolean setVisibilityToSuperMethod(MethodNode method) {
        ClassNode classNode = this.managedType.getClassNode();
        List methods = classNode.methods.stream().filter(m -> m.name.equals(method.name) && Objects.equals(m.parameters, method.parameters)).collect(Collectors.toList());
        if (methods.isEmpty()) {
            throw new UserException(_loc.get("no-accessor", this.managedType.getClassNode().name, method.name));
        }
        MethodNode superMeth = (MethodNode)methods.get(0);
        method.access &= 0xFFFFFFF8;
        if ((superMeth.access & 2) > 0) {
            method.access |= 2;
            return true;
        }
        if ((superMeth.access & 4) > 0) {
            method.access |= 4;
            return true;
        }
        if ((superMeth.access & 1) > 0) {
            method.access |= 1;
            return true;
        }
        return false;
    }

    private void addSubclassGetMethod(ClassNode classNode, FieldMetaData fmd) {
        String getterName;
        String finalGetterName = getterName = "get" + StringUtil.capitalize(fmd.getName());
        boolean hasGetter = this.managedType.getClassNode().methods.stream().filter(m -> m.name.equals(finalGetterName) && (m.parameters == null || m.parameters.isEmpty())).findAny().isPresent();
        if (!hasGetter) {
            getterName = "is" + StringUtil.capitalize(fmd.getName());
        }
        Class propType = fmd.getDeclaredType();
        MethodNode getterMethod = new MethodNode(1, getterName, Type.getMethodDescriptor(Type.getType(propType), new Type[0]), null, null);
        classNode.methods.add(getterMethod);
        InsnList instructions = getterMethod.instructions;
        if (!this.getRedefine()) {
            this.addNotifyAccess(getterMethod, getterMethod.instructions.getLast(), fmd);
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new MethodInsnNode(183, this.managedType.getClassNode().name, getterName, Type.getMethodDescriptor(Type.getType(propType), new Type[0])));
        instructions.add(new InsnNode(AsmHelper.getReturnInsn(propType)));
    }

    private void addGetMethod(ClassNode classNode, int index, FieldMetaData fmd) throws NoSuchMethodException {
        MethodNode method = this.createGetMethod(classNode, fmd);
        classNode.methods.add(method);
        InsnList instructions = method.instructions;
        int nextFreeVarPos = 1;
        byte fieldFlag = PCEnhancer.getFieldFlag(fmd);
        if ((fieldFlag & 1) == 0 && (fieldFlag & 2) == 0) {
            instructions.add(new VarInsnNode(25, 0));
            this.addGetManagedValueCode(classNode, instructions, fmd, true);
            instructions.add(new InsnNode(AsmHelper.getReturnInsn(fmd.getDeclaredType())));
            return;
        }
        instructions.add(this.loadManagedInstance());
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode afterIfNonNull = new LabelNode();
        instructions.add(new JumpInsnNode(199, afterIfNonNull));
        instructions.add(this.loadManagedInstance());
        this.addGetManagedValueCode(classNode, instructions, fmd, true);
        instructions.add(new InsnNode(AsmHelper.getReturnInsn(fmd.getDeclaredType())));
        instructions.add(afterIfNonNull);
        int fieldLocalVarPos = nextFreeVarPos++;
        instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add(new InsnNode(96));
        instructions.add(new VarInsnNode(54, fieldLocalVarPos));
        instructions.add(this.loadManagedInstance());
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(new VarInsnNode(21, fieldLocalVarPos));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "accessingField", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
        instructions.add(this.loadManagedInstance());
        this.addGetManagedValueCode(classNode, instructions, fmd, true);
        instructions.add(new InsnNode(AsmHelper.getReturnInsn(fmd.getDeclaredType())));
    }

    private void addSetMethod(ClassNode classNode, int index, FieldMetaData fmd) throws NoSuchMethodException {
        MethodNode method = this.createSetMethod(classNode, fmd);
        classNode.methods.add(method);
        InsnList instructions = method.instructions;
        int fieldParamPos = 1;
        instructions.add(this.loadManagedInstance());
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        LabelNode lblAfterIfNonNull = new LabelNode();
        instructions.add(new JumpInsnNode(199, lblAfterIfNonNull));
        instructions.add(this.loadManagedInstance());
        instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(fmd.getDeclaredType()), fieldParamPos));
        this.addSetManagedValueCode(classNode, instructions, fmd);
        if (fmd.isVersion() && this._addVersionInitFlag) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(AsmHelper.getLoadConstantInsn(1));
            instructions.add(new FieldInsnNode(181, classNode.name, VERSION_INIT_STR, Type.BOOLEAN_TYPE.getDescriptor()));
        }
        instructions.add(new InsnNode(177));
        instructions.add(lblAfterIfNonNull);
        instructions.add(this.loadManagedInstance());
        instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
        instructions.add(this.loadManagedInstance());
        instructions.add(new FieldInsnNode(178, classNode.name, INHERIT, Type.INT_TYPE.getDescriptor()));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add(new InsnNode(96));
        instructions.add(this.loadManagedInstance());
        this.addGetManagedValueCode(classNode, instructions, fmd, true);
        instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(fmd.getDeclaredType()), fieldParamPos));
        instructions.add(new InsnNode(3));
        Method stateMgrMethod = this.getStateManagerMethod(fmd.getDeclaredType(), "setting", false, true);
        instructions.add(new MethodInsnNode(185, Type.getInternalName(stateMgrMethod.getDeclaringClass()), stateMgrMethod.getName(), Type.getMethodDescriptor(stateMgrMethod)));
        instructions.add(new InsnNode(177));
    }

    private void addAttachDetachCode() throws NoSuchMethodException {
        boolean parentDetachable = false;
        for (ClassMetaData parent = this._meta.getPCSuperclassMetaData(); parent != null; parent = parent.getPCSuperclassMetaData()) {
            if (!parent.isDetachable()) continue;
            parentDetachable = true;
            break;
        }
        ClassNode classNode = this.pc.getClassNode();
        if (this._meta.getPCSuperclass() == null || this.getCreateSubclass() || parentDetachable != this._meta.isDetachable()) {
            this.addIsDetachedMethod(classNode);
            this.addDetachedStateMethods(this._meta.usesDetachedState() != Boolean.FALSE);
        }
        if (this.externalizeDetached()) {
            try {
                this.addDetachExternalize(parentDetachable, this._meta.usesDetachedState() != Boolean.FALSE);
            }
            catch (NoSuchMethodException nsme) {
                throw new GeneralException(nsme);
            }
        }
    }

    private void addDetachedStateMethods(boolean impl) {
        Field detachField = this._meta.getDetachedStateField();
        String name = null;
        Class<?> declarer = null;
        ClassNode classNode = this.pc.getClassNode();
        if (impl && detachField == null) {
            name = "pcDetachedState";
            FieldNode field = new FieldNode(130, name, AsmHelper.TYPE_OBJECT.getDescriptor(), null, null);
            classNode.fields.add(field);
        } else if (impl) {
            name = detachField.getName();
            declarer = detachField.getDeclaringClass();
        }
        MethodNode getDetachedStateMeth = new MethodNode(1, "pcGetDetachedState", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0]), null, null);
        classNode.methods.add(getDetachedStateMeth);
        if (impl) {
            getDetachedStateMeth.instructions.add(new VarInsnNode(25, 0));
            this.getfield(classNode, getDetachedStateMeth.instructions, declarer, name, Object.class);
        } else {
            getDetachedStateMeth.instructions.add(new InsnNode(1));
        }
        getDetachedStateMeth.instructions.add(new InsnNode(176));
        MethodNode setDetachedStateMeth = new MethodNode(1, "pcSetDetachedState", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT), null, null);
        classNode.methods.add(setDetachedStateMeth);
        if (impl) {
            setDetachedStateMeth.instructions.add(new VarInsnNode(25, 0));
            setDetachedStateMeth.instructions.add(new VarInsnNode(25, 1));
            this.putfield(classNode, setDetachedStateMeth.instructions, declarer, name, Object.class);
        }
        setDetachedStateMeth.instructions.add(new InsnNode(177));
    }

    private void getfield(ClassNode classNode, InsnList instructions, Class declarer, String attrName, Class fieldType) {
        String fieldName = this.toBackingFieldName(attrName);
        FieldNode field = this.findField(classNode, declarer, fieldName);
        if (this.getCreateSubclass() && (field == null || (field.access & 1) <= 0)) {
            instructions.add(AsmHelper.getLoadConstantInsn(declarer));
            instructions.add(AsmHelper.getLoadConstantInsn(fieldName));
            instructions.add(new InsnNode(4));
            instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findField", Type.getMethodDescriptor(Type.getType(Field.class), Type.getType(Class.class), Type.getType(String.class), Type.BOOLEAN_TYPE)));
            try {
                Method getterMethod = this.getReflectionGetterMethod(fieldType, Field.class);
                instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), getterMethod.getName(), Type.getMethodDescriptor(getterMethod)));
            }
            catch (NoSuchMethodException e) {
                throw new InternalException(e);
            }
            if (!fieldType.isPrimitive() && fieldType != Object.class) {
                instructions.add(new TypeInsnNode(192, Type.getInternalName(fieldType)));
            }
        } else {
            String owner = declarer != null ? Type.getInternalName(declarer) : classNode.name;
            instructions.add(new FieldInsnNode(180, owner, fieldName, Type.getDescriptor(fieldType)));
        }
    }

    private FieldNode findField(ClassNode classNode, Class clazz, String fieldName) {
        Object field;
        if (classNode != null && ((Optional)(field = classNode.fields.stream().filter(f -> f.name.equals(fieldName)).findFirst())).isPresent()) {
            return (FieldNode)((Optional)field).get();
        }
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(fieldName);
            return new FieldNode(2, ((Field)field).getName(), Type.getDescriptor(((Field)field).getType()), null, null);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != Object.class) {
                return this.findField(null, clazz.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    private void putfield(ClassNode classNode, InsnList instructions, Class declarer, String attrName, Class fieldType) {
        String fieldName = this.toBackingFieldName(attrName);
        if (this.getRedefine() || this.getCreateSubclass()) {
            instructions.add(AsmHelper.getLoadConstantInsn(declarer));
            instructions.add(AsmHelper.getLoadConstantInsn(fieldName));
            instructions.add(new InsnNode(4));
            instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "findField", Type.getMethodDescriptor(Type.getType(Field.class), Type.getType(Class.class), Type.getType(String.class), Type.BOOLEAN_TYPE)));
            instructions.add(new MethodInsnNode(184, Type.getInternalName(Reflection.class), "set", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT, fieldType.isPrimitive() ? Type.getType(fieldType) : AsmHelper.TYPE_OBJECT, Type.getType(Field.class))));
        } else {
            String owner = declarer != null ? Type.getInternalName(declarer) : classNode.name;
            instructions.add(new FieldInsnNode(181, owner, fieldName, Type.getDescriptor(fieldType)));
        }
    }

    private String toBackingFieldName(String name) {
        FieldMetaData fmd;
        FieldMetaData fieldMetaData = fmd = this._meta == null ? null : this._meta.getField(name);
        if (this._meta != null && this.isPropertyAccess(fmd) && this._attrsToFields != null && this._attrsToFields.containsKey(name)) {
            name = this._attrsToFields.get(name);
        }
        return name;
    }

    private String fromBackingFieldName(String name) {
        FieldMetaData fmd;
        FieldMetaData fieldMetaData = fmd = this._meta == null ? null : this._meta.getField(name);
        if (this._meta != null && this.isPropertyAccess(fmd) && this._fieldsToAttrs != null && this._fieldsToAttrs.containsKey(name)) {
            return this._fieldsToAttrs.get(name);
        }
        return name;
    }

    private void addDetachExternalize(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        MethodNode ctNode = this.pc.getClassNode().methods.stream().filter(m -> m.name.equals("<init>") && m.desc.equals("()V")).findAny().get();
        if ((ctNode.access & 1) == 0) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("enhance-defcons-extern", this._meta.getDescribedType()));
            }
            ctNode.access = ctNode.access & 0xFFFFFFFD & 0xFFFFFFFB | 1;
        }
        if (!Externalizable.class.isAssignableFrom(this._meta.getDescribedType())) {
            this.pc.declareInterface(Externalizable.class);
        }
        String readObjectDesc = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInputStream.class));
        boolean hasReadObject = this.managedType.getClassNode().methods.stream().anyMatch(m -> m.name.equals("readObject") && m.desc.equals(readObjectDesc));
        String writeObjectDesc = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectOutput.class));
        boolean hasWriteObject = this.managedType.getClassNode().methods.stream().anyMatch(m -> m.name.equals("writeObject") && m.desc.equals(writeObjectDesc));
        if (hasReadObject || hasWriteObject) {
            throw new UserException(_loc.get("detach-custom-ser", this._meta));
        }
        String readExternalDesc = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInput.class));
        boolean hasReadExternal = this.managedType.getClassNode().methods.stream().anyMatch(m -> m.name.equals("readExternal") && m.desc.equals(readExternalDesc));
        String writeExternalDesc = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInput.class));
        boolean hasWriteExternal = this.managedType.getClassNode().methods.stream().anyMatch(m -> m.name.equals("writeExternal") && m.desc.equals(writeExternalDesc));
        if (hasReadExternal || hasWriteExternal) {
            throw new UserException(_loc.get("detach-custom-extern", this._meta));
        }
        List<FieldNode> fields = this.managedType.getClassNode().fields;
        ArrayList<FieldNode> unmgd = new ArrayList<FieldNode>(fields.size());
        for (FieldNode field : fields) {
            if ((field.access & 0x98) != 0 || field.name.startsWith(PRE) || this._meta.getDeclaredField(field.name) != null) continue;
            unmgd.add(field);
        }
        this.addReadExternal(parentDetachable, detachedState);
        this.addReadUnmanaged(unmgd, parentDetachable);
        this.addWriteExternal(parentDetachable, detachedState);
        this.addWriteUnmanaged(unmgd, parentDetachable);
    }

    private void addReadExternal(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInput.class));
        MethodNode readExternalMeth = new MethodNode(1, "readExternal", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(readExternalMeth);
        InsnList instructions = readExternalMeth.instructions;
        Class<?> sup = this._meta.getDescribedType().getSuperclass();
        if (!parentDetachable && Externalizable.class.isAssignableFrom(sup)) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(sup), "readExternal", methodDescriptor));
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(182, Type.getInternalName(this.getType(this._meta)), "pcReadUnmanaged", methodDescriptor));
        if (detachedState) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectInput.class), "readObject", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcSetDetachedState", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT)));
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectInput.class), "readObject", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            instructions.add(new TypeInsnNode(192, Type.getInternalName(StateManager.class)));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcReplaceStateManager", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(StateManager.class))));
        }
        this.addReadExternalFields();
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(182, classNode.name, "readExternalFields", methodDescriptor));
        instructions.add(new InsnNode(177));
    }

    private void addReadExternalFields() throws NoSuchMethodException {
        FieldMetaData[] fmds;
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInput.class));
        MethodNode readExternalMeth = new MethodNode(4, "readExternalFields", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(readExternalMeth);
        InsnList instructions = readExternalMeth.instructions;
        Class<?> sup = this._meta.getPCSuperclass();
        if (sup != null) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(sup), "readExternalFields", methodDescriptor));
        }
        for (FieldMetaData fmd : fmds = this._meta.getDeclaredFields()) {
            if (fmd.isTransient()) continue;
            this.readExternal(classNode, instructions, fmd.getName(), Type.getType(fmd.getDeclaredType()), fmd);
        }
        instructions.add(new InsnNode(177));
    }

    private void addReadUnmanaged(List<FieldNode> unmgd, boolean parentDetachable) throws NoSuchMethodException {
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectInput.class));
        MethodNode readUnmanagedMeth = new MethodNode(4, "pcReadUnmanaged", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(readUnmanagedMeth);
        InsnList instructions = readUnmanagedMeth.instructions;
        if (parentDetachable) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(this.getType(this._meta.getPCSuperclassMetaData())), "pcReadUnmanaged", methodDescriptor));
        }
        for (FieldNode field : unmgd) {
            this.readExternal(classNode, instructions, field.name, Type.getType(field.desc), null);
        }
        instructions.add(new InsnNode(177));
    }

    private void readExternal(ClassNode classNode, InsnList instructions, String fieldName, Type fieldType, FieldMetaData fmd) throws NoSuchMethodException {
        Object methName;
        boolean isPrimitive;
        if (fieldType == null) {
            fieldType = Type.getType(fmd.getDeclaredType());
        }
        String typeName = fieldType.getClassName();
        boolean bl = isPrimitive = fieldType.getSort() != 10 && fieldType.getSort() != 9;
        if (isPrimitive) {
            methName = typeName.substring(0, 1).toUpperCase(Locale.ENGLISH) + typeName.substring(1);
            methName = "read" + (String)methName;
        } else {
            methName = "readObject";
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        Type retType = isPrimitive ? fieldType : AsmHelper.TYPE_OBJECT;
        instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectInput.class), (String)methName, Type.getMethodDescriptor(retType, new Type[0])));
        if (!isPrimitive && !fieldType.getClassName().equals(Object.class.getName())) {
            instructions.add(new TypeInsnNode(192, fieldType.getInternalName()));
        }
        if (fmd == null) {
            Class<?> type = AsmHelper.getDescribedClass(this.pc.getClassLoader(), fieldType.getDescriptor());
            if (type == null) {
                throw new RuntimeException("Cannot Load class " + fieldType.getDescriptor());
            }
            this.putfield(classNode, instructions, null, fieldName, type);
        } else {
            this.addSetManagedValueCode(classNode, instructions, fmd);
            switch (fmd.getDeclaredTypeCode()) {
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 28: {
                    instructions.add(new VarInsnNode(25, 0));
                    instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                    LabelNode lblEndIf = new LabelNode();
                    instructions.add(new JumpInsnNode(198, lblEndIf));
                    instructions.add(new VarInsnNode(25, 0));
                    instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
                    instructions.add(AsmHelper.getLoadConstantInsn(fmd.getIndex()));
                    instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "proxyDetachedDeserialized", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE)));
                    instructions.add(lblEndIf);
                }
            }
        }
    }

    private void addWriteExternal(boolean parentDetachable, boolean detachedState) throws NoSuchMethodException {
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectOutput.class));
        MethodNode writeExternalMeth = new MethodNode(1, "writeExternal", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(writeExternalMeth);
        InsnList instructions = writeExternalMeth.instructions;
        Class sup = this.getType(this._meta).getSuperclass();
        if (!parentDetachable && Externalizable.class.isAssignableFrom(sup)) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(sup), "writeExternal", methodDescriptor));
        }
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(182, Type.getInternalName(this.getType(this._meta)), "pcWriteUnmanaged", methodDescriptor));
        LabelNode go2 = null;
        if (detachedState) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            LabelNode endIfNull = new LabelNode();
            instructions.add(new JumpInsnNode(198, endIfNull));
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new FieldInsnNode(180, classNode.name, SM, Type.getDescriptor(SMTYPE)));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(185, Type.getInternalName(SMTYPE), "writeDetached", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.getType(ObjectOutput.class))));
            go2 = new LabelNode();
            instructions.add(new JumpInsnNode(153, go2));
            instructions.add(new InsnNode(177));
            instructions.add(endIfNull);
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new MethodInsnNode(182, classNode.name, "pcGetDetachedState", Type.getMethodDescriptor(AsmHelper.TYPE_OBJECT, new Type[0])));
            instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectOutput.class), "writeObject", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT)));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(AsmHelper.getLoadConstantInsn(null));
            instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectOutput.class), "writeObject", Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT)));
        }
        if (go2 != null) {
            instructions.add(go2);
        }
        this.addWriteExternalFields();
        instructions.add(new VarInsnNode(25, 0));
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new MethodInsnNode(182, classNode.name, "writeExternalFields", methodDescriptor));
        instructions.add(new InsnNode(177));
    }

    private void addWriteExternalFields() throws NoSuchMethodException {
        FieldMetaData[] fmds;
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectOutput.class));
        MethodNode writeExternalFieldsMeth = new MethodNode(4, "writeExternalFields", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(writeExternalFieldsMeth);
        InsnList instructions = writeExternalFieldsMeth.instructions;
        Class<?> sup = this._meta.getPCSuperclass();
        if (sup != null) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(sup), "writeExternalFields", methodDescriptor));
        }
        for (FieldMetaData fmd : fmds = this._meta.getDeclaredFields()) {
            if (fmd.isTransient()) continue;
            this.writeExternal(classNode, instructions, fmd.getName(), Type.getType(fmd.getDeclaredType()), fmd);
        }
        instructions.add(new InsnNode(177));
    }

    private void addWriteUnmanaged(List<FieldNode> unmgd, boolean parentDetachable) throws NoSuchMethodException {
        String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(ObjectOutput.class));
        MethodNode writeUnmanagedMeth = new MethodNode(4, "pcWriteUnmanaged", methodDescriptor, null, new String[]{Type.getInternalName(IOException.class)});
        ClassNode classNode = this.pc.getClassNode();
        classNode.methods.add(writeUnmanagedMeth);
        InsnList instructions = writeUnmanagedMeth.instructions;
        if (parentDetachable) {
            instructions.add(new VarInsnNode(25, 0));
            instructions.add(new VarInsnNode(25, 1));
            instructions.add(new MethodInsnNode(183, Type.getInternalName(this.getType(this._meta.getPCSuperclassMetaData())), "pcWriteUnmanaged", methodDescriptor));
        }
        for (FieldNode field : unmgd) {
            this.writeExternal(classNode, instructions, field.name, Type.getType(field.desc), null);
        }
        instructions.add(new InsnNode(177));
    }

    private void writeExternal(ClassNode classNode, InsnList instructions, String fieldName, Type fieldType, FieldMetaData fmd) throws NoSuchMethodException {
        Object methName;
        boolean isPrimitive;
        String typeName = fieldType.getClassName();
        boolean bl = isPrimitive = fieldType.getSort() != 10 && fieldType.getSort() != 9;
        if (isPrimitive) {
            methName = typeName.substring(0, 1).toUpperCase(Locale.ENGLISH) + typeName.substring(1);
            methName = "write" + (String)methName;
        } else {
            methName = "writeObject";
        }
        instructions.add(new VarInsnNode(25, 1));
        instructions.add(new VarInsnNode(25, 0));
        if (fmd == null) {
            Class<?> type = AsmHelper.getDescribedClass(this.pc.getClassLoader(), fieldType.getDescriptor());
            this.getfield(classNode, instructions, null, fieldName, type);
        } else {
            this.addGetManagedValueCode(classNode, instructions, fmd, true);
        }
        String mdesc = fieldType.getSort() == 3 || fieldType.getSort() == 2 || fieldType.getSort() == 4 ? Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE) : (!isPrimitive ? Type.getMethodDescriptor(Type.VOID_TYPE, AsmHelper.TYPE_OBJECT) : Type.getMethodDescriptor(Type.VOID_TYPE, fieldType));
        instructions.add(new MethodInsnNode(185, Type.getInternalName(ObjectOutput.class), (String)methName, mdesc));
    }

    private void addGetManagedValueCode(ClassNode classNode, InsnList instructions, FieldMetaData fmd, boolean fromSameClass) {
        if (this.getRedefine() || this.isFieldAccess(fmd)) {
            this.getfield(classNode, instructions, this.getType(this._meta), fmd.getName(), fmd.getDeclaredType());
        } else if (this.getCreateSubclass()) {
            if (fromSameClass) {
                Method meth = (Method)fmd.getBackingMember();
                instructions.add(new MethodInsnNode(183, Type.getInternalName(meth.getDeclaringClass()), meth.getName(), Type.getMethodDescriptor(meth)));
            } else {
                this.getfield(classNode, instructions, this.getType(this._meta), fmd.getName(), fmd.getDeclaredType());
            }
        } else {
            Method meth = (Method)fmd.getBackingMember();
            instructions.add(new MethodInsnNode(182, classNode.name, PRE + meth.getName(), Type.getMethodDescriptor(meth)));
        }
    }

    private InsnList getSetValueInsns(ClassNode classNode, FieldMetaData fmd, Object value) {
        InsnList instructions = new InsnList();
        if (value == null) {
            instructions.add(new InsnNode(1));
        } else {
            instructions.add(AsmHelper.getLoadConstantInsn(value));
        }
        if (this.getRedefine() || this.isFieldAccess(fmd)) {
            this.putfield(classNode, instructions, fmd.getDeclaringType(), fmd.getName(), fmd.getDeclaredType());
        } else if (this.getCreateSubclass()) {
            instructions.add(new MethodInsnNode(183, this.managedType.getClassNode().name, PCEnhancer.getSetterName(fmd), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(fmd.getDeclaredType()))));
        } else {
            instructions.add(new MethodInsnNode(182, classNode.name, PRE + PCEnhancer.getSetterName(fmd), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(fmd.getDeclaredType()))));
        }
        return instructions;
    }

    private void addSetManagedValueCode(ClassNode classNode, InsnList instructions, FieldMetaData fmd) {
        if (this.getRedefine() || this.isFieldAccess(fmd)) {
            this.putfield(classNode, instructions, this.getType(this._meta), fmd.getName(), fmd.getDeclaredType());
        } else if (this.getCreateSubclass()) {
            instructions.add(new MethodInsnNode(183, classNode.superName, PCEnhancer.getSetterName(fmd), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(fmd.getDeclaredType()))));
        } else {
            instructions.add(new MethodInsnNode(182, classNode.name, PRE + PCEnhancer.getSetterName(fmd), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(fmd.getDeclaredType()))));
        }
    }

    private AbstractInsnNode loadManagedInstance() {
        return new VarInsnNode(25, 0);
    }

    boolean isPropertyAccess(ClassMetaData meta) {
        return meta != null && (meta.isMixedAccess() || AccessCode.isProperty(meta.getAccessType()));
    }

    boolean isPropertyAccess(FieldMetaData fmd) {
        return fmd != null && AccessCode.isProperty(fmd.getAccessType());
    }

    boolean isFieldAccess(FieldMetaData fmd) {
        return fmd != null && AccessCode.isField(fmd.getAccessType());
    }

    private MethodNode createGetMethod(ClassNode classNode, FieldMetaData fmd) {
        if (this.isFieldAccess(fmd)) {
            FieldNode field = classNode.fields.stream().filter(f -> f.name.equals(fmd.getName())).findFirst().get();
            MethodNode getter = new MethodNode(field.access & 0xFFFFFF7F & 0xFFFFFFBF | 0x10 | 8, "pcGet" + fmd.getName(), Type.getMethodDescriptor(Type.getType(fmd.getDeclaredType()), Type.getObjectType(classNode.name)), null, null);
            return getter;
        }
        Method meth = (Method)fmd.getBackingMember();
        MethodNode getter = AsmHelper.getMethodNode(classNode, meth).get();
        MethodNode newGetter = new MethodNode(getter.access, meth.getName(), Type.getMethodDescriptor(meth), null, null);
        getter.name = PRE + meth.getName();
        getter.access = getter.access & 0xFFFFFFFE & 0xFFFFFFFD | 4;
        this.moveAnnotations(getter, newGetter);
        newGetter.signature = getter.signature;
        return newGetter;
    }

    private void moveAnnotations(MethodNode from, MethodNode to) {
        if (from.visibleAnnotations != null) {
            if (to.visibleAnnotations == null) {
                to.visibleAnnotations = new ArrayList<AnnotationNode>();
            }
            to.visibleAnnotations.addAll(from.visibleAnnotations);
            from.visibleAnnotations.clear();
        }
    }

    private MethodNode createSetMethod(ClassNode classNode, FieldMetaData fmd) {
        if (this.isFieldAccess(fmd)) {
            FieldNode field = classNode.fields.stream().filter(f -> f.name.equals(fmd.getName())).findFirst().get();
            MethodNode setter = new MethodNode(field.access & 0xFFFFFF7F & 0xFFFFFFBF | 0x10 | 8, "pcSet" + fmd.getName(), Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(this.getType(this._meta)), Type.getType(fmd.getDeclaredType())), null, null);
            return setter;
        }
        MethodNode setter = AsmHelper.getMethodNode(classNode, PCEnhancer.getSetterName(fmd), Void.TYPE, fmd.getDeclaredType()).get();
        String setterName = setter.name;
        MethodNode newSetter = new MethodNode(setter.access, setterName, setter.desc, null, null);
        setter.name = PRE + setterName;
        setter.access = setter.access & 0xFFFFFFFD & 0xFFFFFFFE | 4;
        this.moveAnnotations(setter, newSetter);
        newSetter.signature = setter.signature;
        return newSetter;
    }

    private void addGetEnhancementContractVersionMethod(ClassNodeTracker cnt) {
        MethodNode methodNode = new MethodNode(1, "pcGetEnhancementContractVersion", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), null, null);
        methodNode.instructions.add(AsmHelper.getLoadConstantInsn(ENHANCER_VERSION));
        methodNode.instructions.add(new InsnNode(172));
        cnt.getClassNode().methods.add(methodNode);
    }

    public Class getType(ClassMetaData meta) {
        if (meta.getInterfaceImpl() != null) {
            return meta.getInterfaceImpl();
        }
        return meta.getDescribedType();
    }

    public static void main(String[] args) {
        Options opts = new Options();
        if (!PCEnhancer.run(args = opts.setFromCmdLine(args), opts)) {
            System.err.println(_loc.get("enhance-usage"));
        }
    }

    public static boolean run(String[] args, Options opts) {
        return Configurations.runAgainstAllAnchors(opts, opts1 -> {
            try (OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();){
                boolean bl = PCEnhancer.run(conf, args, opts1);
                return bl;
            }
        });
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Options opts) throws IOException {
        Flags flags = new Flags();
        flags.directory = org.apache.openjpa.lib.util.Files.getFile(opts.removeProperty("directory", "d", null), null);
        flags.addDefaultConstructor = opts.removeBooleanProperty("addDefaultConstructor", "adc", flags.addDefaultConstructor);
        flags.tmpClassLoader = opts.removeBooleanProperty("tmpClassLoader", "tcl", flags.tmpClassLoader);
        flags.enforcePropertyRestrictions = opts.removeBooleanProperty("enforcePropertyRestrictions", "epr", flags.enforcePropertyRestrictions);
        BytecodeWriter writer = (BytecodeWriter)opts.get(PCEnhancer.class.getName() + "#bytecodeWriter");
        Configurations.populateConfiguration(conf, opts);
        return PCEnhancer.run(conf, args, flags, null, writer, null);
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Flags flags, MetaDataRepository repos, BytecodeWriter writer, ClassLoader loader) throws IOException {
        Set<String> classes;
        if (loader == null) {
            loader = conf.getClassResolverInstance().getClassLoader(PCEnhancer.class, null);
        }
        if (flags.tmpClassLoader) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction(loader));
        }
        if (repos == null) {
            repos = conf.newMetaDataRepositoryInstance();
            repos.setSourceMode(1);
        }
        Log log = conf.getLog("openjpa.Tool");
        if (args == null || args.length == 0) {
            classes = repos.getPersistentTypeNames(true, loader);
            if (classes == null) {
                log.warn(_loc.get("no-class-to-enhance"));
                return false;
            }
        } else {
            ClassArgParser cap = conf.getMetaDataRepositoryInstance().getMetaDataFactory().newClassArgParser();
            cap.setClassLoader(loader);
            classes = new HashSet<String>();
            for (String arg : args) {
                classes.addAll(Arrays.asList(cap.parseTypes(arg)));
            }
        }
        EnhancementProject project = new EnhancementProject();
        HashSet persAwareClasses = new HashSet();
        for (Object e : classes) {
            if (log.isInfoEnabled()) {
                log.info(_loc.get("enhance-running", e));
            }
            ClassNodeTracker cnt = e instanceof String ? project.loadClass((String)e, loader) : project.loadClass((Class)e);
            PCEnhancer enhancer = new PCEnhancer(conf, cnt, repos, loader);
            if (writer != null) {
                enhancer.setBytecodeWriter(writer);
            }
            enhancer.setDirectory(flags.directory);
            enhancer.setAddDefaultConstructor(flags.addDefaultConstructor);
            int status = enhancer.run();
            if (status == 0) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("enhance-norun"));
                }
            } else if (status == 4) {
                if (log.isTraceEnabled()) {
                    log.trace(_loc.get("enhance-interface"));
                }
            } else if (status == 2) {
                persAwareClasses.add(e);
                enhancer.record();
            } else {
                enhancer.record();
            }
            project.clear();
        }
        if (log.isInfoEnabled() && !persAwareClasses.isEmpty()) {
            log.info(_loc.get("pers-aware-classes", persAwareClasses.size(), persAwareClasses));
        }
        return true;
    }

    private void addGetIDOwningClass() {
        MethodNode idOCMeth = new MethodNode(1, "pcGetIDOwningClass", Type.getMethodDescriptor(Type.getType(Class.class), new Type[0]), null, null);
        this.pc.getClassNode().methods.add(idOCMeth);
        idOCMeth.instructions.add(AsmHelper.getLoadConstantInsn(this.getType(this._meta)));
        idOCMeth.instructions.add(new InsnNode(176));
    }

    public static boolean checkEnhancementLevel(Class<?> cls, Log log) {
        if (cls == null || log == null) {
            return false;
        }
        PersistenceCapable pc = PCRegistry.newInstance(cls, null, false);
        if (pc == null) {
            return false;
        }
        if (pc.pcGetEnhancementContractVersion() < ENHANCER_VERSION) {
            log.info(_loc.get("down-level-enhanced-entity", new Object[]{cls.getName(), pc.pcGetEnhancementContractVersion(), ENHANCER_VERSION}));
            return true;
        }
        return false;
    }

    private void configureOptimizeIdCopy() {
        if (this._repos != null && this._repos.getConfiguration() != null) {
            this._optimizeIdCopy = this._repos.getConfiguration().getOptimizeIdCopy();
        }
    }

    private ArrayList<Integer> optimizeIdCopy(Class<?> oidType, FieldMetaData[] fmds) {
        ArrayList<Integer> pkFields = new ArrayList<Integer>();
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey()) continue;
            if (fmds[i].getDeclaredTypeCode() == 15) {
                return null;
            }
            String name = fmds[i].getName();
            Field fld = Reflection.findField(oidType, name, false);
            if (fld == null || Modifier.isPublic(fld.getModifiers())) {
                return null;
            }
            Method setter = Reflection.findSetter(oidType, name, false);
            if (setter == null || !Modifier.isPublic(setter.getModifiers())) {
                pkFields.add(i);
                continue;
            }
            return null;
        }
        return pkFields.size() > 0 ? pkFields : null;
    }

    private int[] getIdClassConstructorParmOrder(Class<?> oidType, List<Integer> pkfields, FieldMetaData[] fmds) {
        ClassNode classNode = AsmHelper.readClassNode(oidType);
        List cts = classNode.methods.stream().filter(m -> "<init>".equals(m.name)).collect(Collectors.toList());
        if (cts.isEmpty()) {
            return null;
        }
        int[] parmOrder = new int[pkfields.size()];
        for (MethodNode ct : cts) {
            if ((ct.access & 1) == 0) continue;
            Type[] argTypes = Type.getArgumentTypes(ct.desc);
            if (this.listSize(pkfields) != argTypes.length) continue;
            int parmOrderIndex = 0;
            AbstractInsnNode insn = ct.instructions.getFirst();
            while ((insn = this.searchNextInstruction(insn, i -> i.getOpcode() == 181)) != null) {
                FieldInsnNode putField = (FieldInsnNode)insn;
                for (int i2 = 0; i2 < pkfields.size(); ++i2) {
                    int fieldNum = pkfields.get(i2);
                    String parmName = fmds[fieldNum].getName();
                    Class parmType = fmds[fieldNum].getType();
                    if (!parmName.equals(putField.name)) continue;
                    if (!AsmHelper.isLoadInsn(insn.getPrevious())) break;
                    VarInsnNode loadInsn = (VarInsnNode)insn.getPrevious();
                    int parm = AsmHelper.getParamIndex(ct, loadInsn.var);
                    if (parm >= pkfields.size() || !argTypes[parm].equals(Type.getType(parmType))) continue;
                    parmOrder[parmOrderIndex] = fieldNum;
                    ++parmOrderIndex;
                }
                insn = insn.getNext();
            }
            if (parmOrderIndex != pkfields.size()) continue;
            return parmOrder;
        }
        return null;
    }

    private int listSize(Collection<?> coll) {
        return coll == null ? 0 : coll.size();
    }

    static {
        PCTYPE = PersistenceCapable.class;
        TYPE_PCTYPE = Type.getType(PersistenceCapable.class);
        SMTYPE = StateManager.class;
        USEREXCEP = UserException.class;
        INTERNEXCEP = InternalException.class;
        HELPERTYPE = PCRegistry.class;
        OIDFSTYPE = FieldSupplier.class;
        OIDFCTYPE = FieldConsumer.class;
        _loc = Localizer.forPackage(PCEnhancer.class);
        LONG_VALUE_OF = Stream.of(Long.class.getDeclaredMethods()).filter(m -> "valueOf".equals(m.getName()) && Long.TYPE == m.getParameterTypes()[0]).findAny().get();
        Class[] classes = Services.getImplementorClasses(AuxiliaryEnhancer.class, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(AuxiliaryEnhancer.class)));
        ArrayList auxEnhancers = new ArrayList(classes.length);
        for (Class aClass : classes) {
            try {
                auxEnhancers.add(AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(aClass)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _auxEnhancers = auxEnhancers.toArray(new AuxiliaryEnhancer[0]);
        int rev = 0;
        Properties revisionProps = new Properties();
        try {
            InputStream in = PCEnhancer.class.getResourceAsStream("/META-INF/org.apache.openjpa.revision.properties");
            if (in != null) {
                try (InputStream inputStream = in;){
                    revisionProps.load(in);
                }
            }
            rev = GitUtils.convertGitInfoToPCEnhancerVersion(revisionProps.getProperty("openjpa.enhancer.revision"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ENHANCER_VERSION = rev > 0 ? rev : 2;
    }

    public static interface AuxiliaryEnhancer {
        public void run(ClassNode var1, ClassMetaData var2);

        public boolean skipEnhance(MethodNode var1);
    }

    public static class Flags {
        public File directory = null;
        public boolean addDefaultConstructor = true;
        public boolean tmpClassLoader = true;
        public boolean enforcePropertyRestrictions = false;
    }
}

